/*
 * Decompiled with CFR 0.152.
 */
package org.interactivemesh.jfx.sample3d.tuxcube;

import java.text.NumberFormat;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.interactivemesh.jfx.sample3d.tuxcube.FXTuxCubeSubScene;

public final class FXTuxCube
extends Application {
    private SubScene subScene = null;
    private long lastTime = 0L;
    private int frameCounter = 0;
    private int elapsedFrames = 100;
    private AnimationTimer fpsTimer = null;
    private HUDLabel fpsTitleLabel = null;
    private HUDLabel fpsLabel = null;
    private HUDLabel mpfTitleLabel = null;
    private HUDLabel mpfLabel = null;
    private boolean isUpdateFPS = false;
    private boolean isTuxRotating = false;
    private boolean isCubeRotating = false;
    private boolean isMouseDragged = false;
    private DrawMode drawMode = DrawMode.FILL;
    private Background blackBG = null;
    private Background blueBG = null;
    private Background greenBG = null;
    private int gap = 0;
    private int border = 0;
    private Font titleFont = null;
    private Font textFont = null;
    private Font cellFont = null;
    private NumberFormat numFormat = null;

    public static void main(String[] stringArray) {
        FXTuxCube.launch((String[])stringArray);
    }

    public void start(Stage stage) {
        ColumnConstraints columnConstraints;
        Rectangle2D rectangle2D = Screen.getPrimary().getBounds();
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        int n = 16;
        int n2 = 20;
        int n3 = 38;
        this.gap = 6;
        this.border = 50;
        if (d2 <= 1080.0) {
            n = 14;
            n2 = 16;
            n3 = 30;
            this.gap = 4;
            this.border = 30;
        } else if (d2 <= 1200.0) {
            n = 14;
            n2 = 18;
            n3 = 34;
            this.gap = 5;
            this.border = 40;
        }
        this.titleFont = Font.font((String)"Dialog", (FontWeight)FontWeight.NORMAL, (double)n3);
        this.textFont = Font.font((String)"Dialog", (FontWeight)FontWeight.NORMAL, (double)n2);
        this.cellFont = Font.font((String)"Dialog", (FontWeight)FontWeight.NORMAL, (double)n);
        this.numFormat = NumberFormat.getIntegerInstance();
        this.numFormat.setGroupingUsed(true);
        final FXTuxCubeSubScene fXTuxCubeSubScene = new FXTuxCubeSubScene();
        this.subScene = fXTuxCubeSubScene.getSubScene();
        if (this.subScene == null) {
            this.exit();
        }
        final HUDLabel hUDLabel = new HUDLabel("FXTuxCube", this.titleFont);
        final HUDLabel hUDLabel2 = new HUDLabel("JavaFX 8 3D", this.titleFont);
        this.fpsTitleLabel = new HUDLabel("F P S");
        this.fpsTitleLabel.setTooltip(new Tooltip("frames per second"));
        this.fpsLabel = new HUDLabel("0");
        this.fpsLabel.setTooltip(new Tooltip("frames per second"));
        this.mpfTitleLabel = new HUDLabel("M P F");
        this.mpfTitleLabel.setTooltip(new Tooltip("milliseconds per frame"));
        this.mpfLabel = new HUDLabel("0");
        this.mpfLabel.setTooltip(new Tooltip("milliseconds per frame"));
        HUDLabel hUDLabel3 = new HUDLabel("Tuxes");
        hUDLabel3.setTooltip(new Tooltip("number of Tux models and RotateTransitions"));
        HUDLabel hUDLabel4 = new HUDLabel("Shape3Ds");
        hUDLabel4.setTooltip(new Tooltip("number of Shape3D nodes"));
        HUDLabel hUDLabel5 = new HUDLabel("Triangles");
        hUDLabel5.setTooltip(new Tooltip("number of triangles"));
        final HUDLabel hUDLabel6 = new HUDLabel(this.numFormat.format(27L));
        hUDLabel6.setTooltip(new Tooltip("number of Tux models and RotateTransitions"));
        final HUDLabel hUDLabel7 = new HUDLabel(this.numFormat.format(162L));
        hUDLabel7.setTooltip(new Tooltip("number of Shape3D nodes"));
        final HUDLabel hUDLabel8 = new HUDLabel(this.numFormat.format(371088L));
        hUDLabel8.setTooltip(new Tooltip("number of triangles"));
        HUDLabel hUDLabel9 = new HUDLabel("Height");
        hUDLabel9.setTooltip(new Tooltip("height of 3D SubScene"));
        final HUDLabel hUDLabel10 = new HUDLabel("0");
        hUDLabel10.setTooltip(new Tooltip("height of 3D SubScene"));
        HUDLabel hUDLabel11 = new HUDLabel("Width");
        hUDLabel11.setTooltip(new Tooltip("width of 3D SubScene"));
        final HUDLabel hUDLabel12 = new HUDLabel("0");
        hUDLabel12.setTooltip(new Tooltip("width of 3D SubScene"));
        Rectangle rectangle = new Rectangle((double)this.gap, (double)this.gap, (Paint)Color.TRANSPARENT);
        Rectangle rectangle2 = new Rectangle((double)this.gap, (double)this.gap, (Paint)Color.TRANSPARENT);
        final GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(0.0);
        gridPane.setGridLinesVisible(false);
        gridPane.add((Node)this.fpsLabel, 0, 0);
        gridPane.add((Node)this.fpsTitleLabel, 1, 0);
        gridPane.add((Node)this.mpfLabel, 0, 1);
        gridPane.add((Node)this.mpfTitleLabel, 1, 1);
        gridPane.add((Node)rectangle, 0, 2);
        gridPane.add((Node)hUDLabel6, 0, 3);
        gridPane.add((Node)hUDLabel3, 1, 3);
        gridPane.add((Node)hUDLabel7, 0, 4);
        gridPane.add((Node)hUDLabel4, 1, 4);
        gridPane.add((Node)hUDLabel8, 0, 5);
        gridPane.add((Node)hUDLabel5, 1, 5);
        gridPane.add((Node)rectangle2, 0, 6);
        gridPane.add((Node)hUDLabel12, 0, 7);
        gridPane.add((Node)hUDLabel11, 1, 7);
        gridPane.add((Node)hUDLabel10, 0, 8);
        gridPane.add((Node)hUDLabel9, 1, 8);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setHalignment(HPos.RIGHT);
        ColumnConstraints columnConstraints3 = new ColumnConstraints();
        columnConstraints3.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints2, columnConstraints3});
        HUDLabel hUDLabel13 = new HUDLabel("Cube");
        hUDLabel13.setTooltip(new Tooltip("width x height x depth"));
        ObservableList observableList = FXCollections.observableArrayList((Object[])new Number[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12});
        ComboBox comboBox = new ComboBox();
        comboBox.setTooltip(new Tooltip("width x height x depth"));
        comboBox.setItems(observableList);
        comboBox.setVisibleRowCount(12);
        comboBox.getSelectionModel().select(2);
        comboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                int n = (Integer)number2;
                int n2 = n * n * n;
                fXTuxCubeSubScene.createTuxCubeOfDim(n, FXTuxCube.this.isTuxRotating, FXTuxCube.this.drawMode);
                fXTuxCubeSubScene.setVantagePoint(FXTuxCubeSubScene.VP.FRONT);
                hUDLabel6.setText(FXTuxCube.this.numFormat.format(n2));
                hUDLabel7.setText(FXTuxCube.this.numFormat.format(n2 * 6));
                hUDLabel8.setText(FXTuxCube.this.numFormat.format(n2 * 13744));
            }
        });
        comboBox.setButtonCell((ListCell)new ListCell<Number>(){
            {
                this.setFont(FXTuxCube.this.cellFont);
            }

            protected void updateItem(Number number, boolean bl) {
                super.updateItem((Object)number, bl);
                if (number != null) {
                    this.setText(Integer.toString((Integer)number));
                }
            }
        });
        comboBox.setCellFactory((Callback)new Callback<ListView<Number>, ListCell<Number>>(){

            public ListCell<Number> call(ListView<Number> listView) {
                return new ListCell<Number>(){
                    {
                        this.setFont(FXTuxCube.this.cellFont);
                    }

                    protected void updateItem(Number number, boolean bl) {
                        super.updateItem((Object)number, bl);
                        if (number != null) {
                            this.setText(Integer.toString((Integer)number));
                        }
                    }
                };
            }
        });
        HUDLabel hUDLabel14 = new HUDLabel("Viewpoint");
        hUDLabel14.setTooltip(new Tooltip("select viewpoint"));
        final ComboBox comboBox2 = new ComboBox();
        comboBox2.setTooltip(new Tooltip("select viewpoint"));
        comboBox2.getItems().addAll((Object[])new FXTuxCubeSubScene.VP[]{FXTuxCubeSubScene.VP.BOTTOM, FXTuxCubeSubScene.VP.CORNER, FXTuxCubeSubScene.VP.FRONT, FXTuxCubeSubScene.VP.TOP});
        comboBox2.setValue((Object)FXTuxCubeSubScene.VP.Select);
        comboBox2.valueProperty().addListener((ChangeListener)new ChangeListener<FXTuxCubeSubScene.VP>(){

            public void changed(ObservableValue<? extends FXTuxCubeSubScene.VP> observableValue, FXTuxCubeSubScene.VP vP, FXTuxCubeSubScene.VP vP2) {
                if (vP2 != null && vP2 != FXTuxCubeSubScene.VP.Select) {
                    fXTuxCubeSubScene.setVantagePoint(vP2);
                    comboBox2.setValue((Object)FXTuxCubeSubScene.VP.Select);
                }
            }
        });
        comboBox2.setButtonCell((ListCell)new ListCell<FXTuxCubeSubScene.VP>(){
            {
                this.setFont(FXTuxCube.this.cellFont);
            }

            protected void updateItem(FXTuxCubeSubScene.VP vP, boolean bl) {
                super.updateItem((Object)vP, bl);
                if (vP != null) {
                    this.setText(vP.getListName());
                }
            }
        });
        comboBox2.setCellFactory((Callback)new Callback<ListView<FXTuxCubeSubScene.VP>, ListCell<FXTuxCubeSubScene.VP>>(){

            public ListCell<FXTuxCubeSubScene.VP> call(ListView<FXTuxCubeSubScene.VP> listView) {
                return new ListCell<FXTuxCubeSubScene.VP>(){
                    {
                        this.setFont(FXTuxCube.this.cellFont);
                    }

                    protected void updateItem(FXTuxCubeSubScene.VP vP, boolean bl) {
                        super.updateItem((Object)vP, bl);
                        if (vP != null) {
                            this.setText(vP.getListName());
                        }
                    }
                };
            }
        });
        HUDLabel hUDLabel15 = new HUDLabel("Tux");
        hUDLabel15.setTooltip(new Tooltip("start/pause rotation of Tuxes"));
        final CheckBox checkBox = new CheckBox();
        checkBox.setTooltip(new Tooltip("start/pause rotation of Tuxes"));
        checkBox.setStyle("-fx-label-padding: 0");
        checkBox.setGraphicTextGap(0.0);
        checkBox.setFont(this.textFont);
        checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                FXTuxCube.this.isTuxRotating = !FXTuxCube.this.isTuxRotating;
                fXTuxCubeSubScene.playPauseTuxRotation(FXTuxCube.this.isTuxRotating);
                FXTuxCube.this.checkFPS();
            }
        });
        HUDLabel hUDLabel16 = new HUDLabel("    <  Cube Rotation  >    ");
        hUDLabel16.setTooltip(new Tooltip("direction & speed of rotation"));
        final Slider slider = new Slider(20.0, 80.0, 50.0);
        slider.setBlockIncrement(0.6);
        slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                FXTuxCube.this.isCubeRotating = number2.floatValue() < 49.0f || number2.floatValue() > 51.0f;
                fXTuxCubeSubScene.setRotationSpeed(((Double)number2).floatValue());
                FXTuxCube.this.checkFPS();
            }
        });
        slider.setTooltip(new Tooltip("direction & speed of rotation"));
        final GridPane gridPane2 = new GridPane();
        gridPane2.setHgap(10.0);
        gridPane2.setVgap(4.0);
        gridPane2.setGridLinesVisible(false);
        gridPane2.add((Node)hUDLabel13, 0, 0);
        gridPane2.add((Node)comboBox, 0, 1);
        gridPane2.add((Node)hUDLabel14, 1, 0);
        gridPane2.add((Node)comboBox2, 1, 1);
        gridPane2.add((Node)hUDLabel15, 2, 0);
        gridPane2.add((Node)checkBox, 2, 1);
        gridPane2.add((Node)hUDLabel16, 3, 0);
        gridPane2.add((Node)slider, 3, 1);
        for (int i = 0; i < 4; ++i) {
            columnConstraints = new ColumnConstraints();
            columnConstraints.setHalignment(HPos.CENTER);
            gridPane2.getColumnConstraints().add((Object)columnConstraints);
        }
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setValignment(VPos.CENTER);
        columnConstraints = new RowConstraints();
        columnConstraints.setValignment(VPos.CENTER);
        gridPane2.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints, columnConstraints});
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                gridPane2.setOpacity(1.0);
            }
        };
        EventHandler<MouseEvent> eventHandler2 = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                gridPane2.setOpacity(0.5);
            }
        };
        gridPane2.setOpacity(0.5);
        gridPane2.setOnMouseEntered((EventHandler)eventHandler);
        gridPane2.setOnMouseExited((EventHandler)eventHandler2);
        double d3 = Math.min(d * 0.8, d2 * 0.8);
        this.subScene.setWidth(d3);
        this.subScene.setHeight(d3);
        Group group = new Group();
        final Scene scene = new Scene((Parent)group, d3, d3, true);
        ChangeListener changeListener = new ChangeListener(){

            public void changed(ObservableValue observableValue, Object object, Object object2) {
                FXTuxCube.this.subScene.setWidth(scene.getWidth());
                FXTuxCube.this.subScene.setHeight(scene.getHeight());
            }
        };
        scene.widthProperty().addListener(changeListener);
        scene.heightProperty().addListener(changeListener);
        final Pane pane = new Pane(){

            protected void layoutChildren() {
                double d = scene.getWidth();
                double d2 = scene.getHeight();
                hUDLabel.autosize();
                hUDLabel.relocate(FXTuxCube.this.border, FXTuxCube.this.border);
                hUDLabel2.autosize();
                hUDLabel2.relocate(d - hUDLabel2.getWidth() - (double)FXTuxCube.this.border, FXTuxCube.this.border);
                gridPane2.autosize();
                gridPane2.relocate((double)FXTuxCube.this.border, d2 - gridPane2.getHeight() - (double)FXTuxCube.this.border);
                gridPane.autosize();
                gridPane.relocate(d - (double)FXTuxCube.this.border - gridPane.getWidth(), d2 - gridPane.getHeight() - (double)FXTuxCube.this.border);
                hUDLabel12.setText(FXTuxCube.this.numFormat.format((int)d));
                hUDLabel10.setText(FXTuxCube.this.numFormat.format((int)d2));
            }
        };
        pane.getChildren().addAll((Object[])new Node[]{this.subScene, hUDLabel, hUDLabel2, gridPane2, gridPane});
        Stop[] stopArray = new Stop[]{new Stop(0.0, Color.LIGHTGRAY), new Stop(0.2, Color.BLACK), new Stop(1.0, Color.BLACK)};
        RadialGradient radialGradient = new RadialGradient(0.0, 0.0, 0.5, 0.5, 1.0, true, CycleMethod.NO_CYCLE, stopArray);
        this.blackBG = new Background(new BackgroundFill[]{new BackgroundFill((Paint)radialGradient, null, null)});
        Stop[] stopArray2 = new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)73, (int)255)), new Stop(0.7, Color.rgb((int)127, (int)164, (int)255)), new Stop(1.0, Color.rgb((int)0, (int)73, (int)255))};
        LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, stopArray2);
        this.blueBG = new Background(new BackgroundFill[]{new BackgroundFill((Paint)linearGradient, null, null)});
        this.greenBG = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TURQUOISE, null, null)});
        pane.setBackground(this.blueBG);
        group.getChildren().add((Object)pane);
        Menu menu = new Menu("Projection");
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioMenuItem radioMenuItem = new RadioMenuItem("Parallel");
        radioMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                fXTuxCubeSubScene.setProjectionMode("Parallel");
            }
        });
        radioMenuItem.setToggleGroup(toggleGroup);
        radioMenuItem.setDisable(true);
        RadioMenuItem radioMenuItem2 = new RadioMenuItem("Perspective");
        radioMenuItem2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                fXTuxCubeSubScene.setProjectionMode("Perspective");
            }
        });
        radioMenuItem2.setSelected(true);
        radioMenuItem2.setToggleGroup(toggleGroup);
        menu.getItems().addAll((Object[])new MenuItem[]{radioMenuItem, radioMenuItem2});
        Menu menu2 = new Menu("Polygon mode");
        ToggleGroup toggleGroup2 = new ToggleGroup();
        EventHandler<ActionEvent> eventHandler3 = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (FXTuxCube.this.drawMode == DrawMode.FILL) {
                    FXTuxCube.this.drawMode = DrawMode.LINE;
                } else {
                    FXTuxCube.this.drawMode = DrawMode.FILL;
                }
                fXTuxCubeSubScene.setDrawMode(FXTuxCube.this.drawMode);
            }
        };
        RadioMenuItem radioMenuItem3 = new RadioMenuItem("Fill");
        radioMenuItem3.setToggleGroup(toggleGroup2);
        radioMenuItem3.setSelected(true);
        radioMenuItem3.setOnAction((EventHandler)eventHandler3);
        RadioMenuItem radioMenuItem4 = new RadioMenuItem("Line");
        radioMenuItem4.setToggleGroup(toggleGroup2);
        radioMenuItem4.setOnAction((EventHandler)eventHandler3);
        menu2.getItems().addAll((Object[])new MenuItem[]{radioMenuItem3, radioMenuItem4});
        Menu menu3 = new Menu("Background");
        ToggleGroup toggleGroup3 = new ToggleGroup();
        RadioMenuItem radioMenuItem5 = new RadioMenuItem("Black RadialGradient");
        radioMenuItem5.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                pane.setBackground(FXTuxCube.this.blackBG);
            }
        });
        radioMenuItem5.setToggleGroup(toggleGroup3);
        RadioMenuItem radioMenuItem6 = new RadioMenuItem("Blue LinearGradient");
        radioMenuItem6.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                pane.setBackground(FXTuxCube.this.blueBG);
            }
        });
        radioMenuItem6.setToggleGroup(toggleGroup3);
        radioMenuItem6.setSelected(true);
        RadioMenuItem radioMenuItem7 = new RadioMenuItem("Turquois Color");
        radioMenuItem7.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                pane.setBackground(FXTuxCube.this.greenBG);
            }
        });
        radioMenuItem7.setToggleGroup(toggleGroup3);
        menu3.getItems().addAll((Object[])new MenuItem[]{radioMenuItem5, radioMenuItem6, radioMenuItem7});
        MenuItem menuItem = new MenuItem("Reset cube rotation");
        menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                fXTuxCubeSubScene.stopCubeRotation();
                slider.setValue(50.0);
            }
        });
        MenuItem menuItem2 = new MenuItem("Reset Tux rotation");
        menuItem2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (FXTuxCube.this.isTuxRotating) {
                    checkBox.setSelected(false);
                }
                fXTuxCubeSubScene.stopTuxRotation();
            }
        });
        Menu menu4 = new Menu("Scene anti-aliasing");
        final ToggleGroup toggleGroup4 = new ToggleGroup();
        final RadioMenuItem radioMenuItem8 = new RadioMenuItem("BALANCED");
        radioMenuItem8.setToggleGroup(toggleGroup4);
        radioMenuItem8.setSelected(true);
        RadioMenuItem radioMenuItem9 = new RadioMenuItem("DISABLED");
        radioMenuItem9.setToggleGroup(toggleGroup4);
        EventHandler<ActionEvent> eventHandler4 = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                SceneAntialiasing sceneAntialiasing = SceneAntialiasing.DISABLED;
                if (toggleGroup4.getSelectedToggle() == radioMenuItem8) {
                    sceneAntialiasing = SceneAntialiasing.BALANCED;
                }
                FXTuxCube.this.subScene = fXTuxCubeSubScene.exchangeSubScene(sceneAntialiasing);
                pane.getChildren().set(0, (Object)FXTuxCube.this.subScene);
            }
        };
        radioMenuItem8.setOnAction((EventHandler)eventHandler4);
        radioMenuItem9.setOnAction((EventHandler)eventHandler4);
        menu4.getItems().addAll((Object[])new MenuItem[]{radioMenuItem8, radioMenuItem9});
        MenuItem menuItem3 = new MenuItem("Exit");
        menuItem3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXTuxCube.this.exit();
            }
        });
        final ContextMenu contextMenu = new ContextMenu();
        contextMenu.setHideOnEscape(true);
        contextMenu.getItems().addAll((Object[])new MenuItem[]{menu3, menu2, menu, new SeparatorMenuItem(), menuItem, menuItem2, new SeparatorMenuItem(), menu4, new SeparatorMenuItem(), menuItem3});
        pane.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (contextMenu.isShowing()) {
                    contextMenu.hide();
                }
                if (mouseEvent.getButton() == MouseButton.SECONDARY && !FXTuxCube.this.isMouseDragged) {
                    contextMenu.show((Node)pane, mouseEvent.getScreenX() + 2.0, mouseEvent.getScreenY() + 2.0);
                }
                FXTuxCube.this.isMouseDragged = false;
                FXTuxCube.this.checkFPS();
            }
        });
        pane.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                FXTuxCube.this.isMouseDragged = true;
                FXTuxCube.this.checkFPS();
            }
        });
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                FXTuxCube.this.exit();
            }
        });
        stage.setScene(scene);
        stage.setTitle("InteractiveMesh : FXTuxCube 0.7.1");
        stage.show();
        this.lastTime = System.nanoTime();
        fXTuxCubeSubScene.createTuxCubeOfDim(3, this.isTuxRotating, this.drawMode);
        fXTuxCubeSubScene.setVantagePoint(FXTuxCubeSubScene.VP.FRONT);
        this.fpsTimer = new AnimationTimer(){

            public void handle(long l) {
                if (!FXTuxCube.this.isUpdateFPS) {
                    return;
                }
                FXTuxCube.this.frameCounter++;
                if (FXTuxCube.this.frameCounter > FXTuxCube.this.elapsedFrames) {
                    long l2 = System.nanoTime();
                    double d = (double)(l2 - FXTuxCube.this.lastTime) / (double)FXTuxCube.this.frameCounter;
                    FXTuxCube.this.lastTime = l2;
                    int n = (int)(1.0E9 / d + 0.5);
                    int n2 = (int)(d / 1000000.0 + 0.5);
                    FXTuxCube.this.frameCounter = 0;
                    FXTuxCube.this.elapsedFrames = (int)Math.max(1.0f, (float)n / 3.0f);
                    FXTuxCube.this.elapsedFrames = Math.min(100, FXTuxCube.this.elapsedFrames);
                    FXTuxCube.this.fpsLabel.setText(Integer.toString(n));
                    FXTuxCube.this.mpfLabel.setText(Integer.toString(n2));
                }
            }
        };
    }

    private void checkFPS() {
        boolean bl;
        boolean bl2 = bl = this.isTuxRotating || this.isCubeRotating || this.isMouseDragged;
        if (this.isUpdateFPS == bl) {
            return;
        }
        this.isUpdateFPS = bl;
        if (!this.isUpdateFPS) {
            this.fpsTimer.stop();
            this.fpsLabel.setText(Integer.toString(0));
            this.mpfLabel.setText(Integer.toString(0));
        } else {
            this.fpsTimer.start();
        }
    }

    private void exit() {
        System.exit(0);
    }

    private final class HUDLabel
    extends Label {
        private HUDLabel(String string) {
            this(string, fXTuxCube.textFont);
        }

        private HUDLabel(String string, Font font) {
            super(string);
            this.setFont(font);
            this.setTextFill((Paint)Color.WHITE);
        }
    }
}

