/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.image;

import com.sun.media.jai.codec.SeekableStream;
import java.io.IOException;
import java.nio.ByteBuffer;

final class TifBufferStream
extends SeekableStream {
    private ByteBuffer buffer = null;

    TifBufferStream() {
    }

    void setup(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    void clear() {
        this.buffer = null;
    }

    public void close() throws IOException {
        this.clear();
        super.close();
    }

    public int available() throws IOException {
        int n = this.buffer.limit() - this.buffer.position();
        return n;
    }

    public synchronized void mark(int n) {
        this.buffer.mark();
    }

    public synchronized void reset() throws IOException {
        this.buffer.reset();
    }

    public boolean markSupported() {
        return true;
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public long getFilePointer() throws IOException {
        return this.buffer.position();
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException("pos < 0");
        }
        if (l >= (long)this.buffer.limit()) {
            throw new IOException("(pos >= buffer.limit())");
        }
        this.buffer.position((int)l);
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return l;
        }
        long l2 = this.buffer.limit() - this.buffer.position();
        if (l > l2) {
            l = l2;
        }
        this.buffer.position(this.buffer.position() + (int)l);
        return l;
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public final int read() throws IOException {
        if (this.buffer.position() < this.buffer.limit()) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("b == null");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("((off < 0) || (len < 0) || (off + len > b.length))");
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.buffer.position() >= this.buffer.limit()) {
            return -1;
        }
        if (n2 > this.buffer.remaining()) {
            n2 = this.buffer.remaining();
        }
        this.buffer.get(byArray, n, n2);
        return n2;
    }
}

