/*
 * Decompiled with CFR 0.152.
 */
package org.interactivemesh.jfx.sample3d.tuxcubesv;

import java.text.NumberFormat;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.interactivemesh.jfx.sample3d.tuxcubesv.AnotherView;
import org.interactivemesh.jfx.sample3d.tuxcubesv.FXTuxCubeSVSubScene;

public final class FXTuxCubeSV
extends Application {
    private SubScene subScene = null;
    private long lastTime = 0L;
    private int frameCounter = 0;
    private int elapsedFrames = 100;
    private AnimationTimer fpsTimer = null;
    private HUDLabel fpsLabel = null;
    private HUDLabel mpfLabel = null;
    private boolean isUpdateFPS = false;
    private boolean isTuxRotating = false;
    private boolean isCubeRotating = false;
    private boolean isMouseDragged = false;
    private DrawMode drawMode = DrawMode.FILL;
    private Pane background1Pane = null;
    private RadialGradient blackRG = null;
    private LinearGradient blueLG = null;
    private Background blackBG = null;
    private Background blueBG = null;
    private Background greenBG = null;
    private int gap = 0;
    private int border = 0;
    private Font titleFont = null;
    private Font textFont = null;
    private Font cellFont = null;
    private NumberFormat numFormat = null;
    private AnotherView secondView = null;
    private AnimationTimer viewTimer = null;

    public static void main(String[] stringArray) {
        FXTuxCubeSV.launch((String[])stringArray);
    }

    public void start(Stage stage) {
        ColumnConstraints columnConstraints;
        Rectangle2D rectangle2D = Screen.getPrimary().getBounds();
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        int n = 16;
        int n2 = 20;
        int n3 = 38;
        this.gap = 6;
        this.border = 50;
        if (d2 <= 1080.0) {
            n = 14;
            n2 = 16;
            n3 = 30;
            this.gap = 4;
            this.border = 30;
        } else if (d2 <= 1200.0) {
            n = 14;
            n2 = 18;
            n3 = 34;
            this.gap = 5;
            this.border = 40;
        }
        this.titleFont = Font.font((String)"Dialog", (FontWeight)FontWeight.NORMAL, (double)n3);
        this.textFont = Font.font((String)"Dialog", (FontWeight)FontWeight.NORMAL, (double)n2);
        this.cellFont = Font.font((String)"Dialog", (FontWeight)FontWeight.NORMAL, (double)n);
        this.numFormat = NumberFormat.getIntegerInstance();
        this.numFormat.setGroupingUsed(true);
        final FXTuxCubeSVSubScene fXTuxCubeSVSubScene = new FXTuxCubeSVSubScene();
        this.subScene = fXTuxCubeSVSubScene.getSubScene();
        if (this.subScene == null) {
            this.exit();
        }
        this.secondView = new AnotherView(fXTuxCubeSVSubScene.geRoot3D());
        final ImageView imageView = this.secondView.getViewPane();
        final HUDLabel hUDLabel = new HUDLabel("FXTuxCubeSV - JavaFX 8 3D", this.titleFont);
        final HUDLabel hUDLabel2 = new HUDLabel("1st Cam", this.titleFont);
        HUDLabel hUDLabel3 = new HUDLabel("F P S");
        hUDLabel3.setTooltip(new Tooltip("frames per second"));
        this.fpsLabel = new HUDLabel("0");
        this.fpsLabel.setTooltip(new Tooltip("frames per second"));
        HUDLabel hUDLabel4 = new HUDLabel("M P F");
        hUDLabel4.setTooltip(new Tooltip("milliseconds per frame"));
        this.mpfLabel = new HUDLabel("0");
        this.mpfLabel.setTooltip(new Tooltip("milliseconds per frame"));
        HUDLabel hUDLabel5 = new HUDLabel("Tuxes");
        hUDLabel5.setTooltip(new Tooltip("number of Tux models and RotateTransitions"));
        HUDLabel hUDLabel6 = new HUDLabel("Shape3Ds");
        hUDLabel6.setTooltip(new Tooltip("number of Shape3D nodes"));
        HUDLabel hUDLabel7 = new HUDLabel("Triangles");
        hUDLabel7.setTooltip(new Tooltip("number of triangles"));
        final HUDLabel hUDLabel8 = new HUDLabel(this.numFormat.format(27L));
        hUDLabel8.setTooltip(new Tooltip("number of Tux models and RotateTransitions"));
        final HUDLabel hUDLabel9 = new HUDLabel(this.numFormat.format(162L));
        hUDLabel9.setTooltip(new Tooltip("number of Shape3D nodes"));
        final HUDLabel hUDLabel10 = new HUDLabel(this.numFormat.format(371088L));
        hUDLabel10.setTooltip(new Tooltip("number of triangles"));
        HUDLabel hUDLabel11 = new HUDLabel("Height");
        hUDLabel11.setTooltip(new Tooltip("height of 3D SubScene"));
        final HUDLabel hUDLabel12 = new HUDLabel("0");
        hUDLabel12.setTooltip(new Tooltip("height of 3D SubScene"));
        HUDLabel hUDLabel13 = new HUDLabel("Width");
        hUDLabel13.setTooltip(new Tooltip("width of 3D SubScene"));
        final HUDLabel hUDLabel14 = new HUDLabel("0");
        hUDLabel14.setTooltip(new Tooltip("width of 3D SubScene"));
        Rectangle rectangle = new Rectangle((double)this.gap, (double)this.gap, (Paint)Color.TRANSPARENT);
        Rectangle rectangle2 = new Rectangle((double)this.gap, (double)this.gap, (Paint)Color.TRANSPARENT);
        final GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(0.0);
        gridPane.setGridLinesVisible(false);
        gridPane.add((Node)this.fpsLabel, 0, 0);
        gridPane.add((Node)hUDLabel3, 1, 0);
        gridPane.add((Node)this.mpfLabel, 0, 1);
        gridPane.add((Node)hUDLabel4, 1, 1);
        gridPane.add((Node)rectangle, 0, 2);
        gridPane.add((Node)hUDLabel8, 0, 3);
        gridPane.add((Node)hUDLabel5, 1, 3);
        gridPane.add((Node)hUDLabel9, 0, 4);
        gridPane.add((Node)hUDLabel6, 1, 4);
        gridPane.add((Node)hUDLabel10, 0, 5);
        gridPane.add((Node)hUDLabel7, 1, 5);
        gridPane.add((Node)rectangle2, 0, 6);
        gridPane.add((Node)hUDLabel14, 0, 7);
        gridPane.add((Node)hUDLabel13, 1, 7);
        gridPane.add((Node)hUDLabel12, 0, 8);
        gridPane.add((Node)hUDLabel11, 1, 8);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setHalignment(HPos.RIGHT);
        ColumnConstraints columnConstraints3 = new ColumnConstraints();
        columnConstraints3.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints2, columnConstraints3});
        HUDLabel hUDLabel15 = new HUDLabel("Cube");
        hUDLabel15.setTooltip(new Tooltip("width x height x depth"));
        ObservableList observableList = FXCollections.observableArrayList((Object[])new Number[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12});
        ComboBox comboBox = new ComboBox();
        comboBox.setTooltip(new Tooltip("width x height x depth"));
        comboBox.setItems(observableList);
        comboBox.setVisibleRowCount(12);
        comboBox.getSelectionModel().select(2);
        comboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                int n = (Integer)number2;
                int n2 = n * n * n;
                double d = fXTuxCubeSVSubScene.createTuxCubeOfDim(n, FXTuxCubeSV.this.isTuxRotating, FXTuxCubeSV.this.drawMode);
                FXTuxCubeSV.this.secondView.setSceneDiameter(d);
                fXTuxCubeSVSubScene.setVantagePoint(FXTuxCubeSVSubScene.VP.FRONT);
                FXTuxCubeSV.this.secondView.setVantagePoint(FXTuxCubeSVSubScene.VP.FRONT);
                hUDLabel8.setText(FXTuxCubeSV.this.numFormat.format(n2));
                hUDLabel9.setText(FXTuxCubeSV.this.numFormat.format(n2 * 6));
                hUDLabel10.setText(FXTuxCubeSV.this.numFormat.format(n2 * 13744));
            }
        });
        comboBox.setButtonCell((ListCell)new ListCell<Number>(){
            {
                this.setFont(FXTuxCubeSV.this.cellFont);
            }

            protected void updateItem(Number number, boolean bl) {
                super.updateItem((Object)number, bl);
                if (number != null) {
                    this.setText(Integer.toString((Integer)number));
                }
            }
        });
        comboBox.setCellFactory((Callback)new Callback<ListView<Number>, ListCell<Number>>(){

            public ListCell<Number> call(ListView<Number> listView) {
                return new ListCell<Number>(){
                    {
                        this.setFont(FXTuxCubeSV.this.cellFont);
                    }

                    protected void updateItem(Number number, boolean bl) {
                        super.updateItem((Object)number, bl);
                        if (number != null) {
                            this.setText(Integer.toString((Integer)number));
                        }
                    }
                };
            }
        });
        HUDLabel hUDLabel16 = new HUDLabel("Viewpoint");
        hUDLabel16.setTooltip(new Tooltip("select viewpoint"));
        final ComboBox comboBox2 = new ComboBox();
        comboBox2.setTooltip(new Tooltip("select viewpoint"));
        comboBox2.getItems().addAll(new Object[]{FXTuxCubeSVSubScene.VP.BOTTOM, FXTuxCubeSVSubScene.VP.CORNER, FXTuxCubeSVSubScene.VP.FRONT, FXTuxCubeSVSubScene.VP.TOP});
        comboBox2.setValue((Object)FXTuxCubeSVSubScene.VP.Select);
        comboBox2.valueProperty().addListener((ChangeListener)new ChangeListener<FXTuxCubeSVSubScene.VP>(){

            public void changed(ObservableValue<? extends FXTuxCubeSVSubScene.VP> observableValue, FXTuxCubeSVSubScene.VP vP, FXTuxCubeSVSubScene.VP vP2) {
                if (vP2 != null && vP2 != FXTuxCubeSVSubScene.VP.Select) {
                    fXTuxCubeSVSubScene.setVantagePoint(vP2);
                    comboBox2.setValue((Object)FXTuxCubeSVSubScene.VP.Select);
                }
            }
        });
        comboBox2.setButtonCell((ListCell)new ListCell<FXTuxCubeSVSubScene.VP>(){
            {
                this.setFont(FXTuxCubeSV.this.cellFont);
            }

            protected void updateItem(FXTuxCubeSVSubScene.VP vP, boolean bl) {
                super.updateItem((Object)vP, bl);
                if (vP != null) {
                    this.setText(vP.getListName());
                }
            }
        });
        comboBox2.setCellFactory((Callback)new Callback<ListView<FXTuxCubeSVSubScene.VP>, ListCell<FXTuxCubeSVSubScene.VP>>(){

            public ListCell<FXTuxCubeSVSubScene.VP> call(ListView<FXTuxCubeSVSubScene.VP> listView) {
                return new ListCell<FXTuxCubeSVSubScene.VP>(){
                    {
                        this.setFont(FXTuxCubeSV.this.cellFont);
                    }

                    protected void updateItem(FXTuxCubeSVSubScene.VP vP, boolean bl) {
                        super.updateItem((Object)vP, bl);
                        if (vP != null) {
                            this.setText(vP.getListName());
                        }
                    }
                };
            }
        });
        HUDLabel hUDLabel17 = new HUDLabel("Tux");
        hUDLabel17.setTooltip(new Tooltip("start/pause rotation of Tuxes"));
        final CheckBox checkBox = new CheckBox();
        checkBox.setTooltip(new Tooltip("start/pause rotation of Tuxes"));
        checkBox.setStyle("-fx-label-padding: 0");
        checkBox.setGraphicTextGap(0.0);
        checkBox.setFont(this.textFont);
        checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                FXTuxCubeSV.this.isTuxRotating = !FXTuxCubeSV.this.isTuxRotating;
                fXTuxCubeSVSubScene.playPauseTuxRotation(FXTuxCubeSV.this.isTuxRotating);
                FXTuxCubeSV.this.checkFPS();
            }
        });
        HUDLabel hUDLabel18 = new HUDLabel("    <  Cube Rotation  >    ");
        hUDLabel18.setTooltip(new Tooltip("direction & speed of rotation"));
        final Slider slider = new Slider(20.0, 80.0, 50.0);
        slider.setBlockIncrement(0.6);
        slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                FXTuxCubeSV.this.isCubeRotating = number2.floatValue() < 49.0f || number2.floatValue() > 51.0f;
                fXTuxCubeSVSubScene.setRotationSpeed(((Double)number2).floatValue());
                FXTuxCubeSV.this.checkFPS();
            }
        });
        slider.setTooltip(new Tooltip("direction & speed of rotation"));
        final GridPane gridPane2 = new GridPane();
        gridPane2.setHgap(10.0);
        gridPane2.setVgap(4.0);
        gridPane2.setGridLinesVisible(false);
        gridPane2.add((Node)hUDLabel15, 0, 0);
        gridPane2.add((Node)comboBox, 0, 1);
        gridPane2.add((Node)hUDLabel16, 1, 0);
        gridPane2.add((Node)comboBox2, 1, 1);
        gridPane2.add((Node)hUDLabel17, 2, 0);
        gridPane2.add((Node)checkBox, 2, 1);
        gridPane2.add((Node)hUDLabel18, 3, 0);
        gridPane2.add((Node)slider, 3, 1);
        for (int i = 0; i < 4; ++i) {
            columnConstraints = new ColumnConstraints();
            columnConstraints.setHalignment(HPos.CENTER);
            gridPane2.getColumnConstraints().add((Object)columnConstraints);
        }
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setValignment(VPos.CENTER);
        columnConstraints = new RowConstraints();
        columnConstraints.setValignment(VPos.CENTER);
        gridPane2.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints, columnConstraints});
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                gridPane2.setOpacity(1.0);
            }
        };
        EventHandler<MouseEvent> eventHandler2 = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                gridPane2.setOpacity(0.5);
            }
        };
        gridPane2.setOpacity(0.5);
        gridPane2.setOnMouseEntered((EventHandler)eventHandler);
        gridPane2.setOnMouseExited((EventHandler)eventHandler2);
        final HUDLabel hUDLabel19 = new HUDLabel("2nd Cam", this.titleFont);
        HUDLabel hUDLabel20 = new HUDLabel("Viewpoint");
        hUDLabel20.setTooltip(new Tooltip("select viewpoint"));
        final ComboBox comboBox3 = new ComboBox();
        comboBox3.setTooltip(new Tooltip("select viewpoint"));
        comboBox3.getItems().addAll(new Object[]{FXTuxCubeSVSubScene.VP.BOTTOM, FXTuxCubeSVSubScene.VP.CORNER, FXTuxCubeSVSubScene.VP.FRONT, FXTuxCubeSVSubScene.VP.TOP});
        comboBox3.setValue((Object)FXTuxCubeSVSubScene.VP.Select);
        comboBox3.valueProperty().addListener((ChangeListener)new ChangeListener<FXTuxCubeSVSubScene.VP>(){

            public void changed(ObservableValue<? extends FXTuxCubeSVSubScene.VP> observableValue, FXTuxCubeSVSubScene.VP vP, FXTuxCubeSVSubScene.VP vP2) {
                if (vP2 != null && vP2 != FXTuxCubeSVSubScene.VP.Select) {
                    FXTuxCubeSV.this.secondView.setVantagePoint(vP2);
                    comboBox3.setValue((Object)FXTuxCubeSVSubScene.VP.Select);
                }
            }
        });
        comboBox3.setButtonCell((ListCell)new ListCell<FXTuxCubeSVSubScene.VP>(){
            {
                this.setFont(FXTuxCubeSV.this.cellFont);
            }

            protected void updateItem(FXTuxCubeSVSubScene.VP vP, boolean bl) {
                super.updateItem((Object)vP, bl);
                if (vP != null) {
                    this.setText(vP.getListName());
                }
            }
        });
        comboBox3.setCellFactory((Callback)new Callback<ListView<FXTuxCubeSVSubScene.VP>, ListCell<FXTuxCubeSVSubScene.VP>>(){

            public ListCell<FXTuxCubeSVSubScene.VP> call(ListView<FXTuxCubeSVSubScene.VP> listView) {
                return new ListCell<FXTuxCubeSVSubScene.VP>(){
                    {
                        this.setFont(FXTuxCubeSV.this.cellFont);
                    }

                    protected void updateItem(FXTuxCubeSVSubScene.VP vP, boolean bl) {
                        super.updateItem((Object)vP, bl);
                        if (vP != null) {
                            this.setText(vP.getListName());
                        }
                    }
                };
            }
        });
        final GridPane gridPane3 = new GridPane();
        gridPane3.setHgap(10.0);
        gridPane3.setVgap(4.0);
        gridPane3.setGridLinesVisible(false);
        gridPane3.add((Node)hUDLabel20, 0, 0);
        gridPane3.add((Node)comboBox3, 0, 1);
        ColumnConstraints columnConstraints4 = new ColumnConstraints();
        columnConstraints4.setHalignment(HPos.CENTER);
        gridPane3.getColumnConstraints().add((Object)columnConstraints4);
        double d3 = d * 0.8;
        double d4 = d2 * 0.8;
        this.subScene.setWidth(d3 / 2.0);
        this.subScene.setHeight(d4);
        Group group = new Group();
        final Scene scene = new Scene((Parent)group, d3, d4, true);
        ChangeListener changeListener = new ChangeListener(){

            public void changed(ObservableValue observableValue, Object object, Object object2) {
                FXTuxCubeSV.this.subScene.setWidth(scene.getWidth() / 2.0);
                FXTuxCubeSV.this.subScene.setHeight(scene.getHeight());
            }
        };
        scene.widthProperty().addListener(changeListener);
        scene.heightProperty().addListener(changeListener);
        this.background1Pane = new Pane();
        this.background1Pane.setPrefSize(d3 / 2.0, d4);
        final Pane pane = new Pane(){

            protected void layoutChildren() {
                double d = scene.getWidth();
                double d2 = d / 2.0;
                double d3 = scene.getHeight();
                FXTuxCubeSV.this.background1Pane.setPrefSize(d2, d3);
                FXTuxCubeSV.this.background1Pane.autosize();
                FXTuxCubeSV.this.background1Pane.relocate(0.0, 0.0);
                hUDLabel.autosize();
                hUDLabel.relocate(FXTuxCubeSV.this.border, FXTuxCubeSV.this.border);
                hUDLabel2.autosize();
                hUDLabel2.relocate(d2 - hUDLabel2.getWidth() - (double)FXTuxCubeSV.this.border, FXTuxCubeSV.this.border);
                gridPane2.autosize();
                gridPane2.relocate((double)FXTuxCubeSV.this.border, d3 - gridPane2.getHeight() - (double)FXTuxCubeSV.this.border);
                gridPane.autosize();
                gridPane.relocate(d2 - (double)FXTuxCubeSV.this.border - gridPane.getWidth(), d3 - gridPane.getHeight() - (double)FXTuxCubeSV.this.border);
                hUDLabel14.setText(FXTuxCubeSV.this.numFormat.format((int)d2));
                hUDLabel12.setText(FXTuxCubeSV.this.numFormat.format((int)d3));
                imageView.relocate(d2, 0.0);
                hUDLabel19.autosize();
                hUDLabel19.relocate(d - (double)FXTuxCubeSV.this.border - hUDLabel19.getWidth(), FXTuxCubeSV.this.border);
                gridPane3.autosize();
                gridPane3.relocate(d - (double)FXTuxCubeSV.this.border - gridPane3.getWidth(), d3 - gridPane3.getHeight() - (double)FXTuxCubeSV.this.border);
            }
        };
        pane.getChildren().addAll((Object[])new Node[]{this.background1Pane, this.subScene, imageView, hUDLabel, hUDLabel2, gridPane2, gridPane, hUDLabel19, gridPane3});
        this.viewTimer = new AnimationTimer(){

            public void handle(long l) {
                FXTuxCubeSV.this.secondView.drawView(scene.getWidth() / 2.0, scene.getHeight());
            }
        };
        Stop[] stopArray = new Stop[]{new Stop(0.0, Color.LIGHTGRAY), new Stop(0.2, Color.BLACK), new Stop(1.0, Color.BLACK)};
        this.blackRG = new RadialGradient(0.0, 0.0, 0.5, 0.5, 1.0, true, CycleMethod.NO_CYCLE, stopArray);
        this.blackBG = new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.blackRG, null, null)});
        Stop[] stopArray2 = new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)73, (int)255)), new Stop(0.7, Color.rgb((int)127, (int)164, (int)255)), new Stop(1.0, Color.rgb((int)0, (int)73, (int)255))};
        this.blueLG = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, stopArray2);
        this.blueBG = new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.blueLG, null, null)});
        this.greenBG = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.MEDIUMTURQUOISE, null, null)});
        this.background1Pane.setBackground(this.blueBG);
        this.secondView.setBackground((Paint)this.blueLG);
        group.getChildren().add((Object)pane);
        Menu menu = new Menu("Projection");
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioMenuItem radioMenuItem = new RadioMenuItem("Parallel");
        radioMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                fXTuxCubeSVSubScene.setProjectionMode("Parallel");
            }
        });
        radioMenuItem.setToggleGroup(toggleGroup);
        radioMenuItem.setDisable(true);
        RadioMenuItem radioMenuItem2 = new RadioMenuItem("Perspective");
        radioMenuItem2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                fXTuxCubeSVSubScene.setProjectionMode("Perspective");
            }
        });
        radioMenuItem2.setSelected(true);
        radioMenuItem2.setToggleGroup(toggleGroup);
        menu.getItems().addAll((Object[])new MenuItem[]{radioMenuItem, radioMenuItem2});
        Menu menu2 = new Menu("Polygon mode");
        ToggleGroup toggleGroup2 = new ToggleGroup();
        EventHandler<ActionEvent> eventHandler3 = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (FXTuxCubeSV.this.drawMode == DrawMode.FILL) {
                    FXTuxCubeSV.this.drawMode = DrawMode.LINE;
                } else {
                    FXTuxCubeSV.this.drawMode = DrawMode.FILL;
                }
                fXTuxCubeSVSubScene.setDrawMode(FXTuxCubeSV.this.drawMode);
            }
        };
        RadioMenuItem radioMenuItem3 = new RadioMenuItem("Fill");
        radioMenuItem3.setToggleGroup(toggleGroup2);
        radioMenuItem3.setSelected(true);
        radioMenuItem3.setOnAction((EventHandler)eventHandler3);
        RadioMenuItem radioMenuItem4 = new RadioMenuItem("Line");
        radioMenuItem4.setToggleGroup(toggleGroup2);
        radioMenuItem4.setOnAction((EventHandler)eventHandler3);
        menu2.getItems().addAll((Object[])new MenuItem[]{radioMenuItem3, radioMenuItem4});
        Menu menu3 = new Menu("Background 1st cam");
        ToggleGroup toggleGroup3 = new ToggleGroup();
        RadioMenuItem radioMenuItem5 = new RadioMenuItem("Black RadialGradient");
        radioMenuItem5.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXTuxCubeSV.this.background1Pane.setBackground(FXTuxCubeSV.this.blackBG);
            }
        });
        radioMenuItem5.setToggleGroup(toggleGroup3);
        RadioMenuItem radioMenuItem6 = new RadioMenuItem("Blue LinearGradient");
        radioMenuItem6.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXTuxCubeSV.this.background1Pane.setBackground(FXTuxCubeSV.this.blueBG);
            }
        });
        radioMenuItem6.setToggleGroup(toggleGroup3);
        radioMenuItem6.setSelected(true);
        RadioMenuItem radioMenuItem7 = new RadioMenuItem("Turquois Color");
        radioMenuItem7.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXTuxCubeSV.this.background1Pane.setBackground(FXTuxCubeSV.this.greenBG);
            }
        });
        radioMenuItem7.setToggleGroup(toggleGroup3);
        menu3.getItems().addAll((Object[])new MenuItem[]{radioMenuItem5, radioMenuItem6, radioMenuItem7});
        Menu menu4 = new Menu("Background 2nd cam");
        ToggleGroup toggleGroup4 = new ToggleGroup();
        RadioMenuItem radioMenuItem8 = new RadioMenuItem("Black RadialGradient");
        radioMenuItem8.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXTuxCubeSV.this.secondView.setBackground((Paint)FXTuxCubeSV.this.blackRG);
            }
        });
        radioMenuItem8.setToggleGroup(toggleGroup4);
        RadioMenuItem radioMenuItem9 = new RadioMenuItem("Blue LinearGradient");
        radioMenuItem9.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXTuxCubeSV.this.secondView.setBackground((Paint)FXTuxCubeSV.this.blueLG);
            }
        });
        radioMenuItem9.setToggleGroup(toggleGroup4);
        radioMenuItem9.setSelected(true);
        RadioMenuItem radioMenuItem10 = new RadioMenuItem("Turquois Color");
        radioMenuItem10.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXTuxCubeSV.this.secondView.setBackground((Paint)Color.MEDIUMTURQUOISE);
            }
        });
        radioMenuItem10.setToggleGroup(toggleGroup4);
        menu4.getItems().addAll((Object[])new MenuItem[]{radioMenuItem8, radioMenuItem9, radioMenuItem10});
        MenuItem menuItem = new MenuItem("Reset cube rotation");
        menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                fXTuxCubeSVSubScene.stopCubeRotation();
                slider.setValue(50.0);
            }
        });
        MenuItem menuItem2 = new MenuItem("Reset Tux rotation");
        menuItem2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (FXTuxCubeSV.this.isTuxRotating) {
                    checkBox.setSelected(false);
                }
                fXTuxCubeSVSubScene.stopTuxRotation();
            }
        });
        Menu menu5 = new Menu("Scene anti-aliasing");
        final ToggleGroup toggleGroup5 = new ToggleGroup();
        final RadioMenuItem radioMenuItem11 = new RadioMenuItem("BALANCED");
        radioMenuItem11.setToggleGroup(toggleGroup5);
        radioMenuItem11.setSelected(true);
        RadioMenuItem radioMenuItem12 = new RadioMenuItem("DISABLED");
        radioMenuItem12.setToggleGroup(toggleGroup5);
        EventHandler<ActionEvent> eventHandler4 = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                SceneAntialiasing sceneAntialiasing = SceneAntialiasing.DISABLED;
                if (toggleGroup5.getSelectedToggle() == radioMenuItem11) {
                    sceneAntialiasing = SceneAntialiasing.BALANCED;
                }
                FXTuxCubeSV.this.subScene = fXTuxCubeSVSubScene.exchangeSubScene(sceneAntialiasing);
                pane.getChildren().set(1, (Object)FXTuxCubeSV.this.subScene);
            }
        };
        radioMenuItem11.setOnAction((EventHandler)eventHandler4);
        radioMenuItem12.setOnAction((EventHandler)eventHandler4);
        menu5.getItems().addAll((Object[])new MenuItem[]{radioMenuItem11, radioMenuItem12});
        MenuItem menuItem3 = new MenuItem("Exit");
        menuItem3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXTuxCubeSV.this.exit();
            }
        });
        final ContextMenu contextMenu = new ContextMenu();
        contextMenu.setHideOnEscape(true);
        contextMenu.getItems().addAll((Object[])new MenuItem[]{menu3, menu4, new SeparatorMenuItem(), menu, menu2, new SeparatorMenuItem(), menuItem, menuItem2, new SeparatorMenuItem(), menu5, new SeparatorMenuItem(), menuItem3});
        pane.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (contextMenu.isShowing()) {
                    contextMenu.hide();
                }
                if (mouseEvent.getButton() == MouseButton.SECONDARY && !FXTuxCubeSV.this.isMouseDragged) {
                    contextMenu.show((Node)pane, mouseEvent.getScreenX() + 2.0, mouseEvent.getScreenY() + 2.0);
                }
                FXTuxCubeSV.this.isMouseDragged = false;
                FXTuxCubeSV.this.checkFPS();
            }
        });
        pane.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                FXTuxCubeSV.this.isMouseDragged = true;
                FXTuxCubeSV.this.checkFPS();
            }
        });
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                FXTuxCubeSV.this.exit();
            }
        });
        stage.setScene(scene);
        stage.setTitle("InteractiveMesh : FXTuxCubeSV - Simultaneous Viewing - Proof of Concept");
        stage.show();
        this.lastTime = System.nanoTime();
        double d5 = fXTuxCubeSVSubScene.createTuxCubeOfDim(3, this.isTuxRotating, this.drawMode);
        this.secondView.setSceneDiameter(d5);
        fXTuxCubeSVSubScene.setVantagePoint(FXTuxCubeSVSubScene.VP.FRONT);
        this.secondView.setVantagePoint(FXTuxCubeSVSubScene.VP.FRONT);
        this.viewTimer.start();
        this.fpsTimer = new AnimationTimer(){

            public void handle(long l) {
                if (!FXTuxCubeSV.this.isUpdateFPS) {
                    return;
                }
                FXTuxCubeSV.this.frameCounter++;
                if (FXTuxCubeSV.this.frameCounter > FXTuxCubeSV.this.elapsedFrames) {
                    long l2 = System.nanoTime();
                    double d = (double)(l2 - FXTuxCubeSV.this.lastTime) / (double)FXTuxCubeSV.this.frameCounter;
                    FXTuxCubeSV.this.lastTime = l2;
                    int n = (int)(1.0E9 / d + 0.5);
                    int n2 = (int)(d / 1000000.0 + 0.5);
                    FXTuxCubeSV.this.frameCounter = 0;
                    FXTuxCubeSV.this.elapsedFrames = (int)Math.max(1.0f, (float)n / 3.0f);
                    FXTuxCubeSV.this.elapsedFrames = Math.min(100, FXTuxCubeSV.this.elapsedFrames);
                    FXTuxCubeSV.this.fpsLabel.setText(Integer.toString(n));
                    FXTuxCubeSV.this.mpfLabel.setText(Integer.toString(n2));
                }
            }
        };
    }

    private void checkFPS() {
        boolean bl;
        boolean bl2 = bl = this.isTuxRotating || this.isCubeRotating || this.isMouseDragged;
        if (this.isUpdateFPS == bl) {
            return;
        }
        this.isUpdateFPS = bl;
        if (!this.isUpdateFPS) {
            this.fpsTimer.stop();
            this.fpsLabel.setText(Integer.toString(0));
            this.mpfLabel.setText(Integer.toString(0));
        } else {
            this.fpsTimer.start();
        }
    }

    private void exit() {
        System.exit(0);
    }

    private final class HUDLabel
    extends Label {
        private HUDLabel(String string) {
            this(string, fXTuxCubeSV.textFont);
        }

        private HUDLabel(String string, Font font) {
            super(string);
            this.setFont(font);
            this.setTextFill((Paint)Color.WHITE);
        }
    }
}

