/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.image;

import com.interactivemesh.jfx.image.ImageIOInputStreamArray;
import com.interactivemesh.jfx.image.ImageIOInputStreamBuffer;
import com.interactivemesh.jfx.image.TgaImageReader;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;

class ImageFactoryImpl {
    byte[] currImageArray = null;
    int currImageArrayLimit = -1;
    ByteBuffer currImageBuffer = null;
    private ByteBuffer dImageBuffer = null;
    private int initCap = 0x100000;
    private ImageIOInputStreamArray imageIOStreamArr = null;
    private ImageIOInputStreamBuffer imageIOStreamBuf = null;
    private HashMap<String, ImageReader> imageIOReaderMap = new HashMap(4);
    private HashMap<String, ImageReadParam> imageIOReadParamMap = new HashMap(4);
    private TgaImageReader tgaImageReader = null;

    ImageFactoryImpl() {
    }

    void close() {
        if (!this.imageIOReaderMap.isEmpty()) {
            Collection<ImageReader> collection = this.imageIOReaderMap.values();
            Iterator<ImageReader> iterator = collection.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
            this.imageIOReaderMap.clear();
            this.imageIOReadParamMap.clear();
        }
        this.currImageArray = null;
        this.currImageBuffer = null;
        this.dImageBuffer = null;
        this.imageIOStreamArr = null;
        this.imageIOStreamBuf = null;
        this.tgaImageReader = null;
    }

    WritableImage readImage(String string, URL uRL) throws IOException {
        if (string.equalsIgnoreCase("jpg") || string.equalsIgnoreCase("jpeg")) {
            return this.readImageIO(string, uRL, ByteOrder.BIG_ENDIAN);
        }
        if (string.equalsIgnoreCase("png")) {
            return this.readImageIO(string, uRL, ByteOrder.BIG_ENDIAN);
        }
        if (string.equalsIgnoreCase("gif")) {
            return this.readImageIO(string, uRL, ByteOrder.LITTLE_ENDIAN);
        }
        if (string.equalsIgnoreCase("bmp")) {
            return this.readImageIO(string, uRL, ByteOrder.LITTLE_ENDIAN);
        }
        if (string.equalsIgnoreCase("tga")) {
            return this.readTgaImage(uRL);
        }
        return null;
    }

    private WritableImage readImageIO(String string, URL uRL, ByteOrder byteOrder) throws IOException {
        Object object;
        Object object2;
        ImageReader imageReader = this.imageIOReaderMap.get(string);
        if (imageReader == null) {
            object2 = ImageIO.getImageReadersByFormatName(string);
            while (object2.hasNext()) {
                imageReader = (ImageReader)object2.next();
                if (imageReader == null) continue;
                this.imageIOReaderMap.put(string, imageReader);
                object = imageReader.getDefaultReadParam();
                this.imageIOReadParamMap.put(string, (ImageReadParam)object);
                break;
            }
        }
        if ((object2 = this.setupImageBuffer(uRL)) == ImageData.ARRAY) {
            if (this.imageIOStreamArr == null) {
                this.imageIOStreamArr = new ImageIOInputStreamArray();
            }
            this.imageIOStreamArr.setup(this.currImageArray, this.currImageArrayLimit, byteOrder);
            imageReader.setInput(this.imageIOStreamArr, true, true);
            object = imageReader.read(0, this.imageIOReadParamMap.get(string));
            this.imageIOStreamArr.clear();
            return this.bImageToWImage((BufferedImage)object);
        }
        if (object2 == ImageData.BUFFER) {
            if (this.imageIOStreamBuf == null) {
                this.imageIOStreamBuf = new ImageIOInputStreamBuffer();
            }
            this.imageIOStreamBuf.setup(this.currImageBuffer, byteOrder);
            imageReader.setInput(this.imageIOStreamBuf, true, true);
            object = imageReader.read(0, this.imageIOReadParamMap.get(string));
            this.imageIOStreamBuf.clear();
            return this.bImageToWImage((BufferedImage)object);
        }
        return null;
    }

    private WritableImage readTgaImage(URL uRL) throws IOException {
        ImageData imageData = this.setupImageBuffer(uRL);
        if (imageData == ImageData.ARRAY) {
            if (this.tgaImageReader == null) {
                this.tgaImageReader = new TgaImageReader();
            }
            return this.tgaImageReader.readTgaImage(this.currImageArray, this.currImageArrayLimit);
        }
        if (imageData == ImageData.BUFFER) {
            if (this.tgaImageReader == null) {
                this.tgaImageReader = new TgaImageReader();
            }
            this.currImageBuffer.order(ByteOrder.LITTLE_ENDIAN);
            return this.tgaImageReader.readTgaImage(this.currImageBuffer);
        }
        return null;
    }

    final ImageData setupImageBuffer(URL uRL) throws IOException {
        Object object;
        try {
            FileChannel fileChannel;
            String string = uRL.toExternalForm();
            if (string.indexOf("file") >= 0 && string.indexOf("jar:") < 0 && (object = new File(uRL.toURI())) != null && ((File)object).canRead() && (fileChannel = new FileInputStream((File)object).getChannel()) != null && fileChannel.isOpen()) {
                ByteBuffer byteBuffer = this.readFullyDirect(fileChannel);
                fileChannel.close();
                if (byteBuffer != null) {
                    this.currImageBuffer = byteBuffer;
                    return ImageData.BUFFER;
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            URLConnection e = uRL.openConnection();
            object = e.getInputStream();
            if (object != null) {
                int n = this.readFullyArray((InputStream)object);
                ((InputStream)object).close();
                if (n > 0) {
                    return ImageData.ARRAY;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ImageData.NONE;
    }

    private ByteBuffer readFullyDirect(FileChannel fileChannel) throws IOException {
        int n;
        if (this.dImageBuffer == null) {
            this.dImageBuffer = ByteBuffer.allocateDirect(Math.max(this.initCap, (int)fileChannel.size()) + 4096);
        } else {
            n = (int)fileChannel.size();
            if (n > this.dImageBuffer.capacity()) {
                this.dImageBuffer = ByteBuffer.allocateDirect(n + 4096);
            }
        }
        this.dImageBuffer.order(ByteOrder.nativeOrder());
        this.dImageBuffer.clear();
        this.dImageBuffer.mark();
        n = 1;
        while (n != 0) {
            int n2 = fileChannel.read(this.dImageBuffer);
            if (n2 < 0) {
                n = 0;
                continue;
            }
            if (n2 == 0) {
                // empty if block
            }
            if (this.dImageBuffer.position() + 1024 > this.dImageBuffer.capacity()) {
                ByteBuffer byteBuffer = this.dImageBuffer;
                int n3 = this.dImageBuffer.position();
                int n4 = this.dImageBuffer.capacity();
                int n5 = n4 + this.initCap;
                this.dImageBuffer = ByteBuffer.allocateDirect(n5).order(ByteOrder.nativeOrder());
                this.dImageBuffer.clear();
                byteBuffer.position(0);
                byteBuffer.limit(n3);
                this.dImageBuffer.put(byteBuffer);
            }
            n = 1;
        }
        if (this.dImageBuffer.position() < 2) {
            return null;
        }
        this.dImageBuffer.limit(this.dImageBuffer.position());
        this.dImageBuffer.position(0);
        return this.dImageBuffer;
    }

    private int readFullyArray(InputStream inputStream) throws IOException {
        int n = inputStream.available() + 4096;
        if (this.currImageArray == null) {
            n = Math.max(n, this.initCap);
            this.currImageArray = new byte[n];
        } else if (n > this.currImageArray.length) {
            this.currImageArray = new byte[n];
        }
        boolean bl = true;
        int n2 = 0;
        int n3 = this.currImageArray.length;
        while (bl) {
            int n4 = inputStream.read(this.currImageArray, n2, n3);
            if (n4 < 0) {
                bl = false;
                continue;
            }
            if (n4 == 0) {
                // empty if block
            }
            if ((n2 += n4) + 1024 > this.currImageArray.length) {
                byte[] byArray = this.currImageArray;
                int n5 = this.currImageArray.length + this.initCap;
                this.currImageArray = new byte[n5];
                System.arraycopy(byArray, 0, this.currImageArray, 0, n2);
            }
            n3 = this.currImageArray.length - n2;
            bl = true;
        }
        this.currImageArrayLimit = n2;
        return this.currImageArrayLimit;
    }

    final WritableImage bImageToWImage(BufferedImage bufferedImage) {
        int n;
        int writablePixelFormat2;
        Object object;
        if (bufferedImage == null) {
            return null;
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = n3 * n4;
        WritableImage writableImage = new WritableImage(n3, n4);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        PixelFormat pixelFormat = pixelWriter.getPixelFormat();
        PixelFormat.Type type = pixelFormat.getType();
        if (type != PixelFormat.Type.BYTE_BGRA && type != PixelFormat.Type.BYTE_BGRA_PRE && type != PixelFormat.Type.INT_ARGB && type != PixelFormat.Type.INT_ARGB_PRE) {
            return null;
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n6 = colorSpace.getType();
        if (n6 != 5) {
            return SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        }
        int n7 = colorModel.getNumColorComponents();
        int n8 = colorModel.getNumComponents();
        if (n7 != 3) {
            return SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        SampleModel sampleModel = writableRaster.getSampleModel();
        int[] nArray = null;
        int[] nArray2 = null;
        int n9 = -1;
        if (sampleModel instanceof ComponentSampleModel) {
            object = (ComponentSampleModel)sampleModel;
            nArray = ((ComponentSampleModel)object).getBandOffsets();
            nArray2 = ((ComponentSampleModel)object).getBankIndices();
            if (nArray2 != null && nArray2.length > 0) {
                n9 = 0;
                for (int writablePixelFormat2 : nArray2) {
                    n9 = Math.max(n9, writablePixelFormat2);
                }
            }
        }
        if (colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel && sampleModel.getDataType() == 0 && n9 == 0) {
            object = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] n22 = ((DataBufferByte)object).getData();
            n = nArray[0];
            int byteBuffer = nArray[1];
            writablePixelFormat2 = nArray[2];
            int n23 = 0;
            if (type == PixelFormat.Type.BYTE_BGRA || type == PixelFormat.Type.BYTE_BGRA_PRE) {
                ByteBuffer intBuffer = ByteBuffer.allocateDirect(n3 * n4 * 4).order(ByteOrder.nativeOrder());
                if (n8 == 3) {
                    for (writablePixelFormat = 0; writablePixelFormat < n5; ++writablePixelFormat) {
                        intBuffer.put(n22[n23 + writablePixelFormat2]);
                        intBuffer.put(n22[n23 + byteBuffer]);
                        intBuffer.put(n22[n23 + n]);
                        intBuffer.put((byte)-1);
                        n23 += 3;
                    }
                } else {
                    writablePixelFormat = nArray[3];
                    if (type == PixelFormat.Type.BYTE_BGRA) {
                        for (int n16 = 0; n16 < n5; ++n16) {
                            intBuffer.put(n22[n23 + writablePixelFormat2]);
                            intBuffer.put(n22[n23 + byteBuffer]);
                            intBuffer.put(n22[n23 + n]);
                            intBuffer.put(n22[n23 + writablePixelFormat]);
                            n23 += 4;
                        }
                    } else {
                        for (int i = 0; i < n5; ++i) {
                            int n21 = n22[n23 + writablePixelFormat2] & 0xFF;
                            int n20 = n22[n23 + byteBuffer] & 0xFF;
                            int n19 = n22[n23 + n] & 0xFF;
                            i = n22[n23 + writablePixelFormat] & 0xFF;
                            n23 += 4;
                            if (i == 255) {
                                intBuffer.put((byte)n21);
                                intBuffer.put((byte)n20);
                                intBuffer.put((byte)n19);
                                intBuffer.put((byte)i);
                                continue;
                            }
                            if (i == 0) {
                                intBuffer.put((byte)0);
                                intBuffer.put((byte)0);
                                intBuffer.put((byte)0);
                                intBuffer.put((byte)0);
                                continue;
                            }
                            intBuffer.put((byte)((n21 * i + 127) / 255));
                            intBuffer.put((byte)((n20 * i + 127) / 255));
                            intBuffer.put((byte)((n19 * i + 127) / 255));
                            intBuffer.put((byte)i);
                        }
                    }
                }
                intBuffer.position(0);
                WritablePixelFormat n17 = PixelFormat.getByteBgraPreInstance();
                if (type == PixelFormat.Type.BYTE_BGRA) {
                    n17 = PixelFormat.getByteBgraInstance();
                }
                pixelWriter.setPixels(0, 0, n3, n4, (PixelFormat)n17, (Buffer)intBuffer, n3 * 4);
            } else if (type == PixelFormat.Type.INT_ARGB || type == PixelFormat.Type.INT_ARGB_PRE) {
                IntBuffer i = ByteBuffer.allocateDirect(n3 * n4 * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
                if (n8 == 3) {
                    for (writablePixelFormat = 0; writablePixelFormat < n5; ++writablePixelFormat) {
                        i.put(0xFF000000 | (n22[n23 + n] & 0xFF) << 16 | (n22[n23 + byteBuffer] & 0xFF) << 8 | n22[n23 + writablePixelFormat2] & 0xFF);
                        n23 += 3;
                    }
                } else {
                    writablePixelFormat = nArray[3];
                    if (type == PixelFormat.Type.INT_ARGB) {
                        for (int n18 = 0; n18 < n5; ++n18) {
                            i.put((n22[n23 + writablePixelFormat] & 0xFF) << 24 | (n22[n23 + n] & 0xFF) << 16 | (n22[n23 + byteBuffer] & 0xFF) << 8 | n22[n23 + writablePixelFormat2] & 0xFF);
                            n23 += 4;
                        }
                    } else {
                        for (int j = 0; j < n5; ++j) {
                            int n26 = n22[n23 + writablePixelFormat] & 0xFF;
                            int n2 = n22[n23 + n] & 0xFF;
                            int j2 = n22[n23 + byteBuffer] & 0xFF;
                            int i2 = n22[n23 + writablePixelFormat2] & 0xFF;
                            n23 += 4;
                            if (n26 == 255) {
                                i.put(n23++, (n26 & 0xFF) << 24 | (n2 & 0xFF) << 16 | (j2 & 0xFF) << 8 | i2 & 0xFF);
                                continue;
                            }
                            if (n26 == 0) {
                                i.put(n23++, 0);
                                continue;
                            }
                            i.put(n23++, (n26 & 0xFF) << 24 | (n2 * n26 + 127) / 255 << 16 | (j2 * n26 + 127) / 255 << 8 | (i2 * n26 + 127) / 255);
                        }
                    }
                }
                i.position(0);
                WritablePixelFormat n25 = PixelFormat.getIntArgbPreInstance();
                if (type == PixelFormat.Type.INT_ARGB) {
                    n25 = PixelFormat.getIntArgbInstance();
                }
                pixelWriter.setPixels(0, 0, n3, n4, (PixelFormat)n25, (Buffer)i, n3);
            }
        } else {
            int n10 = writableRaster.getNumBands();
            n = writableRaster.getDataBuffer().getDataType();
            switch (n) {
                case 0: {
                    object = new byte[n10];
                    break;
                }
                case 1: {
                    object = new short[n10];
                    break;
                }
                case 3: {
                    object = new int[n10];
                    break;
                }
                case 4: {
                    object = new float[n10];
                    break;
                }
                case 5: {
                    object = new double[n10];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown data buffer type: " + n);
                }
            }
            if (type == PixelFormat.Type.BYTE_BGRA || type == PixelFormat.Type.BYTE_BGRA_PRE) {
                ByteBuffer intBuffer = ByteBuffer.allocateDirect(n3 * n4 * 4).order(ByteOrder.nativeOrder());
                writablePixelFormat2 = 0;
                if (n8 == 3) {
                    for (writablePixelFormat = 0; writablePixelFormat < n4; ++writablePixelFormat) {
                        for (int i = 0; i < n3; ++i) {
                            writablePixelFormat2 = colorModel.getRGB(writableRaster.getDataElements(i, writablePixelFormat, object));
                            intBuffer.put((byte)(writablePixelFormat2 & 0xFF));
                            intBuffer.put((byte)((writablePixelFormat2 & 0xFF00) >> 8));
                            intBuffer.put((byte)((writablePixelFormat2 & 0xFF0000) >> 16));
                            intBuffer.put((byte)-1);
                        }
                    }
                } else if (type == PixelFormat.Type.BYTE_BGRA) {
                    for (writablePixelFormat = 0; writablePixelFormat < n4; ++writablePixelFormat) {
                        for (int n24 = 0; n24 < n3; ++n24) {
                            writablePixelFormat2 = colorModel.getRGB(writableRaster.getDataElements(n24, writablePixelFormat, object));
                            intBuffer.put((byte)(writablePixelFormat2 & 0xFF));
                            intBuffer.put((byte)((writablePixelFormat2 & 0xFF00) >> 8));
                            intBuffer.put((byte)((writablePixelFormat2 & 0xFF0000) >> 16));
                            intBuffer.put((byte)((writablePixelFormat2 & 0xFF000000) >> 24));
                        }
                    }
                } else {
                    for (int i = 0; i < n4; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            writablePixelFormat2 = colorModel.getRGB(writableRaster.getDataElements(j, i, object));
                            writablePixelFormat = (writablePixelFormat2 & 0xFF000000) >> 24;
                            int n28 = (writablePixelFormat2 & 0xFF0000) >> 16;
                            int n29 = (writablePixelFormat2 & 0xFF00) >> 8;
                            int n30 = writablePixelFormat2 & 0xFF;
                            if (writablePixelFormat == 255) {
                                intBuffer.put((byte)n30);
                                intBuffer.put((byte)n29);
                                intBuffer.put((byte)n28);
                                intBuffer.put((byte)writablePixelFormat);
                                continue;
                            }
                            if (writablePixelFormat == 0) {
                                intBuffer.put((byte)0);
                                intBuffer.put((byte)0);
                                intBuffer.put((byte)0);
                                intBuffer.put((byte)0);
                                continue;
                            }
                            intBuffer.put((byte)((n30 * writablePixelFormat + 127) / 255));
                            intBuffer.put((byte)((n29 * writablePixelFormat + 127) / 255));
                            intBuffer.put((byte)((n28 * writablePixelFormat + 127) / 255));
                            intBuffer.put((byte)writablePixelFormat);
                        }
                    }
                }
                intBuffer.position(0);
                WritablePixelFormat i = PixelFormat.getByteBgraPreInstance();
                if (type == PixelFormat.Type.BYTE_BGRA) {
                    i = PixelFormat.getByteBgraInstance();
                }
                pixelWriter.setPixels(0, 0, n3, n4, (PixelFormat)i, (Buffer)intBuffer, n3 * 4);
            } else if (type == PixelFormat.Type.INT_ARGB || type == PixelFormat.Type.INT_ARGB_PRE) {
                IntBuffer intBuffer = ByteBuffer.allocateDirect(n3 * n4 * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
                if (n8 == 3) {
                    for (writablePixelFormat2 = 0; writablePixelFormat2 < n4; ++writablePixelFormat2) {
                        for (int i = 0; i < n3; ++i) {
                            intBuffer.put(colorModel.getRGB(writableRaster.getDataElements(i, writablePixelFormat2, object)) | 0xFF000000);
                        }
                    }
                } else if (type == PixelFormat.Type.INT_ARGB) {
                    for (writablePixelFormat2 = 0; writablePixelFormat2 < n4; ++writablePixelFormat2) {
                        for (int n27 = 0; n27 < n3; ++n27) {
                            intBuffer.put(colorModel.getRGB(writableRaster.getDataElements(n27, writablePixelFormat2, object)));
                        }
                    }
                } else {
                    writablePixelFormat2 = 0;
                    for (int i = 0; i < n4; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            writablePixelFormat2 = colorModel.getRGB(writableRaster.getDataElements(j, i, object));
                            int n11 = (writablePixelFormat2 & 0xFF000000) >> 24;
                            int n12 = (writablePixelFormat2 & 0xFF0000) >> 16;
                            int n13 = (writablePixelFormat2 & 0xFF00) >> 8;
                            int n14 = writablePixelFormat2 & 0xFF;
                            if (n11 == 255) {
                                intBuffer.put((n11 & 0xFF) << 24 | (n12 & 0xFF) << 16 | (n13 & 0xFF) << 8 | n14 & 0xFF);
                                continue;
                            }
                            if (n11 == 0) {
                                intBuffer.put(0);
                                continue;
                            }
                            intBuffer.put((n11 & 0xFF) << 24 | (n12 * n11 + 127) / 255 << 16 | (n13 * n11 + 127) / 255 << 8 | (n14 * n11 + 127) / 255);
                        }
                    }
                }
                intBuffer.position(0);
                WritablePixelFormat writablePixelFormat3 = PixelFormat.getIntArgbPreInstance();
                if (type == PixelFormat.Type.INT_ARGB) {
                    writablePixelFormat3 = PixelFormat.getIntArgbInstance();
                }
                pixelWriter.setPixels(0, 0, n3, n4, (PixelFormat)writablePixelFormat3, (Buffer)intBuffer, n3);
            }
        }
        return writableImage;
    }

    static enum ImageData {
        ARRAY,
        BUFFER,
        NONE;

    }
}

