
package org.interactivemesh.jfx.sample3d.tuxcubesv;

import javafx.event.EventHandler;

import javafx.geometry.Bounds;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.SnapshotParameters;

import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;

import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

import org.interactivemesh.jfx.sample3d.tuxcubesv.FXTuxCubeSVSubScene.VP;

/**
 * org.interactivemesh.jfx.sample3d.tuxcubesv.AnotherView.java
 *
 * Date: 2013/10/31  
 * 
 * Author:
 * August Lammersdorf, InteractiveMesh e.K.
 * Hauptstrae 28d, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'AnotherView.java'.
 *
 */
final class AnotherView {
    
    private final Group root3D;
    private double sceneDiameter =  0;
   
    private final SnapshotParameters params;
    private final ImageView viewPane;
    private WritableImage wImage = null;
    
    private final Affine viewingRotate = new Affine();  
    private final Translate viewingTranslate = new Translate();
    private double startX = 0;
    private double startY = 0;
    
    private final PerspectiveCamera perspectiveCamera;  
    
    AnotherView(final Group root3D) {
        
        // Root of 3D scene        
        this.root3D = root3D;
                
        // AnotherView's camera
        perspectiveCamera = new PerspectiveCamera(true);
        perspectiveCamera.setVerticalFieldOfView(false);
        perspectiveCamera.setFarClip(250);
        perspectiveCamera.setNearClip(0.1);
        perspectiveCamera.setFieldOfView(44);
        
        perspectiveCamera.getTransforms().setAll(viewingRotate, viewingTranslate);
        
        params = new SnapshotParameters();
        params.setCamera(perspectiveCamera);
        params.setDepthBuffer(true);

        // UI element
        viewPane = new ImageView();
        
        // Navigator on AnotherView
        
        final Rotate viewingRotX = new Rotate(0, 0,0,0, Rotate.X_AXIS);      
        final Rotate viewingRotY = new Rotate(0, 0,0,0, Rotate.Y_AXIS);        
                
        viewPane.setOnMouseDragged(new EventHandler<MouseEvent>() {
            @Override public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.PRIMARY) {                    
                    viewingRotX.setAngle((startY - event.getSceneY())/10); 
                    viewingRotY.setAngle((event.getSceneX() - startX)/10);                                        
                    viewingRotate.append(viewingRotX.createConcatenation(viewingRotY));
                }
                else if (event.getButton() == MouseButton.SECONDARY) {
                    viewingTranslate.setX(viewingTranslate.getX() + (startX - event.getSceneX())/100);
                    viewingTranslate.setY(viewingTranslate.getY() + (startY - event.getSceneY())/100);
                }
                else if (event.getButton() == MouseButton.MIDDLE) {
                    viewingTranslate.setZ(viewingTranslate.getZ() + (event.getSceneY() - startY)/40);
                }
                     
                startX = event.getSceneX();
                startY = event.getSceneY();
           }
        });
        viewPane.setOnScroll(new EventHandler<ScrollEvent>() {
            @Override public void handle(ScrollEvent event) {
                viewingTranslate.setZ(viewingTranslate.getZ() - event.getDeltaY()/40);
            }
        });
        viewPane.setOnMousePressed(new EventHandler<MouseEvent>() {
            @Override public void handle(MouseEvent event) {
                startX = event.getSceneX();
                startY = event.getSceneY();
            }
        });       
    
    }
    
    ImageView getViewPane() {
        return viewPane;
    }
    
    void drawView(final double width, final double height) {
        
        params.setViewport(new Rectangle2D(0, 0, width, height));
        
        if (wImage == null ||
            wImage.getWidth() != width || wImage.getHeight() != height) {
            wImage = root3D.snapshot(params, null);
        }
        else {
            root3D.snapshot(params, wImage);
        }

        viewPane.setImage(wImage);
    }
    
    void setBackground(final Paint bg) {
        params.setFill(bg);
    }
    
    void setSceneDiameter(final double sceneDiameter) {
        this.sceneDiameter = sceneDiameter;
    }
    
    void setVantagePoint(final VP vp) {
        
        Transform rotate = null;
        
        final double distance = distToSceneCenter(sceneDiameter/2);
        
        switch(vp) {
            case BOTTOM:
                rotate = new Rotate(90, Rotate.X_AXIS);
                break;
            case CORNER:
                Rotate rotateX = new Rotate(-45, Rotate.X_AXIS);
                Rotate rotateY = new Rotate(-45, new Point3D(0, 1, 1).normalize());
                rotate = rotateX.createConcatenation(rotateY);
                break;
            case FRONT:
                rotate = new Rotate();
                break;
            case TOP:
                rotate = new Rotate(-90, Rotate.X_AXIS);
               break;
        }
        
        viewingRotate.setToTransform(rotate);
                
        viewingTranslate.setX(0);
        viewingTranslate.setY(0);
        viewingTranslate.setZ(-distance);
    }    
    
    private double distToSceneCenter(final double sceneRadius) {
        // Extra space
        final double borderFactor = 1.0;
        
        final double fov = perspectiveCamera.getFieldOfView();
        
        final Bounds bil = viewPane.getBoundsInLocal();
        final double c3dWidth = bil.getWidth();
        final double c3dHeight = bil.getHeight();
        // Consider ratio of canvas' width and height
        double ratioFactor = 1.0;
        if (c3dWidth > c3dHeight) {
            ratioFactor = c3dWidth/c3dHeight;
        }

        final double distToSceneCenter = borderFactor * ratioFactor * sceneRadius / Math.tan(Math.toRadians(fov/2));

        return distToSceneCenter;        
    }
}
