/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.image.ImageFactory;
import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.Viewpoint;
import com.interactivemesh.jfx.importer.fxml.FxImporterImpl;
import com.interactivemesh.jfx.importer.fxml.FxUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.scene.Camera;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.PhongMaterial;

final class ElementBase {
    FxImporterImpl.BaseURL baseUrlMain;
    boolean isGenerateNormals = false;
    boolean isReverse = false;
    boolean isWritableImage = false;
    boolean isIgnoreCameras = false;
    boolean isIgnoreLights = false;
    double creaseAngle = (float)Math.toRadians(45.0);
    final FxUtils fxUtils;
    final ImageFactory imgFactory;
    private final HashMap<String, Node> namedNodes = new HashMap();
    private final HashMap<String, PhongMaterial> namedMaterials = new HashMap();
    private final IdentityHashMap<Image, FilePath> imagePaths = new IdentityHashMap();
    private final ArrayList<Viewpoint> viewpointList = new ArrayList();
    private final ArrayList<Node> camLightList = new ArrayList();
    private long nameExt = 1L;
    private final HashSet<String> uniqueNames = new HashSet(100);
    private long matExt = 1L;
    private final String PhonMatName = "PhongMaterial_";

    ElementBase(FxUtils fxUtils) {
        this.fxUtils = fxUtils;
        this.imgFactory = new ImageFactory();
    }

    String createUniqueName(String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        boolean bl = this.uniqueNames.contains(string);
        if (bl) {
            String string2 = null;
            while (bl) {
                string2 = string + "_" + this.nameExt;
                ++this.nameExt;
                bl = this.uniqueNames.contains(string2);
            }
            this.uniqueNames.add(string2);
            return string2;
        }
        this.uniqueNames.add(string);
        return string;
    }

    void putNamedNode(String string, Node node) {
        if (string == null || node == null) {
            System.out.println("ElementBase name / node = " + string + " / " + node);
        } else {
            this.namedNodes.put(string, node);
        }
    }

    Map<String, Node> getNamedNodes() {
        int n = 0;
        n = this.namedNodes.size();
        if (n > 0) {
            HashMap<String, Node> hashMap = new HashMap<String, Node>(n, 1.0f);
            hashMap.putAll(this.namedNodes);
            return hashMap;
        }
        return null;
    }

    void putNamedMaterial(PhongMaterial phongMaterial) {
        this.namedMaterials.put("PhongMaterial_" + this.matExt, phongMaterial);
        ++this.matExt;
    }

    Map<String, PhongMaterial> getNamedMaterials() {
        int n = 0;
        n = this.namedMaterials.size();
        if (n > 0) {
            HashMap<String, PhongMaterial> hashMap = new HashMap<String, PhongMaterial>(n, 1.0f);
            hashMap.putAll(this.namedMaterials);
            return hashMap;
        }
        return null;
    }

    void putImagePath(Image image, FilePath filePath) {
        this.imagePaths.put(image, filePath);
    }

    IdentityHashMap<Image, FilePath> getImagePaths() {
        if (this.imagePaths.size() > 0) {
            IdentityHashMap<Image, FilePath> identityHashMap = new IdentityHashMap<Image, FilePath>();
            identityHashMap.putAll(this.imagePaths);
            return identityHashMap;
        }
        return null;
    }

    void addViewpoint(Viewpoint viewpoint) {
        this.viewpointList.add(viewpoint);
    }

    Viewpoint[] getViewpoints() {
        Viewpoint[] viewpointArray = null;
        if (!this.viewpointList.isEmpty()) {
            viewpointArray = new Viewpoint[this.viewpointList.size()];
            int n = 0;
            for (Viewpoint viewpoint : this.viewpointList) {
                viewpointArray[n++] = viewpoint;
            }
        }
        return viewpointArray;
    }

    void addCamera(Camera camera) {
        this.camLightList.add((Node)camera);
    }

    void addLight(LightBase lightBase) {
        this.camLightList.add((Node)lightBase);
    }

    void clear() {
        this.isGenerateNormals = false;
        this.isReverse = false;
        this.isWritableImage = false;
        this.isIgnoreCameras = false;
        this.isIgnoreLights = false;
        this.creaseAngle = (float)Math.toRadians(44.0);
        this.namedNodes.clear();
        this.namedMaterials.clear();
        this.imagePaths.clear();
        this.viewpointList.clear();
        this.camLightList.clear();
        this.nameExt = 1L;
        this.uniqueNames.clear();
        this.matExt = 1L;
    }

    void close() {
        if (this.imgFactory != null) {
            this.imgFactory.close();
        }
    }
}

