/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.BoxParser;
import com.interactivemesh.jfx.importer.fxml.CameraParser;
import com.interactivemesh.jfx.importer.fxml.ColorParser;
import com.interactivemesh.jfx.importer.fxml.CylinderParser;
import com.interactivemesh.jfx.importer.fxml.ElementBase;
import com.interactivemesh.jfx.importer.fxml.ElementCache;
import com.interactivemesh.jfx.importer.fxml.FxImporterImpl;
import com.interactivemesh.jfx.importer.fxml.FxmlRootParser;
import com.interactivemesh.jfx.importer.fxml.GroupParser;
import com.interactivemesh.jfx.importer.fxml.LightParser;
import com.interactivemesh.jfx.importer.fxml.MeshViewParser;
import com.interactivemesh.jfx.importer.fxml.NullParser;
import com.interactivemesh.jfx.importer.fxml.PhongMaterialParser;
import com.interactivemesh.jfx.importer.fxml.Point3DParser;
import com.interactivemesh.jfx.importer.fxml.SphereParser;
import com.interactivemesh.jfx.importer.fxml.TransformsParser;
import com.interactivemesh.jfx.importer.fxml.TriangleMeshParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.shape.Box;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.TriangleMesh;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class FxFileParser {
    XMLStreamReader xR = null;
    private AbstractElementParser currElementParser = null;
    final ElementBase base;
    ElementCache currCache = null;
    private final XMLInputFactory xmlif;
    private final FxmlRootParser fxmlRootParser;
    private final BoxParser boxParser;
    private final CameraParser cameraParser;
    private final ColorParser colorParser;
    private final CylinderParser cylinderParser;
    private final LightParser lightParser;
    private final MeshViewParser meshViewParser;
    private final PhongMaterialParser phongMatParser;
    private final Point3DParser point3DParser;
    private final SphereParser sphereParser;
    private final TransformsParser transformsParser;
    private final TriangleMeshParser triangleMeshParser;
    private final NullParser nullParser;
    private final ArrayList<GroupParser> nestedGroupParsers = new ArrayList();
    final FxImporterImpl importerImpl;
    private static final char DOT = '.';
    private static final char JLC = 'j';
    private int num = 0;

    FxFileParser(FxImporterImpl fxImporterImpl, XMLInputFactory xMLInputFactory, ElementBase elementBase) {
        this.importerImpl = fxImporterImpl;
        this.xmlif = xMLInputFactory;
        this.base = elementBase;
        this.fxmlRootParser = new FxmlRootParser(this);
        this.boxParser = new BoxParser(this);
        this.cameraParser = new CameraParser(this);
        this.colorParser = new ColorParser(this);
        this.cylinderParser = new CylinderParser(this);
        this.lightParser = new LightParser(this);
        this.meshViewParser = new MeshViewParser(this);
        this.phongMatParser = new PhongMaterialParser(this);
        this.point3DParser = new Point3DParser(this);
        this.sphereParser = new SphereParser(this);
        this.transformsParser = new TransformsParser(this);
        this.triangleMeshParser = new TriangleMeshParser(this);
        this.nullParser = new NullParser(this);
    }

    void clear() {
        this.xR = null;
        this.currCache = null;
    }

    void close() {
        this.clear();
        this.fxmlRootParser.close();
        this.boxParser.close();
        this.cameraParser.close();
        this.colorParser.close();
        this.cylinderParser.close();
        this.lightParser.close();
        this.meshViewParser.close();
        this.phongMatParser.close();
        this.point3DParser.close();
        this.sphereParser.close();
        this.transformsParser.close();
        this.triangleMeshParser.close();
        this.nullParser.close();
        if (this.nestedGroupParsers.size() > 0) {
            for (GroupParser groupParser : this.nestedGroupParsers) {
                groupParser.close();
            }
            this.nestedGroupParsers.clear();
        }
    }

    Node parse(InputStream inputStream, ElementCache elementCache, Group group) {
        this.clear();
        this.currCache = elementCache;
        boolean bl = false;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
        try {
            this.xR = this.xmlif.createXMLStreamReader(inputStreamReader);
            this.fxmlRootParser.setup(group);
            this.currElementParser = this.fxmlRootParser;
            int n = -1;
            while (this.xR.hasNext()) {
                n = this.xR.next();
                if (n == 1) {
                    this.currElementParser.startElement(this.getElementName(this.xR.getLocalName()));
                    continue;
                }
                if (n == 4) {
                    this.currElementParser.characters();
                    continue;
                }
                if (n == 2) {
                    this.currElementParser.endElement(this.getElementName(this.xR.getLocalName()));
                    continue;
                }
                if (n != 8) continue;
                this.xR.close();
            }
            Node node = this.fxmlRootParser.getFxmlRoot();
            this.fxmlRootParser.clear();
            inputStreamReader.close();
            bl = true;
            Node node2 = node;
            return node2;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ImportException("Reading FXML file failed 0 : \n" + xMLStreamException.getMessage(), xMLStreamException);
        }
        catch (ImportException importException) {
            throw importException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ImportException("Reading FXML file failed 1 : \n" + exception.getMessage(), exception);
        }
        finally {
            if (!bl) {
                try {
                    this.xR.close();
                    inputStreamReader.close();
                }
                catch (Exception exception) {
                    throw new ImportException("Can't close FXML reader !");
                }
            }
        }
    }

    private String getElementName(String string) {
        int n;
        if (string.charAt(0) == 'j' && (n = string.lastIndexOf(46)) > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    void setParser(AbstractElementParser abstractElementParser) {
        this.currElementParser = abstractElementParser;
    }

    void setBoxParser(AbstractElementParser abstractElementParser, Box box) {
        this.boxParser.setup(abstractElementParser, box);
        this.currElementParser = this.boxParser;
    }

    void setCameraParser(AbstractElementParser abstractElementParser, Camera camera, String string, Group group) {
        this.cameraParser.setup(abstractElementParser, camera, string, group);
        this.currElementParser = this.cameraParser;
    }

    ColorParser setColorParser(AbstractElementParser abstractElementParser) {
        this.colorParser.setup(abstractElementParser);
        this.currElementParser = this.colorParser;
        return this.colorParser;
    }

    CylinderParser setCylinderParser(AbstractElementParser abstractElementParser, Group group) {
        this.cylinderParser.setup(abstractElementParser, group);
        this.currElementParser = this.cylinderParser;
        return this.cylinderParser;
    }

    void setLightParser(AbstractElementParser abstractElementParser, LightBase lightBase, String string) {
        this.lightParser.setup(abstractElementParser, lightBase, string);
        this.currElementParser = this.lightParser;
    }

    void setMeshViewParser(AbstractElementParser abstractElementParser, MeshView meshView) {
        this.meshViewParser.setup(abstractElementParser, meshView);
        this.currElementParser = this.meshViewParser;
    }

    PhongMaterialParser setPhongMaterialParser(AbstractElementParser abstractElementParser, Shape3D shape3D) {
        this.phongMatParser.setup(abstractElementParser, shape3D);
        this.currElementParser = this.phongMatParser;
        return this.phongMatParser;
    }

    Point3DParser setPoint3DParser(AbstractElementParser abstractElementParser) {
        this.point3DParser.setup(abstractElementParser);
        this.currElementParser = this.point3DParser;
        return this.point3DParser;
    }

    SphereParser setSphereParser(AbstractElementParser abstractElementParser, Group group) {
        this.sphereParser.setup(abstractElementParser, group);
        this.currElementParser = this.sphereParser;
        return this.sphereParser;
    }

    TransformsParser setTransformsParser(AbstractElementParser abstractElementParser, Node node) {
        this.transformsParser.setup(abstractElementParser, node);
        this.currElementParser = this.transformsParser;
        return this.transformsParser;
    }

    void setTriangleMeshParser(AbstractElementParser abstractElementParser, TriangleMesh triangleMesh) {
        this.triangleMeshParser.setup(abstractElementParser, triangleMesh);
        this.currElementParser = this.triangleMeshParser;
    }

    void setNullParser(AbstractElementParser abstractElementParser, String string) {
        this.nullParser.setup(abstractElementParser, string);
        this.currElementParser = this.nullParser;
    }

    void setNestedGroupParser(AbstractElementParser abstractElementParser, Group group) {
        GroupParser groupParser = null;
        if (this.nestedGroupParsers.isEmpty()) {
            groupParser = new GroupParser(this);
            groupParser.num = this.num++;
        } else {
            groupParser = this.nestedGroupParsers.remove(this.nestedGroupParsers.size() - 1);
        }
        groupParser.setup(abstractElementParser, group);
        this.currElementParser = groupParser;
    }

    void cacheNestedGroupParser(GroupParser groupParser) {
        this.nestedGroupParsers.add(groupParser);
    }
}

