/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.COLLADAParser;
import com.interactivemesh.jfx.importer.col.Effect;
import com.interactivemesh.jfx.importer.col.ImageC;
import com.interactivemesh.jfx.importer.col.LibEffects;
import com.interactivemesh.jfx.importer.col.NewParam;
import com.interactivemesh.jfx.importer.col.ProfileCOMMON;
import com.interactivemesh.jfx.importer.col.ProfileCOMParser;

final class LibEffectsParser
extends AbstractElementParser {
    private COLLADAParser colladaParser = null;
    private LibEffects libEffects = null;
    private Effect currEffect = null;
    private boolean isEffect = false;
    private ProfileCOMParser profileCOMParser = null;

    LibEffectsParser(COLLADAParser cOLLADAParser, LibEffects libEffects) {
        super(cOLLADAParser.cfp);
        this.colladaParser = cOLLADAParser;
        this.libEffects = libEffects;
    }

    void setup(LibEffects libEffects) {
        this.libEffects = libEffects;
    }

    @Override
    void doClose() {
        this.colladaParser = null;
    }

    @Override
    void startElement(String string) {
        if (this.isEffect) {
            if (string.equals("newparam")) {
                NewParam newParam = new NewParam(this.cfp.xR.getAttributeValue(null, "sid"));
                this.currEffect.effectSidNParamMap.put(newParam.getSID(), newParam);
                this.cfp.setNSParamParser(this, newParam);
            } else if (string.equals("profile_COMMON")) {
                ProfileCOMMON profileCOMMON = new ProfileCOMMON();
                profileCOMMON.id = this.cfp.xR.getAttributeValue(null, "id");
                this.currEffect.profileCOM = profileCOMMON;
                if (this.profileCOMParser == null) {
                    this.profileCOMParser = new ProfileCOMParser(this, profileCOMMON);
                } else {
                    this.profileCOMParser.setup(profileCOMMON);
                }
                this.cfp.setParser(this.profileCOMParser);
            } else if (string.equals("profile_GLSL")) {
                this.cfp.setNullParser(this, string);
                System.out.println("LibEffectParser : profile_GLSL is not supported !");
            } else if (string.equals("profile_CG")) {
                this.cfp.setNullParser(this, string);
                System.out.println("LibEffectParser : profile_CG is not supported yet !");
            } else if (string.equals("profile_GLES")) {
                this.cfp.setNullParser(this, string);
                System.out.println("LibEffectParser : profile_GLES is not supported !");
            } else if (string.equals("profile_GLES2")) {
                this.cfp.setNullParser(this, string);
                System.out.println("LibEffectParser : profile_GLES2 is not supported !");
            } else if (string.equals("profile_BRIDGE")) {
                this.cfp.setNullParser(this, string);
                System.out.println("LibEffectParser : profile_BRIDGE is not supported !");
            } else if (string.equals("image")) {
                ImageC imageC = new ImageC();
                imageC.getAttributes(this.cfp.xR, this.cfp.currFileVersion);
                this.libEffects.addImage(imageC);
                this.cfp.setImageParser(this, imageC);
            } else if (string.equals("asset")) {
                Asset asset;
                this.currEffect.asset = asset = new Asset();
                this.cfp.setAssetParser(this, asset);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            } else if (string.equals("annotate")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (string.equals("effect")) {
            this.currEffect = new Effect();
            this.currEffect.id = this.cfp.xR.getAttributeValue(null, "id");
            this.currEffect.name = this.cfp.xR.getAttributeValue(null, "name");
            this.libEffects.addEffect(this.currEffect);
            this.isEffect = true;
        } else if (string.equals("asset")) {
            Asset asset;
            this.libEffects.asset = asset = new Asset();
            this.cfp.setAssetParser(this, asset);
        } else if (string.equals("extra")) {
            this.cfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals("effect")) {
            this.isEffect = false;
            this.currEffect = null;
        } else if (string.equals("library_effects")) {
            this.cfp.setParser(this.colladaParser);
            this.libEffects = null;
        }
    }
}

