/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.ImageC;
import com.interactivemesh.jfx.importer.col.LibEffectsParser;
import com.interactivemesh.jfx.importer.col.NewParam;
import com.interactivemesh.jfx.importer.col.ProfileCOMExtraParser;
import com.interactivemesh.jfx.importer.col.ProfileCOMMON;

final class ProfileCOMParser
extends AbstractElementParserChar {
    private LibEffectsParser parentParser = null;
    private ProfileCOMExtraParser extraParser = null;
    private ProfileCOMMON profileCOM = null;
    private boolean isTechnique = false;
    private boolean isShading = false;
    private boolean isColor = false;
    private ProfileCOMMON.ColorType currColType = ProfileCOMMON.ColorType.NONE;

    ProfileCOMParser(LibEffectsParser libEffectsParser, ProfileCOMMON profileCOMMON) {
        super(libEffectsParser.cfp);
        this.parentParser = libEffectsParser;
        this.charArray = new char[200];
        this.setup(profileCOMMON);
    }

    void setup(ProfileCOMMON profileCOMMON) {
        this.profileCOM = profileCOMMON;
        this.arrPos = 0;
        this.isCharacter = false;
    }

    @Override
    void doClose() {
        this.charArray = null;
        if (this.extraParser != null) {
            this.extraParser.doClose();
        }
    }

    @Override
    void startElement(String string) {
        if (this.isTechnique) {
            if (this.isShading) {
                if (this.isColor) {
                    if (string.equals("color")) {
                        this.profileCOM.colorTypeMap.put(this.currColType, ProfileCOMMON.ColorValueType.F4);
                        String string2 = this.cfp.xR.getAttributeValue(null, "sid");
                        if (string2 != null) {
                            this.profileCOM.sidColorMap.put(string2, new ProfileCOMMON.ColorElement(string2, this.currColType));
                        }
                        this.isCharacter = true;
                        this.arrPos = 0;
                    } else if (string.equals("float")) {
                        this.profileCOM.colorTypeMap.put(this.currColType, ProfileCOMMON.ColorValueType.F1);
                        String string3 = this.cfp.xR.getAttributeValue(null, "sid");
                        if (string3 != null) {
                            this.profileCOM.sidFloatMap.put(string3, this.currColType);
                        }
                        this.isCharacter = true;
                        this.arrPos = 0;
                    } else if (string.equals("param")) {
                        this.profileCOM.colorTypeMap.put(this.currColType, ProfileCOMMON.ColorValueType.P);
                        this.profileCOM.paramRefMap.put(this.currColType, this.cfp.xR.getAttributeValue(null, "ref"));
                        this.isColor = false;
                        this.currColType = ProfileCOMMON.ColorType.NONE;
                    } else if (string.equals("texture")) {
                        this.profileCOM.colorTypeMap.put(this.currColType, ProfileCOMMON.ColorValueType.T);
                        ProfileCOMMON.TextureElement textureElement = new ProfileCOMMON.TextureElement(this.cfp.xR.getAttributeValue(null, "texture"), this.cfp.xR.getAttributeValue(null, "texcoord"));
                        this.profileCOM.texMap.put(this.currColType, textureElement);
                        this.currColType = ProfileCOMMON.ColorType.NONE;
                    } else if (string.equals("extra")) {
                        this.cfp.setNullParser(this, string);
                    } else {
                        System.out.println("ProfileCOMParser missing child for shader = " + (Object)((Object)this.currColType));
                    }
                } else {
                    if (string.equals("diffuse")) {
                        this.currColType = ProfileCOMMON.ColorType.DIFFUSE;
                    } else if (string.equals("specular")) {
                        this.currColType = ProfileCOMMON.ColorType.SPECULAR;
                    } else if (string.equals("shininess")) {
                        this.currColType = ProfileCOMMON.ColorType.SHININESS;
                    } else if (string.equals("ambient")) {
                        this.currColType = ProfileCOMMON.ColorType.AMBIENT;
                    } else if (string.equals("emission")) {
                        this.currColType = ProfileCOMMON.ColorType.EMISSION;
                    } else if (string.equals("transparent")) {
                        String string4 = this.cfp.xR.getAttributeValue(null, "opaque");
                        if (string4 != null) {
                            this.profileCOM.opaque = string4;
                        }
                        this.currColType = ProfileCOMMON.ColorType.TRANSPARENT;
                    } else if (string.equals("transparency")) {
                        this.currColType = ProfileCOMMON.ColorType.TRANSPARENCY;
                    } else if (string.equals("reflective")) {
                        this.currColType = ProfileCOMMON.ColorType.REFLECTIVE;
                    } else if (string.equals("reflectivity")) {
                        this.currColType = ProfileCOMMON.ColorType.REFLECTIVITY;
                    } else if (string.equals("index_of_refraction")) {
                        this.currColType = ProfileCOMMON.ColorType.INDEX_REFRACTION;
                    }
                    if (this.currColType != ProfileCOMMON.ColorType.NONE) {
                        this.isColor = true;
                        this.profileCOM.colorElements.add(this.currColType);
                    }
                }
            } else if (string.equals("phong")) {
                this.profileCOM.techShading = ProfileCOMMON.Shading.PHONG;
                this.isShading = true;
            } else if (string.equals("blinn")) {
                this.profileCOM.techShading = ProfileCOMMON.Shading.BLINN;
                this.isShading = true;
            } else if (string.equals("lambert")) {
                this.profileCOM.techShading = ProfileCOMMON.Shading.LAMBERT;
                this.isShading = true;
            } else if (string.equals("constant")) {
                this.profileCOM.techShading = ProfileCOMMON.Shading.CONSTANT;
                this.isShading = true;
            } else if (string.equals("newparam")) {
                NewParam newParam = new NewParam(this.cfp.xR.getAttributeValue(null, "sid"));
                this.profileCOM.techSidNParamMap.put(newParam.getSID(), newParam);
                this.cfp.setNSParamParser(this, newParam);
            } else if (string.equals("image")) {
                ImageC imageC = new ImageC();
                imageC.getAttributes(this.cfp.xR, this.cfp.currFileVersion);
                this.profileCOM.imageList.add(imageC);
                this.cfp.setImageParser(this, imageC);
            } else if (string.equals("asset")) {
                Asset asset;
                this.profileCOM.techAsset = asset = new Asset();
                this.cfp.setAssetParser(this, asset);
            } else if (string.equals("extra")) {
                if (this.extraParser == null) {
                    this.extraParser = new ProfileCOMExtraParser(this, this.profileCOM);
                } else {
                    this.extraParser.setup(this.profileCOM);
                }
                this.cfp.setParser(this.extraParser);
            }
        } else if (string.equals("newparam")) {
            NewParam newParam = new NewParam(this.cfp.xR.getAttributeValue(null, "sid"));
            this.profileCOM.commSidNParamMap.put(newParam.getSID(), newParam);
            this.cfp.setNSParamParser(this, newParam);
        } else if (string.equals("technique")) {
            this.profileCOM.techId = this.cfp.xR.getAttributeValue(null, "id");
            this.profileCOM.techSID = this.cfp.xR.getAttributeValue(null, "sid");
            this.isTechnique = true;
        } else if (string.equals("image")) {
            ImageC imageC = new ImageC();
            imageC.getAttributes(this.cfp.xR, this.cfp.currFileVersion);
            this.profileCOM.imageList.add(imageC);
            this.cfp.setImageParser(this, imageC);
        } else if (string.equals("asset")) {
            Asset asset;
            this.profileCOM.asset = asset = new Asset();
            this.cfp.setAssetParser(this, asset);
        } else if (string.equals("extra")) {
            if (this.extraParser == null) {
                this.extraParser = new ProfileCOMExtraParser(this, this.profileCOM);
            } else {
                this.extraParser.setup(this.profileCOM);
            }
            this.cfp.setParser(this.extraParser);
        }
    }

    @Override
    void endElement(String string) {
        if (this.isShading) {
            if (this.isColor) {
                if (this.isCharacter) {
                    if (string.equals("color")) {
                        String string2 = this.cUtils().trimString(this.charArray, this.arrPos);
                        float[] fArray = new float[4];
                        this.cUtils().splitFloatInto(string2, fArray);
                        this.profileCOM.float4Map.put(this.currColType, fArray);
                        this.currColType = ProfileCOMMON.ColorType.NONE;
                        this.isCharacter = false;
                    } else if (string.equals("float")) {
                        String string3 = this.cUtils().trimString(this.charArray, this.arrPos);
                        this.profileCOM.floatMap.put(this.currColType, Float.valueOf(Float.parseFloat(string3)));
                        this.currColType = ProfileCOMMON.ColorType.NONE;
                        this.isCharacter = false;
                    }
                }
                this.isColor = false;
            } else if (string.equals("phong")) {
                this.isShading = false;
            } else if (string.equals("blinn")) {
                this.isShading = false;
            } else if (string.equals("lambert")) {
                this.isShading = false;
            } else if (string.equals("constant")) {
                this.isShading = false;
            }
        } else if (string.equals("technique")) {
            this.isTechnique = false;
        } else if (string.equals("profile_COMMON")) {
            this.cfp.setParser(this.parentParser);
            this.profileCOM = null;
        }
    }
}

