/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.ColladaFileParser;
import com.interactivemesh.jfx.importer.col.Param;
import com.interactivemesh.jfx.importer.col.Source;
import com.interactivemesh.jfx.importer.col.ValueArray;

final class SourceParser
extends AbstractElementParserChar {
    private AbstractElementParser parentParser = null;
    private Source source = null;
    private ValueArray valueArray = null;
    private boolean isA = true;

    SourceParser(ColladaFileParser colladaFileParser) {
        super(colladaFileParser);
        this.charArray = new char[6000000];
    }

    void setup(AbstractElementParser abstractElementParser, Source source) {
        this.parentParser = abstractElementParser;
        this.source = source;
        this.arrPos = 0;
        this.isCharacter = false;
    }

    @Override
    void doClose() {
        this.charArray = null;
        this.valueArray = null;
    }

    private void getCommonArrayAttr() {
        String string = this.cfp.xR.getAttributeValue(null, "count");
        if (string != null) {
            this.valueArray.count = Integer.parseInt(string);
        }
        this.valueArray.id = this.cfp.xR.getAttributeValue(null, "id");
        this.valueArray.name = this.cfp.xR.getAttributeValue(null, "name");
        this.source.valueArray = this.valueArray;
        this.isCharacter = true;
    }

    @Override
    void startElement(String string) {
        if (string.equals("float_array")) {
            this.valueArray = new ValueArray(ValueArray.Type.FLOAT);
            this.getCommonArrayAttr();
            String string2 = this.cfp.xR.getAttributeValue(null, "digits");
            if (string2 != null) {
                this.valueArray.digits = Integer.parseInt(string2);
            }
            if ((string2 = this.cfp.xR.getAttributeValue(null, "magnitude")) != null) {
                this.valueArray.magnitude = Integer.parseInt(string2);
            }
        } else if (string.equals("accessor")) {
            String string3 = this.cfp.xR.getAttributeValue(null, "count");
            if (string3 != null) {
                this.source.accessorCount = Integer.parseInt(string3);
            }
            if ((string3 = this.cfp.xR.getAttributeValue(null, "offset")) != null) {
                this.source.accessorOffset = Integer.parseInt(string3);
            }
            if ((string3 = this.cfp.xR.getAttributeValue(null, "stride")) != null) {
                this.source.accessorStride = Integer.parseInt(string3);
            }
            this.source.accessorSource = this.cfp.xR.getAttributeValue(null, "source");
        } else if (string.equals("param")) {
            Param param = new Param();
            param.name = this.cfp.xR.getAttributeValue(null, "name");
            param.semantic = this.cfp.xR.getAttributeValue(null, "semantic");
            param.sid = this.cfp.xR.getAttributeValue(null, "sid");
            param.type = this.cfp.xR.getAttributeValue(null, "type");
            this.source.accessorParamList.add(param);
        } else if (string.equals("int_array")) {
            this.valueArray = new ValueArray(ValueArray.Type.INT);
            this.getCommonArrayAttr();
            String string4 = this.cfp.xR.getAttributeValue(null, "minInclusive");
            if (string4 != null) {
                this.valueArray.minInclusive = Integer.parseInt(string4);
            }
            if ((string4 = this.cfp.xR.getAttributeValue(null, "maxInclusive")) != null) {
                this.valueArray.maxInclusive = Integer.parseInt(string4);
            }
        } else if (string.equals("IDREF_array")) {
            this.valueArray = new ValueArray(ValueArray.Type.ID_REF);
            this.getCommonArrayAttr();
        } else if (string.equals("Name_array")) {
            this.valueArray = new ValueArray(ValueArray.Type.NAME);
            this.getCommonArrayAttr();
        } else if (string.equals("bool_array")) {
            this.valueArray = new ValueArray(ValueArray.Type.BOOL);
            this.getCommonArrayAttr();
        } else if (string.equals("SIDREF_array")) {
            this.valueArray = new ValueArray(ValueArray.Type.SIDREF);
            this.getCommonArrayAttr();
        } else if (string.equals("token_array")) {
            this.valueArray = new ValueArray(ValueArray.Type.TOKEN);
            this.getCommonArrayAttr();
        } else if (string.equals("technique")) {
            this.cfp.setNullParser(this, string);
            System.out.println("SourceParser : source's technique is not supported, profile = " + this.cfp.xR.getAttributeValue(null, "profile"));
        } else if (string.equals("asset")) {
            Asset asset;
            this.source.asset = asset = new Asset();
            this.cfp.setAssetParser(this, asset);
        }
        if (this.isCharacter) {
            this.arrPos = 0;
        }
    }

    @Override
    void endElement(String string) {
        if (this.isCharacter) {
            this.isCharacter = false;
            if (string.equals("float_array")) {
                if (this.valueArray.count > 0) {
                    float[] fArray = new float[this.valueArray.count];
                    if (this.isA) {
                        this.cUtils().splitFloatIntoA(this.charArray, this.arrPos, fArray);
                    } else {
                        this.cUtils().splitFloatIntoB(this.charArray, this.arrPos, fArray);
                    }
                    this.isA = !this.isA;
                    this.valueArray.setArray(fArray);
                }
            } else if (string.equals("int_array")) {
                if (this.valueArray.count > 0) {
                    int[] nArray = new int[this.valueArray.count];
                    this.cUtils().splitIntegerInto(this.charArray, this.arrPos, nArray);
                    this.valueArray.setArray(nArray);
                }
            } else if (string.equals("IDREF_array") || string.equals("Name_array")) {
                if (this.valueArray.count > 0) {
                    String[] stringArray = new String[this.valueArray.count];
                    this.cUtils().splitStringInto(this.charArray, this.arrPos, stringArray);
                    this.valueArray.setArray(stringArray);
                }
            } else if (string.equals("bool_array")) {
                if (this.valueArray.count > 0) {
                    String[] stringArray = new String[this.valueArray.count];
                    this.cUtils().splitStringInto(this.charArray, this.arrPos, stringArray);
                    boolean[] blArray = new boolean[this.valueArray.count];
                    int n = 0;
                    for (String string2 : stringArray) {
                        if (string2.equalsIgnoreCase("true")) {
                            blArray[n++] = true;
                            continue;
                        }
                        if (string2.equalsIgnoreCase("false")) {
                            blArray[n++] = false;
                            continue;
                        }
                        throw new ImportException("SourceParser bool-array : neither true nor false! string = " + string2);
                    }
                    this.valueArray.setArray(blArray);
                }
            } else if ((string.equals("SIDREF_array") || string.equals("token_array")) && this.valueArray.count > 0) {
                String[] stringArray = new String[this.valueArray.count];
                this.cUtils().splitStringInto(this.charArray, this.arrPos, stringArray);
                this.valueArray.setArray(stringArray);
            }
        } else if (string.equals("source")) {
            this.cfp.setParser(this.parentParser);
            this.source = null;
            this.parentParser = null;
            this.valueArray = null;
        }
    }
}

