/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.Viewpoint;
import com.interactivemesh.jfx.importer.fxml.ElementBase;
import com.interactivemesh.jfx.importer.fxml.ElementCache;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.FxUtils;
import com.interactivemesh.jfx.importer.fxml.FxmlImportOption;
import com.interactivemesh.jfx.importer.fxml.FxmlModelImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.PhongMaterial;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;

final class FxImporterImpl {
    private URL baseUrlU = null;
    private String basePathU = null;
    private boolean isUserBase = false;
    private BaseURL baseUrlUser = null;
    private double creaseAngle = Math.toRadians(45.0);
    private final EnumSet<FxmlImportOption> fxOpts = EnumSet.of(FxmlImportOption.NONE);
    private boolean isClosed = false;
    private final XMLInputFactory xmlif;
    private final FxFileParser fxFileParser;
    private final ArrayList<FxFileParser> includeParsers;
    private final ElementBase base;
    private final FxUtils fxUtils;
    private Node sceneNodeReturn = null;
    private final IdentityHashMap<Node, FilePath> fxmlFileReturnMap;
    private final FxmlModelImporter importer;

    FxImporterImpl(FxmlModelImporter fxmlModelImporter) {
        this.importer = fxmlModelImporter;
        this.fxUtils = new FxUtils();
        this.base = new ElementBase(this.fxUtils);
        try {
            this.xmlif = XMLInputFactory.newInstance();
            this.xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            this.xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            this.xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ImportException("FxImporterImpl : XMLInputFactory.newInstance() failed ! \n" + factoryConfigurationError.getMessage(), factoryConfigurationError);
        }
        this.fxFileParser = new FxFileParser(this, this.xmlif, this.base);
        this.includeParsers = new ArrayList(4);
        this.fxmlFileReturnMap = new IdentityHashMap(4);
    }

    FxFileParser getInlineParser() {
        if (this.includeParsers.isEmpty()) {
            return new FxFileParser(this, this.xmlif, this.base);
        }
        return this.includeParsers.remove(this.includeParsers.size() - 1);
    }

    void cacheInlineParser(FxFileParser fxFileParser) {
        this.includeParsers.add(fxFileParser);
    }

    double getCreaseAngle() {
        return Math.toDegrees(this.creaseAngle);
    }

    void setCreaseAngle(double d) {
        double d2 = Math.toRadians(d);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > Math.PI) {
            d2 = 3.1415927410125732;
        }
        this.creaseAngle = d2;
    }

    String getResourcePath() {
        return this.basePathU;
    }

    void setResourcePath(String string) {
        this.baseUrlU = null;
        this.basePathU = string;
        boolean bl = this.isUserBase = string != null && string.length() > 0;
        if (this.isUserBase) {
            URL uRL;
            string.trim();
            string = string.replace('\\', '/');
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if ((uRL = this.fxUtils.getUrlForAbsolutPath(string)) == null) {
                throw new ImportException("FxmlModelImporter setResourcePath : Can't create absolute URL from = " + string);
            }
            this.baseUrlUser = new BaseURL();
            this.baseUrlUser.protocol = uRL.getProtocol();
            this.baseUrlUser.host = uRL.getHost();
            this.baseUrlUser.port = uRL.getPort();
            this.baseUrlUser.path = uRL.getPath();
        } else {
            this.baseUrlUser = null;
        }
    }

    URL getResourceUrl() {
        return this.baseUrlU;
    }

    void setResourceUrl(URL uRL) {
        this.basePathU = null;
        this.baseUrlU = uRL;
        boolean bl = this.isUserBase = uRL != null;
        if (this.isUserBase) {
            this.baseUrlUser = new BaseURL();
            this.baseUrlUser.protocol = uRL.getProtocol();
            this.baseUrlUser.host = uRL.getHost();
            this.baseUrlUser.port = uRL.getPort();
            this.baseUrlUser.path = uRL.getPath();
            if (!this.baseUrlUser.path.endsWith("/")) {
                this.baseUrlUser.path = this.baseUrlUser.path + "/";
            }
        } else {
            this.baseUrlUser = null;
        }
    }

    EnumSet<FxmlImportOption> getOptions() {
        return this.fxOpts.clone();
    }

    void setOptions(FxmlImportOption ... fxmlImportOptionArray) {
        if (fxmlImportOptionArray == null || fxmlImportOptionArray.length < 1) {
            throw new IllegalArgumentException("options is null || options' length < 1");
        }
        if (fxmlImportOptionArray.length > 1) {
            for (FxmlImportOption fxmlImportOption : fxmlImportOptionArray) {
                if (fxmlImportOption != FxmlImportOption.NONE) continue;
                throw new IllegalArgumentException("options include FxmlImportOption.NONE");
            }
        }
        this.fxOpts.clear();
        for (FxmlImportOption fxmlImportOption : fxmlImportOptionArray) {
            this.fxOpts.add(fxmlImportOption);
        }
    }

    void setOptions(EnumSet<FxmlImportOption> enumSet) {
        if (enumSet == null || enumSet.isEmpty()) {
            throw new IllegalArgumentException("options is null || options is empty");
        }
        if (enumSet.size() > 1) {
            for (FxmlImportOption fxmlImportOption : enumSet) {
                if (fxmlImportOption != FxmlImportOption.NONE) continue;
                throw new IllegalArgumentException("options include FxmlImportOption.NONE");
            }
        }
        this.fxOpts.clear();
        this.fxOpts.addAll(enumSet);
    }

    void read(File file) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (file == null) {
            throw new ImportException("FxmlModelImporter read(File file) : file is null !");
        }
        if (!file.exists()) {
            throw new ImportException("FxmlModelImporter read(File file) : file doesn't exist !");
        }
        if (file.isDirectory()) {
            throw new ImportException("FxmlModelImporter read(File file) : file is directory !");
        }
        if (!file.canRead()) {
            throw new ImportException("FxmlModelImporter read(File file) : file can't be read !");
        }
        try {
            URL uRL = file.toURI().toURL();
            BaseURL baseURL = new BaseURL();
            baseURL.protocol = uRL.getProtocol();
            baseURL.host = uRL.getHost();
            baseURL.port = uRL.getPort();
            baseURL.path = uRL.getPath();
            int n = baseURL.path.lastIndexOf(47);
            if (n >= 0) {
                baseURL.path = baseURL.path.substring(0, n + 1);
            } else if (n < 0) {
                baseURL.path = Character.toString('/');
            }
            this.importFile(new FileInputStream(file), baseURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("FxmlModelImporter read(File file) : \n" + malformedURLException.getMessage(), malformedURLException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("FxmlModelImporter read(File file) : \n" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }

    void read(String string) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (string == null || string.length() < 1) {
            throw new ImportException("FxmlModelImporter read(String fileName) : fileName is null !");
        }
        try {
            Object object;
            string = string.replace('\\', '/');
            URL uRL = this.fxUtils.getUrlForAbsolutPath(string);
            if (uRL == null && ((String)(object = System.getProperty("user.dir"))).length() > 0) {
                if (((String)(object = ((String)object).replace('\\', '/'))).charAt(0) != '/') {
                    object = '/' + (String)object;
                }
                if (((String)object).charAt(((String)object).length() - 1) != '/') {
                    object = (String)object + '/';
                }
                uRL = new URL("file", null, this.fxUtils.normalizePath((String)object, string));
            }
            if (uRL == null) {
                throw new ImportException("FxmlModelImporter read(String fileName) : Can' create URL f0r = \n" + string);
            }
            object = new BaseURL();
            ((BaseURL)object).protocol = uRL.getProtocol();
            ((BaseURL)object).host = uRL.getHost();
            ((BaseURL)object).port = uRL.getPort();
            ((BaseURL)object).path = uRL.getPath();
            int n = ((BaseURL)object).path.lastIndexOf(47);
            if (n >= 0) {
                ((BaseURL)object).path = ((BaseURL)object).path.substring(0, n + 1);
            } else if (n < 0) {
                ((BaseURL)object).path = Character.toString('/');
            }
            URLConnection uRLConnection = uRL.openConnection();
            this.importFile(uRLConnection.getInputStream(), (BaseURL)object);
        }
        catch (SecurityException securityException) {
            throw new ImportException("FxmlModelImporter read(String fileName) : \n" + securityException.getMessage(), securityException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("FxmlModelImporter read(String fileName) : \n" + malformedURLException.getMessage(), malformedURLException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("FxmlModelImporter read(String fileName) : \n" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ImportException("FxmlModelImporter read(String fileName) : \n" + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ImportException("FxmlModelImporter read(String fileName) : \n" + iOException.getMessage(), iOException);
        }
    }

    void read(URL uRL) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (uRL == null) {
            throw new ImportException("FxmlModelImporter read(URL url) : url is null !");
        }
        BaseURL baseURL = new BaseURL();
        baseURL.protocol = uRL.getProtocol();
        baseURL.host = uRL.getHost();
        baseURL.port = uRL.getPort();
        baseURL.path = uRL.getPath();
        int n = baseURL.path.lastIndexOf(47);
        baseURL.path = n >= 0 ? baseURL.path.substring(0, n + 1) : Character.toString('/');
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.importFile(uRLConnection.getInputStream(), baseURL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("FxmlModelImporter read(URL url) : \n" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ImportException("FxmlModelImporter read(URL url) : \n" + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ImportException("FxmlModelImporter read(URL url) : \n" + iOException.getMessage(), iOException);
        }
    }

    void onFileImported() {
        this.importer.onFileImported();
    }

    Node getImportedNode() {
        return this.sceneNodeReturn;
    }

    Map<String, Node> getNamedNodes() {
        return this.base.getNamedNodes();
    }

    Map<String, PhongMaterial> getNamedMaterials() {
        return this.base.getNamedMaterials();
    }

    IdentityHashMap<Image, FilePath> getImagePaths() {
        return this.base.getImagePaths();
    }

    Map<Node, FilePath> getIncludedFxmlFilePaths() {
        if (this.fxmlFileReturnMap.size() > 0) {
            IdentityHashMap<Node, FilePath> identityHashMap = new IdentityHashMap<Node, FilePath>(this.fxmlFileReturnMap.size());
            identityHashMap.putAll(this.fxmlFileReturnMap);
            return identityHashMap;
        }
        return null;
    }

    Viewpoint[] getViewpoints() {
        return this.base.getViewpoints();
    }

    Node[] getCamLights() {
        return this.base.getCamLights();
    }

    void clear() {
        this.base.clear();
        this.fxFileParser.clear();
        if (!this.includeParsers.isEmpty()) {
            for (FxFileParser fxFileParser : this.includeParsers) {
                fxFileParser.clear();
            }
        }
        this.fxmlFileReturnMap.clear();
        this.sceneNodeReturn = null;
    }

    void close() {
        this.isClosed = true;
        this.clear();
        this.base.close();
        this.fxFileParser.close();
        if (!this.includeParsers.isEmpty()) {
            for (FxFileParser fxFileParser : this.includeParsers) {
                fxFileParser.close();
            }
            this.includeParsers.clear();
        }
    }

    private void clearForNextImport() {
        this.clear();
    }

    private boolean checkIsClosed() {
        if (this.isClosed) {
            throw new ImportException("X3dModelImporter is closed! Can't be used anymore!");
        }
        return this.isClosed;
    }

    private void importFile(InputStream inputStream, BaseURL baseURL) {
        this.clearForNextImport();
        if (this.fxOpts != null && !this.fxOpts.isEmpty()) {
            this.base.isGenerateNormals = this.fxOpts.contains((Object)FxmlImportOption.GENERATE_NORMALS);
            this.base.isReverse = this.fxOpts.contains((Object)FxmlImportOption.REVERSE_GEOMETRY);
            this.base.isWritableImage = this.fxOpts.contains((Object)FxmlImportOption.MAP_WRITABLEIMAGE);
            this.base.isIgnoreCameras = this.fxOpts.contains((Object)FxmlImportOption.IGNORE_CAMERAS);
            this.base.isIgnoreLights = this.fxOpts.contains((Object)FxmlImportOption.IGNORE_LIGHTS);
        }
        this.base.creaseAngle = this.creaseAngle;
        this.base.baseUrlMain = this.isUserBase ? this.baseUrlUser : baseURL;
        ElementCache elementCache = new ElementCache(this.base.baseUrlMain);
        Node node = this.fxFileParser.parse(inputStream, elementCache, null);
        if (node != null && node instanceof Node) {
            this.sceneNodeReturn = node;
        }
        this.onFileImported();
    }

    Node parseIncludedFxmlFile(URL uRL, String string, Group group) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            BaseURL baseURL = new BaseURL();
            baseURL.protocol = uRL.getProtocol();
            baseURL.host = uRL.getHost();
            baseURL.port = uRL.getPort();
            baseURL.path = uRL.getPath();
            int n = baseURL.path.lastIndexOf(47);
            baseURL.path = n >= 0 ? baseURL.path.substring(0, n + 1) : Character.toString('/');
            ElementCache elementCache = new ElementCache(baseURL);
            FxFileParser fxFileParser = this.getInlineParser();
            Node node = fxFileParser.parse(inputStream, elementCache, group);
            this.cacheInlineParser(fxFileParser);
            if (node != null && node instanceof Node) {
                this.fxmlFileReturnMap.put(node, new FilePath(string, uRL));
                return node;
            }
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("FxmlModelImporter URLConnection of included FXML file failed : \nurl = " + uRL.toExternalForm() + " \n" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ImportException("FxmlModelImporter URLConnection of included FXML file failed : \nurl = " + uRL.toExternalForm() + " \n" + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ImportException("FxmlModelImporter URLConnection of included FXML file failed : \nurl = " + uRL.toExternalForm() + " \n" + iOException.getMessage(), iOException);
        }
    }

    static final class BaseURL {
        String protocol = null;
        String host = null;
        int port = -1;
        String path = null;

        BaseURL() {
        }

        public String toString() {
            return "protocol = " + this.protocol + ", host = " + this.host + ", port = " + this.port + ", path = " + this.path;
        }
    }
}

