/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import javafx.geometry.Point3D;

final class Point3DParser
extends AbstractElementParserChar {
    private AbstractElementParser parentParser = null;
    private String fxIdStrg = null;
    private String ptX = null;
    private String ptY = null;
    private String ptZ = null;

    Point3DParser(FxFileParser fxFileParser) {
        super(fxFileParser);
        this.charArray = new char[200];
    }

    Point3D getPoint3D() {
        if (this.ptX == null) {
            this.ptX = "0";
        }
        if (this.ptY == null) {
            this.ptY = "0";
        }
        if (this.ptZ == null) {
            this.ptZ = "0";
        }
        Point3D point3D = new Point3D(Double.parseDouble(this.ptX), Double.parseDouble(this.ptY), Double.parseDouble(this.ptZ));
        if (this.fxIdStrg != null && this.fxIdStrg.length() > 0) {
            this.fxfp.currCache.putPoint3D(this.fxIdStrg, point3D);
        }
        return point3D;
    }

    void setup(AbstractElementParser abstractElementParser) {
        this.parentParser = abstractElementParser;
        this.setupChar();
        this.ptX = null;
        this.ptY = null;
        this.ptZ = null;
        this.fxIdStrg = null;
        int n = this.fxfp.xR.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = this.fxfp.xR.getAttributeValue(i);
            if (string != null && string.length() > 0) {
                String string2 = this.fxfp.xR.getAttributeLocalName(i);
                if (string2.equals("x")) {
                    this.ptX = string;
                    continue;
                }
                if (string2.equals("y")) {
                    this.ptY = string;
                    continue;
                }
                if (string2.equals("z")) {
                    this.ptZ = string;
                    continue;
                }
                if (!string2.equals("id") || !this.fxfp.xR.getAttributePrefix(i).equals("fx")) continue;
                this.fxIdStrg = string;
                continue;
            }
            throw new ImportException("Point3DParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
        }
    }

    @Override
    void close() {
        this.charArray = null;
    }

    @Override
    void startElement(String string) {
        this.isCharacter = false;
        this.isPrimitive = false;
        if (string.equals("x")) {
            this.isCharacter = true;
        } else if (string.equals("y")) {
            this.isCharacter = true;
        } else if (string.equals("z")) {
            this.isCharacter = true;
        } else if (this.processPrimitiveStartElement(string)) {
            this.isPrimitive = true;
        } else {
            this.fxfp.setNullParser(this, string);
        }
        if (this.isCharacter) {
            this.arrPos = 0;
        }
    }

    @Override
    void endElement(String string) {
        if (!string.equals(this.primTagName)) {
            if (this.isCharacter || this.isPrimitive) {
                String string2 = this.getCharOrPrimString();
                if (string2 != null) {
                    if (string.equals("x")) {
                        this.ptX = string2;
                    } else if (string.equals("y")) {
                        this.ptY = string2;
                    } else if (string.equals("z")) {
                        this.ptZ = string2;
                    }
                }
            } else if (string.equals("Point3D")) {
                this.fxfp.setParser(this.parentParser);
                this.parentParser = null;
            }
        }
    }
}

