/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.modelbrowser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;

abstract class FxmlExporter {
    boolean isAmbLight = false;
    boolean isGroup = false;
    boolean isParCam = false;
    boolean isPerCam = false;
    boolean isPointLight = false;
    boolean isImage = false;
    boolean isColor = false;
    boolean isPhongMat = false;
    boolean isMeshView = false;
    boolean isTriaMesh = false;
    boolean isAffine = false;
    boolean isRotate = false;
    boolean isScale = false;
    boolean isTranslate = false;
    private int indent = 2;
    int sceneTabs = 0;
    String[] tabs = null;
    private HashMap<Integer, String> tabMap = new HashMap();
    BufferedWriter fxWriter = null;

    FxmlExporter(File file) {
        this.tabs = new String[8];
        for (int i = 0; i < 8; ++i) {
            this.tabs[i] = this.getTabs(this.sceneTabs + i);
        }
        try {
            this.fxWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("file not found");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void close() {
        try {
            this.fxWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    String getTabs(int n) {
        if (n < 1) {
            return "";
        }
        String string = this.tabMap.get(n);
        if (string == null) {
            char c = ' ';
            int n2 = n * this.indent;
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
            this.tabMap.put(n, string);
        }
        return string;
    }

    void writeXML() {
        try {
            this.fxWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void writeComments() {
        try {
            this.fxWriter.write("\n");
            this.fxWriter.write("<!-- Copyright/License : unknown -->\n");
            this.fxWriter.write("<!-- FXML specification : JRE/JavaFX 8.0 early access build b128 -->\n");
            this.fxWriter.write("<!-- Generator : ModelImporterJFX 0.4.1 of InteractiveMesh, www.interactivemesh.org/models/jfx3dbrowser.html -->\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void writeModelImports() {
        try {
            this.fxWriter.write("\n");
            if (this.isRotate) {
                this.fxWriter.write("<?import javafx.geometry.Point3D?>\n");
            }
            if (this.isAmbLight) {
                this.fxWriter.write("<?import javafx.scene.AmbientLight?>\n");
            }
            if (this.isGroup) {
                this.fxWriter.write("<?import javafx.scene.Group?>\n");
            }
            if (this.isParCam) {
                this.fxWriter.write("<?import javafx.scene.ParallelCamera?>\n");
            }
            if (this.isPerCam) {
                this.fxWriter.write("<?import javafx.scene.PerspectiveCamera?>\n");
            }
            if (this.isPointLight) {
                this.fxWriter.write("<?import javafx.scene.PointLight?>\n");
            }
            if (this.isImage) {
                this.fxWriter.write("<?import javafx.scene.image.Image?>\n");
            }
            if (this.isColor) {
                this.fxWriter.write("<?import javafx.scene.paint.Color?>\n");
            }
            if (this.isPhongMat) {
                this.fxWriter.write("<?import javafx.scene.paint.PhongMaterial?>\n");
            }
            if (this.isMeshView) {
                this.fxWriter.write("<?import javafx.scene.shape.MeshView?>\n");
            }
            if (this.isTriaMesh) {
                this.fxWriter.write("<?import javafx.scene.shape.TriangleMesh?>\n");
            }
            if (this.isAffine) {
                this.fxWriter.write("<?import javafx.scene.transform.Affine?>\n");
            }
            if (this.isRotate) {
                this.fxWriter.write("<?import javafx.scene.transform.Rotate?>\n");
            }
            if (this.isScale) {
                this.fxWriter.write("<?import javafx.scene.transform.Scale?>\n");
            }
            if (this.isTranslate) {
                this.fxWriter.write("<?import javafx.scene.transform.Translate?>\n");
            }
            this.fxWriter.write("\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void writeMeshImports() {
        try {
            this.fxWriter.write("\n");
            this.fxWriter.write("<?import javafx.scene.shape.TriangleMesh?>\n");
            this.fxWriter.write("\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

