/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.modelbrowser;

import com.interactivemesh.jfx.modelbrowser.FileType;
import com.interactivemesh.jfx.modelbrowser.ImporterType;
import com.interactivemesh.jfx.modelbrowser.ModelBrowserFrame;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public class ModelBrowserFileChooser {
    private FileType selFileType = FileType.ALL3D;
    private ImporterType selImporterTyp = ImporterType.ALL3D;
    private BorderPane fileSystemPane = null;
    private SplitPane fileSystemSplitPane = null;
    private BorderPane tableViewPane = null;
    private BorderPane treeViewPane = null;
    private TreeView<PathItem> treeView = null;
    private TableView<PathItem> tableView = null;
    private TableColumn<PathItem, PathItem> fileSizeCol = null;
    private final PathItemNameComparator pathItemNameComparator = new PathItemNameComparator();
    private final ObservableList<PathItem> rootPathItems;
    private final ObservableList<TreeItem<PathItem>> treeRootChildren;
    private Button splitButton = null;
    private Button topDirButton = null;
    private Button upDirButton = null;
    private ComboBox<PathItem> pathComboBox = null;
    private boolean isRootDirs = false;
    private PathItem currBrowserTableParent = null;
    private ComboBox<TableTreeFilter> filterComboBox = null;
    private boolean isSingleRootDropped = false;
    private double colNameWidth = 200.0;
    private double colSizeWidth = 65.0;
    private double colDateWidth = 79.0;
    private static final NumberFormat numFormatSizeKB = NumberFormat.getIntegerInstance();
    private final ModelBrowserFrame browserFrame;

    ModelBrowserFileChooser(ModelBrowserFrame modelBrowserFrame) {
        Object object;
        this.browserFrame = modelBrowserFrame;
        Iterable<Path> iterable = modelBrowserFrame.defaultFileSystem.getRootDirectories();
        int n = 0;
        Path path = null;
        for (Path path2 : iterable) {
            try {
                if (path2 == null || Files.isHidden(path2) || !Files.isDirectory(path2, LinkOption.NOFOLLOW_LINKS)) continue;
                if (++n == 1) {
                    path = path2;
                    continue;
                }
                if (n <= 1) continue;
                break;
            }
            catch (IOException iOException) {
            }
        }
        this.rootPathItems = FXCollections.observableArrayList();
        if (n == 1) {
            this.isSingleRootDropped = true;
            object = new ChildrenVisitor();
            try {
                Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ArrayList arrayList = ((ChildrenVisitor)object).getChildren();
            if (arrayList != null && arrayList.size() > 0) {
                for (Object object2 : arrayList) {
                    try {
                        if (object2 == null || Files.isHidden(object2) || !Files.isDirectory(object2, new LinkOption[]{LinkOption.NOFOLLOW_LINKS})) continue;
                        this.rootPathItems.add((Object)new PathItem((Path)object2, null));
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            for (Path path3 : iterable) {
                try {
                    if (path3 == null || Files.isHidden(path3)) continue;
                    this.rootPathItems.add((Object)new PathItem(path3, null));
                }
                catch (IOException iOException) {}
            }
        }
        FXCollections.sort(this.rootPathItems, (Comparator)this.pathItemNameComparator);
        object = new PathTreeItem(null);
        object.setExpanded(true);
        this.treeRootChildren = ((PathTreeItem)((Object)object)).getChildren();
        for (Object object3 : this.rootPathItems) {
            Object object2;
            object2 = new PathTreeItem((PathItem)object3);
            ((PathTreeItem)((Object)object2)).hasDirChildren = ((PathItem)object3).hasDirChildren();
            this.treeRootChildren.add(object2);
        }
        this.createTableViewPane();
        this.createTreeViewPane((PathTreeItem)((Object)object));
        this.fileSystemSplitPane = new SplitPane();
        this.fileSystemSplitPane.getItems().addAll((Object[])new Node[]{this.treeViewPane, this.tableViewPane});
        this.fileSystemSplitPane.setDividerPosition(0, 0.3);
        SplitPane.setResizableWithParent((Node)this.treeViewPane, (Boolean)false);
        this.fileSystemPane = new BorderPane();
        this.fileSystemPane.setPrefSize(300.0, 800.0);
        this.fileSystemPane.setMinSize(0.0, 0.0);
        this.fileSystemPane.setCenter((Node)this.fileSystemSplitPane);
        this.createFilterSelectionPane();
    }

    void initScene() {
        this.fileSizeCol.setPrefWidth(this.colSizeWidth);
        this.setButtonHeight((Control)this.pathComboBox);
        this.setButtonHeight((Control)this.topDirButton);
        this.setButtonHeight((Control)this.upDirButton);
        this.setButtonHeight((Control)this.filterComboBox);
        this.setButtonHeight((Control)this.splitButton);
    }

    private void setButtonHeight(Control control) {
        control.setMinHeight(ModelBrowserFrame.buttonHeight);
        control.setPrefHeight(ModelBrowserFrame.buttonHeight);
        control.setMaxHeight(ModelBrowserFrame.buttonHeight);
    }

    Pane getFileSystemPane() {
        return this.fileSystemPane;
    }

    void expandRoots(boolean bl) {
        for (TreeItem treeItem : this.treeRootChildren) {
            if (treeItem.isLeaf()) continue;
            this.expandGroup((TreeItem<PathItem>)treeItem, bl);
            treeItem.setExpanded(bl);
        }
    }

    void expandSelectedGroup(boolean bl) {
        TreeItem treeItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
        if (treeItem != null && !treeItem.isLeaf()) {
            this.expandGroup((TreeItem<PathItem>)treeItem, bl);
            treeItem.setExpanded(bl);
        }
    }

    private void expandGroup(TreeItem<PathItem> treeItem, boolean bl) {
        ObservableList observableList = treeItem.getChildren();
        for (TreeItem treeItem2 : observableList) {
            if (treeItem2.isLeaf()) continue;
            this.expandGroup((TreeItem<PathItem>)treeItem2, bl);
            treeItem2.setExpanded(bl);
        }
    }

    void refreshTreeAndTable(boolean bl) {
        if (!bl) {
            for (Object object : this.treeRootChildren) {
                this.collapsePathTreeItem((PathTreeItem)((Object)object));
            }
            for (Object object : this.treeRootChildren) {
                ((PathTreeItem)((Object)object)).resetFirstTime();
            }
        }
        for (Object object : this.rootPathItems) {
            ((PathItem)object).resetFirstTime();
        }
        if (!this.isRootDirs) {
            Iterator iterator = this.currBrowserTableParent.getChildren();
            this.setBrowserTable((ObservableList<PathItem>)iterator);
        }
    }

    private void collapsePathTreeItem(PathTreeItem pathTreeItem) {
        if (!pathTreeItem.isChildrenFirstTime) {
            ObservableList<TreeItem<PathItem>> observableList = pathTreeItem.getChildren();
            for (TreeItem treeItem : observableList) {
                this.collapsePathTreeItem((PathTreeItem)treeItem);
            }
        }
        pathTreeItem.setExpanded(false);
    }

    private void createFilterSelectionPane() {
        ObservableList observableList = FXCollections.observableArrayList();
        observableList.add((Object)new TableTreeFilter(FileType.ALL, "All files", ImporterType.ALL));
        observableList.add((Object)new TableTreeFilterSeparatorItem());
        observableList.add((Object)new TableTreeFilter(FileType.ALL3D, "All 3D model importers, *.3ds, *.dae, *.zae, *.fxml, *.obj, *.stl, *.x3d, *.x3dz", ImporterType.ALL3D));
        observableList.add((Object)new TableTreeFilterSeparatorItem());
        observableList.add((Object)new TableTreeFilter(FileType.TDS, "3dsModelImporterJFX, *.3ds", ImporterType.TDS));
        observableList.add((Object)new TableTreeFilter(FileType.COL, "ColModelImporterJFX, *.dae, *.zae", ImporterType.COL));
        observableList.add((Object)new TableTreeFilter(FileType.FXML, "FxmlModelImporterJFX, *.fxml", ImporterType.FXML_IMPORTER));
        observableList.add((Object)new TableTreeFilter(FileType.OBJ, "ObjModelImporterJFX , *.obj", ImporterType.OBJ));
        observableList.add((Object)new TableTreeFilter(FileType.STL, "StlMeshImporterJFX, *.stl", ImporterType.Stl));
        observableList.add((Object)new TableTreeFilter(FileType.X3D, "X3dModelImporterJFX, *.x3d, *.x3dz", ImporterType.X3D));
        observableList.add((Object)new TableTreeFilterSeparatorItem());
        observableList.add((Object)new TableTreeFilter(FileType.FXML, "FXMLLoader, *.fxml", ImporterType.FXML_LOADER));
        this.filterComboBox = new ComboBox();
        this.filterComboBox.setTooltip(new Tooltip("Selection filter"));
        this.filterComboBox.setMaxWidth(Double.MAX_VALUE);
        this.filterComboBox.setVisibleRowCount(12);
        this.filterComboBox.setItems(observableList);
        this.filterComboBox.getSelectionModel().select(2);
        this.filterComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TableTreeFilter>(){

            public void changed(ObservableValue<? extends TableTreeFilter> observableValue, TableTreeFilter tableTreeFilter, TableTreeFilter tableTreeFilter2) {
                if (tableTreeFilter2 != null && tableTreeFilter2 != tableTreeFilter) {
                    ModelBrowserFileChooser.this.selImporterTyp = tableTreeFilter2.importerType;
                    FileType fileType = tableTreeFilter2.filter;
                    switch (fileType) {
                        case ALL: {
                            ModelBrowserFileChooser.this.selFileType = FileType.ALL;
                            break;
                        }
                        case ALL3D: {
                            ModelBrowserFileChooser.this.selFileType = FileType.ALL3D;
                            break;
                        }
                        case ARCHIVE: {
                            break;
                        }
                        case TDS: {
                            ModelBrowserFileChooser.this.selFileType = FileType.TDS;
                            break;
                        }
                        case COL: {
                            ModelBrowserFileChooser.this.selFileType = FileType.COL;
                            break;
                        }
                        case OBJ: {
                            ModelBrowserFileChooser.this.selFileType = FileType.OBJ;
                            break;
                        }
                        case STL: {
                            ModelBrowserFileChooser.this.selFileType = FileType.STL;
                            break;
                        }
                        case X3D: {
                            ModelBrowserFileChooser.this.selFileType = FileType.X3D;
                            break;
                        }
                        case FXML: {
                            ModelBrowserFileChooser.this.selFileType = FileType.FXML;
                        }
                    }
                    ModelBrowserFileChooser.this.refreshTreeAndTable(true);
                }
            }
        });
        this.filterComboBox.setCellFactory((Callback)new Callback<ListView<TableTreeFilter>, ListCell<TableTreeFilter>>(){

            public ListCell<TableTreeFilter> call(ListView<TableTreeFilter> listView) {
                return new ListCell<TableTreeFilter>(){

                    protected void updateItem(TableTreeFilter tableTreeFilter, boolean bl) {
                        super.updateItem((Object)tableTreeFilter, bl);
                        if (tableTreeFilter == null || bl) {
                            this.setText("");
                            this.setGraphic(null);
                        } else {
                            this.setText(tableTreeFilter.getText());
                            this.setGraphic(tableTreeFilter.getGraphic());
                            this.setDisable(tableTreeFilter.isDisable());
                            this.setPrefHeight(tableTreeFilter.getPrefHeight());
                        }
                    }
                };
            }
        });
        this.filterComboBox.setButtonCell((ListCell)new ListCell<TableTreeFilter>(){

            protected void updateItem(TableTreeFilter tableTreeFilter, boolean bl) {
                super.updateItem((Object)tableTreeFilter, bl);
                if (tableTreeFilter == null || bl) {
                    this.setText("");
                    this.setGraphic(null);
                } else {
                    this.setText(tableTreeFilter.getText());
                    this.setGraphic(tableTreeFilter.getButtonGraphic());
                    ModelBrowserFileChooser.this.setButtonHeight((Control)ModelBrowserFileChooser.this.filterComboBox);
                }
            }
        });
        BorderPane borderPane = new BorderPane();
        borderPane.setMinSize(0.0, 0.0);
        borderPane.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        borderPane.setCenter(this.filterComboBox);
        this.fileSystemPane.setBottom((Node)borderPane);
    }

    private void createTableViewPane() {
        this.topDirButton = new Button("Root");
        this.topDirButton.getStyleClass().add((Object)"button-mb");
        this.topDirButton.setTooltip(new Tooltip("Root directories"));
        this.topDirButton.setMinSize(0.0, 0.0);
        this.topDirButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                ModelBrowserFileChooser.this.upDirButton.setDisable(true);
                ModelBrowserFileChooser.this.topDirButton.setDisable(true);
                ModelBrowserFileChooser.this.setBrowserTable((ObservableList<PathItem>)ModelBrowserFileChooser.this.rootPathItems);
                ModelBrowserFileChooser.this.isRootDirs = true;
                ModelBrowserFileChooser.this.pathComboBox.setItems(null);
                ModelBrowserFileChooser.this.pathComboBox.setDisable(true);
            }
        });
        this.upDirButton = new Button("Up");
        this.upDirButton.getStyleClass().add((Object)"button-mb");
        this.upDirButton.setTooltip(new Tooltip("Parent directory"));
        this.upDirButton.setMinSize(0.0, 0.0);
        this.upDirButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (ModelBrowserFileChooser.this.currBrowserTableParent != null && ModelBrowserFileChooser.this.currBrowserTableParent.getParent() != null) {
                    PathItem pathItem = ModelBrowserFileChooser.this.currBrowserTableParent.getParent();
                    ObservableList observableList = pathItem.getChildren();
                    ModelBrowserFileChooser.this.setBrowserTable((ObservableList<PathItem>)observableList);
                    int n = ModelBrowserFileChooser.this.pathComboBox.getItems().size() - 1;
                    ModelBrowserFileChooser.this.pathComboBox.getItems().remove(n);
                    ModelBrowserFileChooser.this.currBrowserTableParent = pathItem;
                } else if (!ModelBrowserFileChooser.this.isRootDirs) {
                    ModelBrowserFileChooser.this.isRootDirs = true;
                    ModelBrowserFileChooser.this.setBrowserTable((ObservableList<PathItem>)ModelBrowserFileChooser.this.rootPathItems);
                    ModelBrowserFileChooser.this.upDirButton.setDisable(true);
                    ModelBrowserFileChooser.this.topDirButton.setDisable(true);
                    ModelBrowserFileChooser.this.pathComboBox.setItems(null);
                    ModelBrowserFileChooser.this.pathComboBox.setDisable(true);
                }
            }
        });
        this.upDirButton.prefWidthProperty().bind((ObservableValue)this.topDirButton.widthProperty());
        this.topDirButton.setDisable(true);
        this.upDirButton.setDisable(true);
        this.pathComboBox = new ComboBox();
        this.pathComboBox.setTooltip(new Tooltip("Path"));
        this.pathComboBox.setMinSize(0.0, 0.0);
        this.pathComboBox.setMaxWidth(Double.MAX_VALUE);
        this.pathComboBox.setItems(null);
        this.pathComboBox.setDisable(true);
        this.pathComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PathItem>(){

            public void changed(ObservableValue<? extends PathItem> observableValue, PathItem pathItem, PathItem pathItem2) {
                ObservableList observableList = ModelBrowserFileChooser.this.pathComboBox.getItems();
                if (observableList != null && observableList.size() > 0) {
                    int n = observableList.size() - 1;
                    int n2 = ModelBrowserFileChooser.this.pathComboBox.getSelectionModel().getSelectedIndex();
                    if (n2 >= 0 && n2 != n) {
                        PathItem pathItem3 = (PathItem)observableList.get(n2);
                        ObservableList observableList2 = pathItem3.getChildren();
                        ModelBrowserFileChooser.this.setBrowserTable((ObservableList<PathItem>)observableList2);
                        ObservableList observableList3 = FXCollections.observableArrayList();
                        for (int i = 0; i <= n2; ++i) {
                            PathItem pathItem4 = (PathItem)observableList.get(i);
                            pathItem4.comboIndex = i;
                            observableList3.add((Object)pathItem4);
                        }
                        ModelBrowserFileChooser.this.pathComboBox.setItems(observableList3);
                        ModelBrowserFileChooser.this.pathComboBox.getSelectionModel().select(n2);
                        ModelBrowserFileChooser.this.currBrowserTableParent = pathItem3;
                    }
                }
            }
        });
        this.pathComboBox.setCellFactory((Callback)new Callback<ListView<PathItem>, ListCell<PathItem>>(){

            public ListCell<PathItem> call(ListView<PathItem> listView) {
                return new ListCell<PathItem>(){

                    protected void updateItem(PathItem pathItem, boolean bl) {
                        super.updateItem((Object)pathItem, bl);
                        if (pathItem == null || bl) {
                            this.setText("");
                            this.setGraphic(null);
                        } else {
                            this.setText(pathItem.getFileName());
                            this.setGraphicTextGap(0.0);
                            if (this.getIndex() > 0) {
                                Rectangle rectangle = new Rectangle(0.0, 0.0, (double)(7 * this.getIndex()), 9.0);
                                rectangle.setFill((Paint)Color.TRANSPARENT);
                                this.setGraphic((Node)rectangle);
                            }
                            ModelBrowserFileChooser.this.browserFrame;
                            this.setPrefHeight(ModelBrowserFrame.cellHeight);
                        }
                    }
                };
            }
        });
        this.pathComboBox.setButtonCell((ListCell)new ListCell<PathItem>(){

            protected void updateItem(PathItem pathItem, boolean bl) {
                super.updateItem((Object)pathItem, bl);
                if (pathItem == null || bl) {
                    this.setText("");
                    this.setGraphic(null);
                } else {
                    this.setText(pathItem.getFileName());
                    this.setGraphic(ModelBrowserFileChooser.this.createDirectoryGraphic());
                    ModelBrowserFileChooser.this.setButtonHeight((Control)ModelBrowserFileChooser.this.pathComboBox);
                }
            }
        });
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setSpacing(5.0);
        hBox.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        hBox.getChildren().addAll((Object[])new Node[]{this.topDirButton, this.upDirButton});
        BorderPane borderPane = new BorderPane();
        borderPane.setLeft((Node)hBox);
        borderPane.setCenter(this.pathComboBox);
        borderPane.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        this.tableView = new TableView();
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                Object object;
                if (mouseEvent.getSource() != null && (object = ((TableCell)mouseEvent.getSource()).getItem()) != null && object instanceof PathItem) {
                    ImporterType importerType = ImporterType.FXML_IMPORTER;
                    if (ModelBrowserFileChooser.this.selImporterTyp == ImporterType.FXML_LOADER) {
                        importerType = ImporterType.FXML_LOADER;
                    }
                    ModelBrowserFileChooser.this.pathItemSelected((PathItem)object, importerType);
                }
            }
        };
        EventHandler<KeyEvent> eventHandler2 = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getSource() != null && keyEvent.getCode() == KeyCode.ENTER) {
                    int n = ModelBrowserFileChooser.this.tableView.getFocusModel().getFocusedCell().getRow();
                    PathItem pathItem = (PathItem)ModelBrowserFileChooser.this.tableView.getItems().get(n);
                    if (pathItem != null) {
                        ImporterType importerType = ImporterType.FXML_IMPORTER;
                        if (ModelBrowserFileChooser.this.selImporterTyp == ImporterType.FXML_LOADER) {
                            importerType = ImporterType.FXML_LOADER;
                        }
                        ModelBrowserFileChooser.this.pathItemSelected(pathItem, importerType);
                    }
                }
            }
        };
        TableColumn tableColumn = new TableColumn("Directory / File");
        tableColumn.setSortable(true);
        tableColumn.setComparator((Comparator)new PathItemNameComparator());
        tableColumn.setPrefWidth(this.colNameWidth);
        tableColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<PathItem, PathItem>, ObservableValue<PathItem>>(){

            public ObservableValue<PathItem> call(TableColumn.CellDataFeatures<PathItem, PathItem> cellDataFeatures) {
                return new ReadOnlyObjectWrapper(cellDataFeatures.getValue());
            }
        });
        tableColumn.setCellFactory((Callback)new Callback<TableColumn<PathItem, PathItem>, TableCell<PathItem, PathItem>>((EventHandler)eventHandler){
            final /* synthetic */ EventHandler val$onMouseClickedHandler;
            {
                this.val$onMouseClickedHandler = eventHandler;
            }

            public TableCell<PathItem, PathItem> call(TableColumn<PathItem, PathItem> tableColumn) {
                return new TableCell<PathItem, PathItem>(){

                    protected void updateItem(PathItem pathItem, boolean bl) {
                        super.updateItem((Object)pathItem, bl);
                        if (pathItem == null || bl) {
                            this.setText("");
                            this.setGraphic(null);
                        } else {
                            this.setText(pathItem.getFileName());
                            this.setOnMouseClicked(val$onMouseClickedHandler);
                            if (pathItem.isLeaf) {
                                FileType fileType = pathItem.getLeafFileType();
                                Node node = ModelBrowserFileChooser.this.createGraphicFor(fileType);
                                if (node == null) {
                                    node = new Rectangle(0.0, 0.0, 12.0, 9.0);
                                    ((Rectangle)node).setFill((Paint)Color.TRANSPARENT);
                                }
                                this.setGraphic(node);
                            } else {
                                this.setGraphic(ModelBrowserFileChooser.this.createDirectoryGraphic());
                            }
                        }
                    }
                };
            }
        });
        this.fileSizeCol = new TableColumn("KB");
        this.fileSizeCol.setSortable(true);
        this.fileSizeCol.setComparator((Comparator)new PathItemSizeComparator());
        this.fileSizeCol.setPrefWidth(this.colSizeWidth);
        this.fileSizeCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<PathItem, PathItem>, ObservableValue<PathItem>>(){

            public ObservableValue<PathItem> call(TableColumn.CellDataFeatures<PathItem, PathItem> cellDataFeatures) {
                return new ReadOnlyObjectWrapper(cellDataFeatures.getValue());
            }
        });
        this.fileSizeCol.setCellFactory((Callback)new Callback<TableColumn<PathItem, PathItem>, TableCell<PathItem, PathItem>>((EventHandler)eventHandler){
            final /* synthetic */ EventHandler val$onMouseClickedHandler;
            {
                this.val$onMouseClickedHandler = eventHandler;
            }

            public TableCell<PathItem, PathItem> call(TableColumn<PathItem, PathItem> tableColumn) {
                return new TableCell<PathItem, PathItem>(){
                    {
                        this.setAlignment(Pos.CENTER_RIGHT);
                        this.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
                    }

                    protected void updateItem(PathItem pathItem, boolean bl) {
                        super.updateItem((Object)pathItem, bl);
                        if (pathItem == null || bl) {
                            this.setText("");
                        } else {
                            this.setText(pathItem.getFileSize());
                            this.setOnMouseClicked(val$onMouseClickedHandler);
                        }
                    }
                };
            }
        });
        TableColumn tableColumn2 = new TableColumn("Date");
        tableColumn2.setSortable(true);
        tableColumn2.setComparator((Comparator)new PathItemTimeComparator());
        tableColumn2.setPrefWidth(this.colDateWidth);
        tableColumn2.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<PathItem, PathItem>, ObservableValue<PathItem>>(){

            public ObservableValue<PathItem> call(TableColumn.CellDataFeatures<PathItem, PathItem> cellDataFeatures) {
                return new ReadOnlyObjectWrapper(cellDataFeatures.getValue());
            }
        });
        tableColumn2.setCellFactory((Callback)new Callback<TableColumn<PathItem, PathItem>, TableCell<PathItem, PathItem>>((EventHandler)eventHandler){
            final /* synthetic */ EventHandler val$onMouseClickedHandler;
            {
                this.val$onMouseClickedHandler = eventHandler;
            }

            public TableCell<PathItem, PathItem> call(TableColumn<PathItem, PathItem> tableColumn) {
                return new TableCell<PathItem, PathItem>(){
                    {
                        this.setAlignment(Pos.CENTER_RIGHT);
                        this.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
                    }

                    protected void updateItem(PathItem pathItem, boolean bl) {
                        super.updateItem((Object)pathItem, bl);
                        if (pathItem == null || bl) {
                            this.setText("");
                        } else {
                            this.setText(pathItem.getFileDate());
                            this.setOnMouseClicked(val$onMouseClickedHandler);
                        }
                    }
                };
            }
        });
        this.tableView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, this.fileSizeCol, tableColumn2});
        this.tableView.setOnKeyReleased((EventHandler)eventHandler2);
        this.setBrowserTable(this.rootPathItems);
        this.isRootDirs = true;
        this.tableViewPane = new BorderPane();
        this.tableViewPane.setTop((Node)borderPane);
        this.tableViewPane.setCenter(this.tableView);
        this.tableViewPane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
    }

    private void setBrowserTable(ObservableList<PathItem> observableList) {
        this.tableView.getSelectionModel().clearSelection();
        this.tableView.setItems(observableList);
        this.tableView.scrollTo(0);
    }

    private void pathItemSelected(PathItem pathItem, ImporterType importerType) {
        if (pathItem.isLeaf) {
            if (this.selFileType != FileType.ALL) {
                try {
                    this.browserFrame.loadFile(pathItem.getPath().toUri().toURL(), importerType);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        } else {
            ObservableList observableList = pathItem.getChildren();
            if (observableList != null) {
                int n;
                this.currBrowserTableParent = pathItem;
                this.setBrowserTable((ObservableList<PathItem>)observableList);
                this.isRootDirs = false;
                this.upDirButton.setDisable(false);
                this.topDirButton.setDisable(false);
                ArrayList<PathItem> arrayList = new ArrayList<PathItem>();
                PathItem pathItem2 = pathItem;
                while (pathItem2 != null) {
                    arrayList.add(pathItem2);
                    pathItem2 = pathItem2.getParent();
                }
                ObservableList observableList2 = FXCollections.observableArrayList();
                for (int i = n = arrayList.size() - 1; i >= 0; --i) {
                    PathItem pathItem3 = (PathItem)arrayList.get(i);
                    pathItem3.comboIndex = n - i;
                    observableList2.add((Object)pathItem3);
                }
                this.pathComboBox.setDisable(false);
                this.pathComboBox.setItems(observableList2);
                this.pathComboBox.getSelectionModel().select((Object)pathItem);
            }
        }
    }

    private void createTreeViewPane(PathTreeItem pathTreeItem) {
        this.treeView = new TreeView((TreeItem)pathTreeItem);
        this.treeView.setShowRoot(false);
        this.treeView.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<TreeItem<PathItem>>(){

            public void onChanged(ListChangeListener.Change<? extends TreeItem<PathItem>> change) {
                PathItem pathItem;
                TreeItem treeItem = (TreeItem)ModelBrowserFileChooser.this.treeView.getSelectionModel().getSelectedItem();
                if (treeItem != null && (pathItem = (PathItem)treeItem.getValue()) != null) {
                    ModelBrowserFileChooser.this.pathItemSelected(pathItem, null);
                    ModelBrowserFileChooser.this.treeView.getSelectionModel().clearSelection();
                }
            }
        });
        this.treeView.setCellFactory((Callback)new Callback<TreeView<PathItem>, TreeCell<PathItem>>(){

            public TreeCell<PathItem> call(TreeView<PathItem> treeView) {
                return new TreeCell<PathItem>(){

                    protected void updateItem(PathItem pathItem, boolean bl) {
                        super.updateItem((Object)pathItem, bl);
                        if (bl || pathItem == null) {
                            this.setText("     ");
                            this.setGraphic(null);
                        } else {
                            this.setText(pathItem.toString());
                            this.setGraphic(ModelBrowserFileChooser.this.createDirectoryGraphic());
                        }
                    }
                };
            }
        });
        this.splitButton = new Button("<");
        this.splitButton.getStyleClass().add((Object)"button-mb");
        this.splitButton.setTooltip(new Tooltip("Hide directories tree"));
        this.splitButton.setMinSize(0.0, 0.0);
        this.splitButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                ((SplitPane.Divider)ModelBrowserFileChooser.this.fileSystemSplitPane.getDividers().get(0)).setPosition(0.0);
            }
        });
        Label label = new Label("Directories");
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        hBox.getChildren().add((Object)label);
        HBox hBox2 = new HBox();
        hBox2.setAlignment(Pos.CENTER_RIGHT);
        hBox2.getChildren().addAll((Object[])new Node[]{this.splitButton});
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)hBox);
        borderPane.setRight((Node)hBox2);
        borderPane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.treeViewPane = new BorderPane();
        this.treeViewPane.setTop((Node)borderPane);
        this.treeViewPane.setCenter(this.treeView);
        this.treeViewPane.setMinSize(0.0, 0.0);
    }

    private Node createGraphicFor(FileType fileType) {
        switch (fileType) {
            case TDS: {
                return new Circle(7.0, 8.0, 5.0, (Paint)Color.ORCHID);
            }
            case COL: {
                return new Circle(7.0, 8.0, 5.0, (Paint)Color.DODGERBLUE);
            }
            case FXML: {
                return new Circle(7.0, 8.0, 5.0, (Paint)Color.GREEN);
            }
            case OBJ: {
                return new Circle(7.0, 8.0, 5.0, (Paint)Color.ORANGERED);
            }
            case STL: {
                return new Circle(7.0, 8.0, 5.0, (Paint)Color.PERU);
            }
            case X3D: {
                return new Circle(7.0, 8.0, 5.0, (Paint)Color.DARKRED);
            }
            case ALL: {
                break;
            }
            case ALL3D: {
                return this.createAll3DGraphic();
            }
        }
        return null;
    }

    private Node createAll3DGraphic() {
        Arc arc = new Arc(7.0, 8.0, 7.0, 7.0, 0.0, 60.0);
        arc.setType(ArcType.ROUND);
        arc.setFill((Paint)Color.ORCHID);
        arc.setStroke((Paint)Color.ORCHID);
        Arc arc2 = new Arc(7.0, 8.0, 7.0, 7.0, 60.0, 60.0);
        arc2.setType(ArcType.ROUND);
        arc2.setFill((Paint)Color.DODGERBLUE);
        arc2.setStroke((Paint)Color.DODGERBLUE);
        Arc arc3 = new Arc(7.0, 8.0, 7.0, 7.0, 120.0, 60.0);
        arc3.setType(ArcType.ROUND);
        arc3.setFill((Paint)Color.GREEN);
        arc3.setStroke((Paint)Color.GREEN);
        Arc arc4 = new Arc(7.0, 8.0, 7.0, 7.0, 180.0, 60.0);
        arc4.setType(ArcType.ROUND);
        arc4.setFill((Paint)Color.ORANGERED);
        arc4.setStroke((Paint)Color.ORANGERED);
        Arc arc5 = new Arc(7.0, 8.0, 7.0, 7.0, 240.0, 60.0);
        arc5.setType(ArcType.ROUND);
        arc5.setFill((Paint)Color.PERU);
        arc5.setStroke((Paint)Color.PERU);
        Arc arc6 = new Arc(7.0, 8.0, 7.0, 7.0, 300.0, 60.0);
        arc6.setType(ArcType.ROUND);
        arc6.setFill((Paint)Color.DARKRED);
        arc6.setStroke((Paint)Color.DARKRED);
        Pane pane = new Pane();
        pane.getChildren().addAll((Object[])new Node[]{arc, arc2, arc3, arc4, arc5, arc6});
        return pane;
    }

    private Node createDirectoryGraphic() {
        Rectangle rectangle = new Rectangle(0.0, 0.0, 12.0, 9.0);
        rectangle.setFill((Paint)Color.rgb((int)255, (int)226, (int)0));
        return rectangle;
    }

    static {
        numFormatSizeKB.setGroupingUsed(true);
    }

    private static final class PathTreeItem
    extends TreeItem<PathItem> {
        private final boolean isLeaf;
        private final boolean isRoot;
        private boolean isChildrenFirstTime = true;
        private boolean hasDirChildren = false;

        private PathTreeItem(PathItem pathItem) {
            super((Object)pathItem);
            if (pathItem != null) {
                this.isLeaf = pathItem.isLeaf;
                this.isRoot = false;
            } else {
                this.isLeaf = false;
                this.isRoot = true;
            }
        }

        public String toString() {
            return ((PathItem)this.getValue()).toString();
        }

        public boolean isLeaf() {
            if (this.isLeaf) {
                return true;
            }
            if (this.isRoot) {
                return false;
            }
            return !this.hasDirChildren;
        }

        private void resetFirstTime() {
            this.isChildrenFirstTime = true;
            ObservableList observableList = super.getChildren();
            if (observableList != null) {
                for (TreeItem treeItem : observableList) {
                    ((PathTreeItem)treeItem).resetFirstTime();
                }
            }
        }

        public ObservableList<TreeItem<PathItem>> getChildren() {
            if (this.isChildrenFirstTime && !this.isRoot) {
                this.isChildrenFirstTime = false;
                ObservableList observableList = null;
                if (this.isLeaf) {
                    observableList = FXCollections.emptyObservableList();
                } else if (!this.isRoot) {
                    observableList = FXCollections.observableArrayList();
                    ObservableList observableList2 = ((PathItem)this.getValue()).getChildren();
                    if (observableList2 != null && observableList2.size() > 0) {
                        for (Object object : observableList2) {
                            if (((PathItem)object).isLeaf) continue;
                            observableList.add((Object)new PathTreeItem((PathItem)object));
                        }
                    }
                    for (Object object : observableList) {
                        ((PathTreeItem)((Object)object)).hasDirChildren = ((PathItem)object.getValue()).hasDirChildren();
                    }
                }
                super.getChildren().setAll((Collection)observableList);
            }
            return super.getChildren();
        }
    }

    private static final class PathItemTimeComparator
    implements Comparator<PathItem> {
        private PathItemTimeComparator() {
        }

        @Override
        public int compare(PathItem pathItem, PathItem pathItem2) {
            if (pathItem.isLeaf) {
                if (pathItem2.isLeaf) {
                    if (pathItem.getTime() < pathItem2.getTime()) {
                        return -1;
                    }
                    if (pathItem.getTime() > pathItem2.getTime()) {
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            if (pathItem2.isLeaf) {
                return -1;
            }
            if (pathItem.getTime() < pathItem2.getTime()) {
                return -1;
            }
            if (pathItem.getTime() > pathItem2.getTime()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    private static final class PathItemSizeComparator
    implements Comparator<PathItem> {
        private PathItemSizeComparator() {
        }

        @Override
        public int compare(PathItem pathItem, PathItem pathItem2) {
            if (pathItem.isLeaf) {
                if (pathItem2.isLeaf) {
                    if (pathItem.getSize() < pathItem2.getSize()) {
                        return -1;
                    }
                    if (pathItem.getSize() > pathItem2.getSize()) {
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            if (pathItem2.isLeaf) {
                return -1;
            }
            return pathItem.getFileName().compareToIgnoreCase(pathItem2.getFileName());
        }

        @Override
        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    private static final class PathItemNameComparator
    implements Comparator<PathItem> {
        private PathItemNameComparator() {
        }

        @Override
        public int compare(PathItem pathItem, PathItem pathItem2) {
            if (pathItem.isLeaf) {
                if (pathItem2.isLeaf) {
                    return pathItem.getFileName().compareToIgnoreCase(pathItem2.getFileName());
                }
                return 1;
            }
            if (pathItem2.isLeaf) {
                return -1;
            }
            return pathItem.getFileName().compareToIgnoreCase(pathItem2.getFileName());
        }

        @Override
        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    final class TableTreeFilterSeparatorItem
    extends TableTreeFilter {
        TableTreeFilterSeparatorItem() {
            super(null, null, null, (Node)new Separator());
        }

        @Override
        boolean isDisable() {
            return true;
        }

        @Override
        double getPrefHeight() {
            return 5.0;
        }
    }

    private class TableTreeFilter {
        private final Node graphic;
        private final Node buttonGraphic;
        private final String text;
        private final FileType filter;
        private final ImporterType importerType;

        private TableTreeFilter(FileType fileType, String string, ImporterType importerType) {
            this(fileType, string, importerType, (Node)null);
        }

        private TableTreeFilter(FileType fileType, String string, ImporterType importerType, Node node) {
            this.filter = fileType;
            this.text = string;
            this.importerType = importerType;
            if (node == null) {
                this.graphic = ModelBrowserFileChooser.this.createGraphicFor(fileType);
                this.buttonGraphic = ModelBrowserFileChooser.this.createGraphicFor(fileType);
            } else {
                this.graphic = node;
                this.buttonGraphic = null;
            }
        }

        Node getGraphic() {
            return this.graphic;
        }

        Node getButtonGraphic() {
            return this.buttonGraphic;
        }

        String getText() {
            return this.text;
        }

        boolean isDisable() {
            return false;
        }

        double getPrefHeight() {
            ModelBrowserFileChooser.this.browserFrame;
            return ModelBrowserFrame.cellHeight;
        }

        public String toString() {
            return this.text;
        }
    }

    private static final class ChildrenVisitor
    extends SimpleFileVisitor<Path> {
        private final ArrayList<Path> fileList = new ArrayList();
        private final ArrayList<Path> failedList = new ArrayList(2);

        private ChildrenVisitor() {
        }

        private ArrayList<Path> getChildren() {
            return this.fileList;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
            this.fileList.add(path);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) {
            this.failedList.add(path);
            return FileVisitResult.TERMINATE;
        }
    }

    private final class PathItem {
        private final Path path;
        private final boolean isLeaf;
        private final boolean isRoot;
        private boolean isSupported3Dtype = false;
        private FileType leafFileType = FileType.ALL;
        private final PathItem parent;
        private ArrayList<PathItem> childDirList = null;
        private final StringProperty fileNameProp;
        private final StringProperty fileSizeProp;
        private final StringProperty fileDateProp;
        private int size = 0;
        private long milisec = 0L;
        private ObservableList<PathItem> children = null;
        private boolean isChildrenFirstTime = true;
        private final Set<FileVisitOption> options = EnumSet.noneOf(FileVisitOption.class);
        private int comboIndex = -1;

        private PathItem(Path path, PathItem pathItem) {
            this.path = path;
            this.parent = pathItem;
            boolean bl = this.isRoot = pathItem == null;
            this.isLeaf = this.isRoot ? false : !Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS);
            this.fileNameProp = new SimpleStringProperty((Object)this, "fileName");
            this.fileSizeProp = new SimpleStringProperty((Object)this, "fileSize");
            this.fileDateProp = new SimpleStringProperty((Object)this, "fileDate");
            try {
                Object object;
                if (path == null) {
                    this.fileNameProp.set((Object)"NA");
                } else if (this.isRoot) {
                    object = null;
                    if (ModelBrowserFileChooser.this.isSingleRootDropped) {
                        this.fileNameProp.set((Object)path.getFileName().toString());
                    } else {
                        object = Files.getFileStore(path);
                        if (object != null && object.toString() != null) {
                            this.fileNameProp.set((Object)object.toString());
                        } else {
                            this.fileNameProp.set((Object)path.getFileName().toString());
                        }
                    }
                } else {
                    object = path.getFileName();
                    if (object != null) {
                        String string = object.toString();
                        this.fileNameProp.set((Object)string);
                        String string2 = string.substring(string.lastIndexOf(46) + 1);
                        if (string2.equalsIgnoreCase("3ds")) {
                            this.leafFileType = FileType.TDS;
                            this.isSupported3Dtype = true;
                        } else if (string2.equalsIgnoreCase("dae") || string2.equalsIgnoreCase("zae")) {
                            this.leafFileType = FileType.COL;
                            this.isSupported3Dtype = true;
                        } else if (string2.equalsIgnoreCase("obj")) {
                            this.leafFileType = FileType.OBJ;
                            this.isSupported3Dtype = true;
                        } else if (string2.equalsIgnoreCase("stl")) {
                            this.leafFileType = FileType.STL;
                            this.isSupported3Dtype = true;
                        } else if (string2.equalsIgnoreCase("x3d") || string2.equalsIgnoreCase("x3dz")) {
                            this.leafFileType = FileType.X3D;
                            this.isSupported3Dtype = true;
                        } else if (string2.equalsIgnoreCase("fxml")) {
                            this.leafFileType = FileType.FXML;
                            this.isSupported3Dtype = true;
                        }
                    } else {
                        this.fileNameProp.set((Object)path.toString());
                    }
                }
                if (path == null || this.isRoot || !this.isLeaf) {
                    this.fileSizeProp.set((Object)"");
                } else {
                    long l = Files.size(path);
                    this.size = Math.max(1, (int)((double)l / 1024.0 + 0.5));
                    this.fileSizeProp.set((Object)numFormatSizeKB.format(this.size));
                }
                if (path == null) {
                    this.fileDateProp.set((Object)"");
                } else {
                    FileTime fileTime = Files.getLastModifiedTime(path, LinkOption.NOFOLLOW_LINKS);
                    this.milisec = fileTime.to(TimeUnit.MILLISECONDS);
                    long l = (long)((double)this.milisec / 1000.0);
                    LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(l, 0, ZoneOffset.UTC);
                    String string = localDateTime.toString();
                    String string3 = string.substring(0, string.indexOf(84));
                    String string4 = string3.replace('-', '.');
                    this.fileDateProp.set((Object)string4);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private StringProperty fileNameProperty() {
            return this.fileNameProp;
        }

        private void setFileName(String string) {
            this.fileNameProperty().set((Object)string);
        }

        private String getFileName() {
            return (String)this.fileNameProperty().get();
        }

        private StringProperty fileSizeProperty() {
            return this.fileSizeProp;
        }

        private void setFileSize(String string) {
            this.fileSizeProperty().set((Object)string);
        }

        private String getFileSize() {
            return (String)this.fileSizeProperty().get();
        }

        private int getSize() {
            return this.size;
        }

        private StringProperty fileDateProperty() {
            return this.fileDateProp;
        }

        private void setFileDate(String string) {
            this.fileDateProperty().set((Object)string);
        }

        private String getFileDate() {
            return (String)this.fileDateProperty().get();
        }

        private long getTime() {
            return this.milisec;
        }

        private Path getPath() {
            return this.path;
        }

        private PathItem getParent() {
            return this.parent;
        }

        private FileType getLeafFileType() {
            return this.leafFileType;
        }

        private void resetFirstTime() {
            this.isChildrenFirstTime = true;
            if (this.children != null) {
                this.children.clear();
                this.children = null;
            }
            if (this.childDirList != null && this.childDirList.size() > 0) {
                for (PathItem pathItem : this.childDirList) {
                    pathItem.resetFirstTime();
                }
            }
        }

        private boolean hasDirChildren() {
            if (this.isLeaf) {
                return false;
            }
            int n = 0;
            if (this.isChildrenFirstTime) {
                try {
                    ChildrenVisitor childrenVisitor = new ChildrenVisitor();
                    Files.walkFileTree(this.path, this.options, 1, childrenVisitor);
                    ArrayList arrayList = childrenVisitor.getChildren();
                    for (Path path : arrayList) {
                        if (path == null || Files.isHidden(path) || !Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) continue;
                        ++n;
                    }
                }
                catch (IOException iOException) {}
            } else if (this.childDirList != null) {
                n = this.childDirList.size();
            }
            return n > 0;
        }

        private ObservableList<PathItem> getChildren() {
            if (this.isChildrenFirstTime && !this.isLeaf) {
                this.isChildrenFirstTime = false;
                try {
                    this.children = FXCollections.observableArrayList();
                    ChildrenVisitor childrenVisitor = new ChildrenVisitor();
                    Files.walkFileTree(this.path, this.options, 1, childrenVisitor);
                    ArrayList arrayList = childrenVisitor.getChildren();
                    if (arrayList != null && arrayList.size() > 0) {
                        Object object22;
                        ArrayList<Path> arrayList2 = new ArrayList<Path>();
                        ArrayList<Path> arrayList3 = new ArrayList<Path>();
                        for (Object object22 : arrayList) {
                            if (object22 == null || Files.isHidden((Path)object22)) continue;
                            if (Files.isDirectory((Path)object22, LinkOption.NOFOLLOW_LINKS)) {
                                arrayList2.add((Path)object22);
                                continue;
                            }
                            if (!Files.isRegularFile((Path)object22, LinkOption.NOFOLLOW_LINKS)) continue;
                            arrayList3.add((Path)object22);
                        }
                        Object object3 = null;
                        object22 = null;
                        if (this.childDirList == null) {
                            this.childDirList = new ArrayList();
                        } else {
                            this.childDirList.clear();
                        }
                        int n = arrayList2.size();
                        if (n > 0) {
                            Object object4 = null;
                            Object object5 = null;
                            for (int i = n - 1; i >= 0; --i) {
                                object4 = (Path)arrayList2.get(i);
                                ChildrenVisitor childrenVisitor2 = new ChildrenVisitor();
                                Files.walkFileTree((Path)object4, this.options, 1, childrenVisitor2);
                                if (!childrenVisitor2.failedList.contains(object4)) continue;
                                arrayList2.remove(i);
                            }
                        }
                        for (Path path : arrayList2) {
                            object3 = new PathItem(path, this);
                            this.children.add(object3);
                            this.childDirList.add((PathItem)object3);
                        }
                        for (Path path : arrayList3) {
                            object22 = new PathItem(path, this);
                            if ((ModelBrowserFileChooser.this.selFileType != FileType.ALL3D || !((PathItem)object22).isSupported3Dtype) && ModelBrowserFileChooser.this.selFileType != ((PathItem)object22).leafFileType && ModelBrowserFileChooser.this.selFileType != FileType.ALL) continue;
                            this.children.add(object22);
                        }
                        FXCollections.sort(this.children, (Comparator)ModelBrowserFileChooser.this.pathItemNameComparator);
                    }
                }
                catch (IOException iOException) {
                    System.out.println("PathItem getChildren = " + iOException.getMessage());
                }
            }
            return this.children;
        }

        public String toString() {
            return (String)this.fileNameProp.get();
        }
    }
}

