/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.modelbrowser;

import com.interactivemesh.jfx.importer.Viewpoint;
import java.util.Comparator;
import javafx.geometry.Point3D;
import javafx.scene.Camera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;

final class ModelBrowserVP {
    private String name = "No name";
    private boolean isPerspective = true;
    private double farClip = 100.0;
    private double nearClip = 0.1;
    private double fov = 30.0;
    private boolean isVertical = true;
    private Affine transform = null;
    private Point3D centerOfRotation = null;

    private ModelBrowserVP() {
    }

    ModelBrowserVP(String string) {
        this();
        this.setName(string);
    }

    ModelBrowserVP(Viewpoint viewpoint) {
        if (viewpoint.getName() != null) {
            this.name = viewpoint.getName();
        }
        this.isPerspective = viewpoint.isPerspective();
        this.farClip = viewpoint.getFarClip();
        this.nearClip = viewpoint.getNearClip();
        this.fov = viewpoint.getFieldOfView();
        this.isVertical = viewpoint.isVerticalFieldOfView();
        this.transform = viewpoint.getTransform();
        this.centerOfRotation = viewpoint.getCenterOfRotation();
    }

    ModelBrowserVP(Camera camera, Affine affine) {
        this.name = camera.getId() != null ? camera.getId() : "No name";
        this.farClip = camera.getFarClip();
        this.nearClip = camera.getNearClip();
        if (camera instanceof PerspectiveCamera) {
            this.fov = ((PerspectiveCamera)camera).getFieldOfView();
            this.isVertical = ((PerspectiveCamera)camera).isVerticalFieldOfView();
        } else {
            this.isPerspective = false;
        }
        this.transform = affine;
    }

    boolean isPerspective() {
        return this.isPerspective;
    }

    void setProjectionMode(boolean bl) {
        this.isPerspective = bl;
    }

    String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    double getFarClip() {
        return this.farClip;
    }

    void setFarClip(double d) {
        this.farClip = d;
    }

    double getNearClip() {
        return this.nearClip;
    }

    void setNearClip(double d) {
        this.nearClip = d;
    }

    double getFieldOfView() {
        return this.fov;
    }

    void setFieldOfView(double d) {
        this.fov = d;
    }

    boolean isVerticalFieldOfView() {
        return this.isVertical;
    }

    void setIsVertical(boolean bl) {
        this.isVertical = bl;
    }

    Affine getTransform() {
        return new Affine((Transform)this.transform);
    }

    void setTransform(Affine affine) {
        this.transform = affine;
    }

    Point3D getCenterOfRotation() {
        return this.centerOfRotation;
    }

    void setCenterOfRotation(Point3D point3D) {
        this.centerOfRotation = point3D;
    }

    static final class CompVP
    implements Comparator<ModelBrowserVP> {
        CompVP() {
        }

        @Override
        public int compare(ModelBrowserVP modelBrowserVP, ModelBrowserVP modelBrowserVP2) {
            return modelBrowserVP.getName().compareToIgnoreCase(modelBrowserVP2.getName());
        }
    }
}

