/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.sourcecode.applet;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.applet.MainFrame;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.Locale;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JApplet;
import javax.vecmath.Vector3f;

public final class AppletObjLoader
extends JApplet {
    private boolean isJ3D = false;
    private boolean isJ3DLoader = false;
    private BoundingSphere globalBounds = null;
    private View view = null;
    private Canvas3D canvas3D = null;
    private VirtualUniverse vu = null;
    private Locale locale = null;
    private BranchGroup sceneBranch = null;
    private BranchGroup viewBranch = null;
    private BranchGroup enviBranch = null;
    private TransformGroup rotTG = null;
    private TransformGroup sceneTG = null;
    private Vector<Shape3D> shapesVec = null;
    private ClassLoader classLoader = null;

    static {
        System.out.println("AppletObjLoader: Copyright (c) 2009 August Lammersdorf, www.InteractiveMesh.com.");
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new AppletObjLoader(), 600, 600);
    }

    public void init() {
        System.out.println("AppletObjLoader : init");
        this.classLoader = this.getClass().getClassLoader();
        try {
            this.classLoader.loadClass("javax.media.j3d.BoundingSphere");
            this.isJ3D = true;
            this.classLoader.loadClass("com.sun.j3d.loaders.objectfile.ObjectFile");
            this.isJ3DLoader = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.isJ3D) {
            this.createUniverse();
            if (this.isJ3DLoader) {
                this.createScene();
            } else {
                System.out.println("Loader 'com.sun.j3d.loaders.objectfile.ObjectFile' not found !!");
            }
            this.setLive();
            this.getContentPane().add((Component)this.canvas3D);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        System.out.println("AppletObjLoader : destroy");
        this.view.removeAllCanvas3Ds();
        this.view.attachViewPlatform(null);
        this.vu.removeAllLocales();
    }

    private void createScene() {
        Scene fishScene = this.loadScene("scenes/Beethoven.obj");
        BranchGroup rootGroup = null;
        if (fishScene != null && (rootGroup = fishScene.getSceneGroup()) != null) {
            this.shapesVec = new Vector();
            this.traverseForShape3D(rootGroup.getAllChildren());
            if (!this.shapesVec.isEmpty()) {
                Appearance appear = new Appearance();
                Material mat = new Material();
                mat.setDiffuseColor(0.9f, 0.0f, 0.0f);
                mat.setSpecularColor(1.0f, 0.0f, 0.0f);
                mat.setShininess(32.0f);
                appear.setMaterial(mat);
                for (Shape3D shape : this.shapesVec) {
                    shape.setAppearance(appear);
                }
            }
            this.sceneTG.addChild((Node)rootGroup);
        }
        Alpha rotAlpha = new Alpha();
        rotAlpha.setMode(3);
        rotAlpha.setIncreasingAlphaDuration(1000L);
        rotAlpha.setAlphaAtOneDuration(200L);
        rotAlpha.setDecreasingAlphaDuration(2000L);
        rotAlpha.setDecreasingAlphaRampDuration(200L);
        rotAlpha.setAlphaAtZeroDuration(1000L);
        RotationInterpolator rotIntp = new RotationInterpolator(rotAlpha, this.rotTG);
        rotIntp.setSchedulingBounds((Bounds)this.globalBounds);
        rotIntp.setMinimumAngle(0.0f);
        rotIntp.setMaximumAngle((float)Math.PI * 2);
        this.sceneTG.addChild((Node)rotIntp);
    }

    private Scene loadScene(String relativePath) {
        Scene scene = null;
        URL sceneUrl = this.getClass().getResource(relativePath);
        if (sceneUrl == null) {
            System.out.println("sceneUrl = null");
            return null;
        }
        String sceneUrlString = sceneUrl.toString();
        String baseUrlString = sceneUrlString.substring(0, sceneUrlString.lastIndexOf(47) + 1);
        URL baseUrl = null;
        try {
            baseUrl = new URL(baseUrlString);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        System.out.println("Scene URL = " + sceneUrlString);
        ObjectFile objLoader = new ObjectFile();
        objLoader.setBaseUrl(baseUrl);
        System.out.println("Base Url  = " + objLoader.getBaseUrl().toString());
        try {
            scene = objLoader.load(sceneUrl);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IncorrectFormatException incorrectFormatException) {
        }
        catch (ParsingErrorException parsingErrorException) {
            // empty catch block
        }
        return scene;
    }

    private void traverseForShape3D(Enumeration e) {
        while (e.hasMoreElements()) {
            Object nodeObject = e.nextElement();
            if (nodeObject instanceof Group) {
                Enumeration children = ((Group)nodeObject).getAllChildren();
                this.traverseForShape3D(children);
                continue;
            }
            if (!(nodeObject instanceof Shape3D)) continue;
            this.shapesVec.add((Shape3D)nodeObject);
        }
    }

    private void setLive() {
        this.sceneBranch.compile();
        this.viewBranch.compile();
        this.enviBranch.compile();
        this.locale.addBranchGraph(this.sceneBranch);
        this.locale.addBranchGraph(this.viewBranch);
        this.locale.addBranchGraph(this.enviBranch);
    }

    private void createUniverse() {
        this.globalBounds = new BoundingSphere();
        this.globalBounds.setRadius(Double.MAX_VALUE);
        this.view = new View();
        this.view.setPhysicalBody(new PhysicalBody());
        this.view.setPhysicalEnvironment(new PhysicalEnvironment());
        GraphicsConfigTemplate3D gCT = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)gCT);
        try {
            this.canvas3D = new Canvas3D(gcfg);
        }
        catch (NullPointerException e) {
            System.out.println("AppletObjLoader: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.out.println("AppletObjLoader: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        this.view.addCanvas3D(this.canvas3D);
        this.vu = new VirtualUniverse();
        this.locale = new Locale(this.vu);
        this.sceneBranch = new BranchGroup();
        this.viewBranch = new BranchGroup();
        this.enviBranch = new BranchGroup();
        TransformGroup viewTG = new TransformGroup();
        viewTG.setCapability(18);
        Transform3D viewTransform = new Transform3D();
        viewTransform.setTranslation(new Vector3f(0.0f, 0.0f, 16.0f));
        viewTG.setTransform(viewTransform);
        ViewPlatform vp = new ViewPlatform();
        this.view.attachViewPlatform(vp);
        DirectionalLight headLight = new DirectionalLight();
        headLight.setInfluencingBounds((Bounds)this.globalBounds);
        viewTG.addChild((Node)vp);
        viewTG.addChild((Node)headLight);
        this.viewBranch.addChild((Node)viewTG);
        Background bg = new Background();
        bg.setApplicationBounds((Bounds)this.globalBounds);
        bg.setColor(0.0f, 0.47f, 0.63f);
        this.enviBranch.addChild((Node)bg);
        this.rotTG = new TransformGroup();
        this.rotTG.setCapability(18);
        this.sceneBranch.addChild((Node)this.rotTG);
        this.sceneTG = new TransformGroup();
        Transform3D sceneTransform = new Transform3D();
        sceneTransform.setTranslation(new Vector3f(0.281f, 0.4f, -0.421f));
        this.sceneTG.setTransform(sceneTransform);
        this.rotTG.addChild((Node)this.sceneTG);
    }
}

