/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.sourcecode.applet;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.utils.applet.MainFrame;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.PositionInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JApplet;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.loaders.vrml97.VrmlLoader;

public final class AppletVrmlLoader
extends JApplet {
    private boolean isJ3D = false;
    private boolean isJ3DLoader = false;
    private BoundingSphere globalBounds = null;
    private View view = null;
    private Canvas3D canvas3D = null;
    private VirtualUniverse vu = null;
    private Locale locale = null;
    private BranchGroup sceneBranch = null;
    private BranchGroup viewBranch = null;
    private BranchGroup enviBranch = null;
    private TransformGroup zoomTG = null;
    private TransformGroup sceneTG = null;
    private ClassLoader classLoader = null;

    static {
        System.out.println("AppletVrmlLoader: Copyright (c) 2007 August Lammersdorf, www.InteractiveMesh.com.");
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new AppletVrmlLoader(), 1000, 250);
    }

    public void init() {
        System.out.println("AppletVrmlLoader : init");
        this.classLoader = this.getClass().getClassLoader();
        try {
            this.classLoader.loadClass("javax.media.j3d.BoundingSphere");
            this.isJ3D = true;
            this.classLoader.loadClass("org.jdesktop.j3d.loaders.vrml97.VrmlLoader");
            this.isJ3DLoader = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.isJ3D) {
            this.createUniverse();
            if (this.isJ3DLoader) {
                this.createScene();
            } else {
                System.out.println("Loader 'org.jdesktop.j3d.loaders.vrml97.VrmlLoader' not found !!");
            }
            this.setLive();
            this.getContentPane().add((Component)this.canvas3D);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        System.out.println("AppletVrmlLoader : destroy");
        this.view.removeAllCanvas3Ds();
        this.view.attachViewPlatform(null);
        this.vu.removeAllLocales();
    }

    private void createScene() {
        Scene fishScene = this.loadScene("scenes/Fish.wrl");
        BranchGroup rootGroup = null;
        if (fishScene != null && (rootGroup = fishScene.getSceneGroup()) != null) {
            this.sceneTG.addChild((Node)rootGroup);
        }
        Alpha zoomAlpha = new Alpha();
        zoomAlpha.setMode(3);
        zoomAlpha.setIncreasingAlphaDuration(1000L);
        zoomAlpha.setAlphaAtOneDuration(200L);
        zoomAlpha.setDecreasingAlphaDuration(2000L);
        zoomAlpha.setDecreasingAlphaRampDuration(200L);
        zoomAlpha.setAlphaAtZeroDuration(1000L);
        PositionInterpolator zoomer = new PositionInterpolator(zoomAlpha, this.zoomTG);
        zoomer.setSchedulingBounds((Bounds)this.globalBounds);
        zoomer.setStartPosition(0.0f);
        zoomer.setEndPosition(8.0f);
        Transform3D axisOfTransform = new Transform3D();
        axisOfTransform.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, 1.2f));
        zoomer.setTransformAxis(axisOfTransform);
        this.sceneTG.addChild((Node)zoomer);
    }

    private Scene loadScene(String relativePath) {
        URL sceneUrl;
        BufferedReader bufferedReader;
        InputStream stream;
        Scene scene;
        block9: {
            block8: {
                scene = null;
                stream = this.getClass().getResourceAsStream(relativePath);
                if (stream != null) break block8;
                return null;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(stream));
            sceneUrl = this.getClass().getResource(relativePath);
            if (sceneUrl != null) break block9;
            return null;
        }
        try {
            String sceneUrlString = sceneUrl.toString();
            String baseUrlString = sceneUrlString.substring(0, sceneUrlString.lastIndexOf(47) + 1);
            URL baseUrl = new URL(baseUrlString);
            System.out.println("Scene URL = " + sceneUrlString);
            VrmlLoader vrmlLoader = new VrmlLoader();
            vrmlLoader.setBaseUrl(baseUrl);
            System.out.println("Base  URL = " + vrmlLoader.getBaseUrl().toString());
            try {
                scene = vrmlLoader.load((Reader)bufferedReader);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IncorrectFormatException e) {
                e.printStackTrace();
            }
            catch (ParsingErrorException e) {
                e.printStackTrace();
            }
            stream.close();
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return scene;
    }

    private void setLive() {
        this.sceneBranch.compile();
        this.viewBranch.compile();
        this.enviBranch.compile();
        this.locale.addBranchGraph(this.sceneBranch);
        this.locale.addBranchGraph(this.viewBranch);
        this.locale.addBranchGraph(this.enviBranch);
    }

    private void createUniverse() {
        this.globalBounds = new BoundingSphere();
        this.globalBounds.setRadius(Double.MAX_VALUE);
        this.view = new View();
        this.view.setPhysicalBody(new PhysicalBody());
        this.view.setPhysicalEnvironment(new PhysicalEnvironment());
        GraphicsConfigTemplate3D gCT = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)gCT);
        try {
            this.canvas3D = new Canvas3D(gcfg);
        }
        catch (NullPointerException e) {
            System.out.println("AppletVrmlLoader: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.out.println("AppletVrmlLoader: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        this.view.addCanvas3D(this.canvas3D);
        this.vu = new VirtualUniverse();
        this.locale = new Locale(this.vu);
        this.sceneBranch = new BranchGroup();
        this.viewBranch = new BranchGroup();
        this.enviBranch = new BranchGroup();
        TransformGroup viewTG = new TransformGroup();
        viewTG.setCapability(18);
        Transform3D viewTransform = new Transform3D();
        viewTransform.setTranslation(new Vector3f(0.5f, 0.25f, 1.0f));
        viewTG.setTransform(viewTransform);
        ViewPlatform vp = new ViewPlatform();
        this.view.attachViewPlatform(vp);
        DirectionalLight headLight = new DirectionalLight();
        headLight.setInfluencingBounds((Bounds)this.globalBounds);
        viewTG.addChild((Node)vp);
        viewTG.addChild((Node)headLight);
        this.viewBranch.addChild((Node)viewTG);
        Background bg = new Background();
        bg.setApplicationBounds((Bounds)this.globalBounds);
        bg.setColor(0.0f, 0.47f, 0.63f);
        this.enviBranch.addChild((Node)bg);
        this.zoomTG = new TransformGroup();
        this.zoomTG.setCapability(18);
        this.sceneBranch.addChild((Node)this.zoomTG);
        this.sceneTG = new TransformGroup();
        Transform3D sceneTransform = new Transform3D();
        sceneTransform.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, 0.9f));
        this.sceneTG.setTransform(sceneTransform);
        this.zoomTG.addChild((Node)this.sceneTG);
    }
}

