package com.interactivemesh.j3d.sourcecode.applet;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;

import java.net.URL;

import javax.media.j3d.Alpha;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Locale;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.PositionInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;

import javax.swing.JApplet;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3f;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;

import com.sun.j3d.utils.applet.MainFrame;

// Java 3D VRML97 Loader: j3d-vrm97.jar
// https://j3d-vrml97.dev.java.net/
import org.jdesktop.j3d.loaders.vrml97.VrmlLoader;


/**
 * @author Copyright (c) 2007 August Lammersdorf, www.InteractiveMesh.com
 * @since 2007/11/07
 * @version 1.2
 * 
 * Please create your own implementation.
 * You are allowed to copy all lines you like of this source code, 
 * but you may not modify, compile, or distribute this 'AppletVrmlLoader'. 
 * 
 */

public final class AppletVrmlLoader extends JApplet {

	static {
		System.out.println("AppletVrmlLoader: Copyright (c) 2007 August Lammersdorf, www.InteractiveMesh.com.");
	}

	private boolean			isJ3D		=	false;
	private boolean			isJ3DLoader	=	false;
	
	private BoundingSphere 	globalBounds = 	null;

	private View 			view 		= 	null;
	private	Canvas3D 		canvas3D 	=	null;
	
	private VirtualUniverse	vu 			= 	null;
	private Locale 			locale 		= 	null;
	
	private BranchGroup 	sceneBranch = 	null;
	private BranchGroup 	viewBranch 	= 	null;
	private BranchGroup 	enviBranch 	= 	null;
	
	private TransformGroup 	zoomTG 		= 	null;
	private TransformGroup 	sceneTG		= 	null;
	
	private ClassLoader 	classLoader = 	null;

    //
    // Allows AppletVrmlLoader to be run as an application as well as an applet
    //
    public static void main(String[] args) {
    	new MainFrame(new AppletVrmlLoader(), 1000, 250); 
    }

	public AppletVrmlLoader() {
	}
	
	@Override
	public void init() {
		System.out.println("AppletVrmlLoader : init");
		
		// Check if Java 3D and your loader package are installed
		classLoader = this.getClass().getClassLoader();		
		try {
			classLoader.loadClass("javax.media.j3d.BoundingSphere");
			isJ3D = true;
			
			classLoader.loadClass("org.jdesktop.j3d.loaders.vrml97.VrmlLoader");
			isJ3DLoader = true;
		}
		catch (ClassNotFoundException e) {
		}		
		
		if (isJ3D) {
			createUniverse();
			if (isJ3DLoader)
				createScene();
			else
				System.out.println("Loader 'org.jdesktop.j3d.loaders.vrml97.VrmlLoader' not found !!");
			setLive();
	
			this.getContentPane().add(canvas3D);
		}
	}
	@Override
	public void start() {
	}
	@Override
    public void stop() {
	}
	@Override
    public void destroy() {
		System.out.println("AppletVrmlLoader : destroy");
		
		view.removeAllCanvas3Ds();
		view.attachViewPlatform(null);
		
		vu.removeAllLocales();
	}
	
	private void createScene() {
		
		//
	    // Scene
    	//
		// File located at: com/interactivemesh/j3d/sourcecode/applet/scenes/Fish.wrl
		Scene fishScene = this.loadScene("scenes/Fish.wrl"); 
		BranchGroup rootGroup = null;
		if (fishScene != null && (rootGroup = fishScene.getSceneGroup()) != null)
			sceneTG.addChild(rootGroup);
		
		//
		// Animation
		//
		Alpha zoomAlpha = new Alpha();
		zoomAlpha.setMode(Alpha.INCREASING_ENABLE | Alpha.DECREASING_ENABLE);
		zoomAlpha.setIncreasingAlphaDuration(1000);
		zoomAlpha.setAlphaAtOneDuration(200);
		zoomAlpha.setDecreasingAlphaDuration(2000);
		zoomAlpha.setDecreasingAlphaRampDuration(200);
		zoomAlpha.setAlphaAtZeroDuration(1000);
		
		PositionInterpolator zoomer = new PositionInterpolator(zoomAlpha, zoomTG);
		zoomer.setSchedulingBounds(globalBounds);
		zoomer.setStartPosition(0.0f);
		zoomer.setEndPosition(8.0f);
		
		Transform3D axisOfTransform = new Transform3D();
		axisOfTransform.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, 1.2f));
		zoomer.setTransformAxis(axisOfTransform);
		
		sceneTG.addChild(zoomer);
	}
	
	// Loads Vrml97 (*.wrl) files
	// relativePath: path relative to package of this class
	private Scene loadScene(String relativePath) {
		
		Scene scene = null;
		
		try {
			// Alternative: classLoader.getResourceAsStream(relativePath)
			InputStream stream = this.getClass().getResourceAsStream(relativePath);
			if (stream == null)
				return null;
			
			BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));

			// Some loader could have problems to handle a url based on jar: protocol
			// The syntax of the jar: protocol is jar:<url>!/{entry}. "!/" is called the separator.
			// Examples local/web:
			// jar:file:/ ... /appletVrmlLoader.jar!/com/interactivemesh/j3d/sourcecode/applet/scenes/Fish.wrl
			// jar:http://www.interactivemesh.org/sourcecode/webstart/appletVrmlLoader.jar!/com/interactivemesh/j3d/sourcecode/applet/scenes/Fish.wrl			
			URL sceneUrl = this.getClass().getResource(relativePath);
			if (sceneUrl == null)
				return null;
			
			String sceneUrlString = sceneUrl.toString();
			String baseUrlString = sceneUrlString.substring(0, sceneUrlString.lastIndexOf('/') + 1); // since 1.2: +1
			
			URL baseUrl = new URL(baseUrlString);
			
			System.out.println("Scene URL = " + sceneUrlString);
			
			Loader vrmlLoader = new VrmlLoader(); // No flag: Shapes only
			
			// BaseUrl 
			vrmlLoader.setBaseUrl(baseUrl); 
			System.out.println("Base  URL = " + vrmlLoader.getBaseUrl().toString());
			
			try {
				scene = vrmlLoader.load(bufferedReader);
				
				// Alternative: if Loader is able to handle jar: protocol
				// scene = vrmlLoader.load(sceneUrl);
			}
			catch (FileNotFoundException e) {	
				e.printStackTrace();
			}
			catch (IncorrectFormatException e) {	
				e.printStackTrace();
			}
			catch (ParsingErrorException e) {		
				e.printStackTrace();
			}
	
			stream.close(); 
			bufferedReader.close();
		}
		catch (IOException e) {
			e.printStackTrace();
		}
		
		return scene;
	}
	
    // Set live
	private void setLive() {
		sceneBranch.compile();
		viewBranch.compile();
		enviBranch.compile();
        locale.addBranchGraph(sceneBranch);
        locale.addBranchGraph(viewBranch);
        locale.addBranchGraph(enviBranch);
	}
	
    private void createUniverse() {		
        // Bounds
    	globalBounds = new BoundingSphere();
        globalBounds.setRadius(Double.MAX_VALUE);		
        //
        // Viewing
        //
        view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        
        GraphicsConfigTemplate3D gCT = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(gCT);
        
        try {
        	canvas3D = new Canvas3D(gcfg);
        }
        catch (NullPointerException e) {
            System.out.println("AppletVrmlLoader: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.out.println("AppletVrmlLoader: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }               
        
    	view.addCanvas3D(canvas3D);
        //
        // SuperStructure
        //
        vu = new VirtualUniverse();
        locale = new Locale(vu);        
        //
        // BranchGraphs
        //		
        sceneBranch = new BranchGroup();
        viewBranch = new BranchGroup();
        enviBranch = new BranchGroup();
        
        // ViewBranch
        
        TransformGroup viewTG = new TransformGroup();
        viewTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        
        Transform3D viewTransform = new Transform3D();
        viewTransform.setTranslation(new Vector3f(0.5f, 0.25f, 1.0f)); 
        viewTG.setTransform(viewTransform);
                
        ViewPlatform vp = new ViewPlatform();
        view.attachViewPlatform(vp);
        
        DirectionalLight headLight = new DirectionalLight();
        headLight.setInfluencingBounds(globalBounds);

        viewTG.addChild(vp);
        viewTG.addChild(headLight);
        
        viewBranch.addChild(viewTG);
        
        // EnviBranch
        
        Background bg = new Background();
        bg.setApplicationBounds(globalBounds);
        bg.setColor(0.0f, 0.47f, 0.63f);
        
        enviBranch.addChild(bg);

        // SceneBranch
        
        zoomTG = new TransformGroup();
        zoomTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        
        sceneBranch.addChild(zoomTG);
        
        sceneTG = new TransformGroup();        
        // Scene positioning 
        Transform3D sceneTransform = new Transform3D();
        // Rotate around Y
        sceneTransform.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, 0.9f));
        sceneTG.setTransform(sceneTransform);

        zoomTG.addChild(sceneTG);       
    }
}
