
package com.interactivemesh.j3d.community.gui;

/*
 * License notice see 
 * 
 * "com.interactivemesh.j3d.community.gui.FXCanvas3DDB.java/FXCanvas3DSB.java"
 * or
 * "com.interactivemesh.j3d.community.gui.FXCanvas3DAnaglyph.java" 
 */

/**
 * The corresponding JavaFX SwingComponent class has to implement this interface to
 * enable the FXCanvas3D object to initialize its repainting.
 * 
 * @see FXCanvas3D
 */
public interface FXCanvas3DRepainter {
 
    /**
     * Called by the FXCanvas3D object from the postSwap-method to initialize its repainting.
     * <p>
     * The repaint request is handled by a FX.deferAction() 
     * - an equivalent to SwingUtilities.invokeLater() - 
     * and will be executed on the EDT. 
     * The assigned function calls firstly 'copyOffScreenBuffer()' 
     * while the Java 3D renderer thread is waiting and 
     * secondly 'repaint()' on the FXCanvas3D object.
     * </p>
     */
    public void repaintFXCanvas3D();   
}
