package com.interactivemesh.j3d.testspace.jfx.distortstring;

import javafx.async.JavaTaskBase;
import javafx.async.RunnableFuture;

/**
 * DistortStringUniverseFX.fx
 *
 * Version: 6.1
 * Date: 2010/09/19
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'DistortStringUniverseFX.fx'.
 *
 */

package class DistortStringUniverseFX extends JavaTaskBase {

    var universe: DistortStringUniverse;

    // Implemented in Main, called here from 'onDone'
    package var initUniverse: function(universe: DistortStringUniverse): Void;

    //
    // Scene interaction
    //
    package function setVantagePoint(name: String) {
        universe.setVantagePoint(name);
    }

    package function startStopDistort(start: Boolean) {
        universe.startStopDistort(start);
    }
    package var distortSpeed: Integer = 30 on replace {
        universe.setDistortSpeed(distortSpeed);
    }

    package function setGoldTexture(mode: String) {
        universe.setGoldTexture(mode);
    }

    package function setWoodTexture(mode: String) {
        universe.setWoodTexture(mode);
    }
        
    package function closeUniverse() {
        universe.closeUniverse();
    }

    //
    // Implementation of JavaTaskBase
    //

    // Create RunnableFuture: DistortStringUniverse
    // Called in function 'start()'
    protected override function create(): RunnableFuture {
        universe = new DistortStringUniverse();
        return universe;
    }
    // Called from DistortStringMain.fx
    // Initializes the 3D scene : calls run() on RunnableFuture 'universe'
    protected override function start(): Void {        
        // Nothing to do
        super.start();
    }
    // Callback: Finish init
    override var onDone = function(): Void {
        initUniverse(universe);
    };
}
