
/**
 * WoodDistort.frag
 *
 * is a derived work of the 3Dlabs fragment shader 'Wood1.frag'.
 '
 * Redistribution and use are permitted according to the following license notice.
 *
 * Version: 6.1 (FXDistortString)
 * Date: 2010/09/19
 *
 * Author:
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 */

/************************************************************************
* Wood1.frag - Simple fragment shader for wood                          *
*                                                                       *
* Author: John Kessenich                                                *
*                                                                       *
*                                                                       *
*               Copyright (C) 2002-2006  3Dlabs Inc. Ltd.               *
*                                                                       *
*                        All rights reserved.                           *
*                                                                       *
* Redistribution and use in source and binary forms, with or without    *
* modification, are permitted provided that the following conditions    *
* are met:                                                              *
*                                                                       *
*     Redistributions of source code must retain the above copyright    *
*     notice, this list of conditions and the following disclaimer.     *
*                                                                       *
*     Redistributions in binary form must reproduce the above           *
*     copyright notice, this list of conditions and the following       *
*     disclaimer in the documentation and/or other materials provided   *
*     with the distribution.                                            *
*                                                                       *
*     Neither the name of 3Dlabs Inc. Ltd. nor the names of its         *
*     contributors may be used to endorse or promote products derived   *
*     from this software without specific prior written permission.     *
*                                                                       *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   *
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     *
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS     *
* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE        *
* COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, *
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,  *
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      *
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER      *
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT    *
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN     *
* ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE       *
* POSSIBILITY OF SUCH DAMAGE.                                           *
*                                                                       *
************************************************************************/

uniform float GrainSizeRecip;
uniform vec3  DarkColor;
uniform vec3  Spread;

varying float LightIntensity;
varying vec3  Position;

void main (void) {
    //
    // cheap noise
    //
    vec3 location = Position;
    vec3 floorvec = vec3(floor(10.0 * Position.x), 0.0, floor(10.0 * Position.z));
    vec3 noise = Position * 10.0 - floorvec - 0.5;
    noise *= noise;
    location += noise * 0.12;

    //
    // distance from axis
    //
    float dist = location.x * location.x + location.z * location.z;
    float grain = dist * GrainSizeRecip;

    //
    // grain effects as function of distance
    //
    float brightness = fract(grain);
    if (brightness > 0.5)
        brightness = (1.0 - brightness);
    vec3 color = DarkColor + brightness * Spread;

    brightness = fract(grain * 7.0);
    if (brightness > 0.5)
        brightness = 1.0 - brightness;
    color -= brightness * Spread;

    //
    // also as a function of lines parallel to the axis
    //
    brightness = fract(grain * 47.0) * 0.60;
    float line = fract(Position.z + Position.x);
    float snap = floor(line * 20.0) * (1.0/20.0);
    if (line < snap + 0.006)
        color -= brightness * Spread;

    //
    // apply lighting effects from vertex processor
    //
    color = clamp(color * LightIntensity, 0.0, 1.0);

    gl_FragColor = vec4(color, 1.0);
}
