
package com.interactivemesh.j3d.testspace.jfx.hellocube;

import javafx.async.JavaTaskBase;
import javafx.async.RunnableFuture;

/**
 * HelloCubeUniverseFX.fx
 *
 * Version: 2.0
 * Date: 2010/05/14
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'HelloCubeUniverseFX.fx'.
 *
 */

// Bridge: JavaFX scene ==> Java 3D universe

package class HelloCubeUniverseFX extends JavaTaskBase {

    var universe: HelloCubeUniverse;

    // Implemented in HelloCubeMain, called here from 'onDone'
    package var initUniverse: function(universe: HelloCubeUniverse): Void;
    
    //
    // Scene interaction
    //

    package function closeUniverse() {
        universe.closeUniverse();
    }

    //
    // Implementation of JavaTaskBase
    //
    // Create a RunnableFuture: HelloCubeUniverse
    // Called in function 'start()'
    protected override function create(): RunnableFuture {
        universe = new HelloCubeUniverse();
        return universe;
    }
    // Called from CharacterCubeMain.fx: Create the 3D universe
    // 1. Calls create()
    // 2. A thread other than the JavaFX event dispatch thread
    //    calls run() on RunnableFuture 'universe'
    protected override function start(): Void {
        // Nothing to do
        super.start();
    }
    // Callback: Finish init
    // We are now back on the JavaFX event dispatch thread !!
    override var onDone = function(): Void {
        initUniverse(universe);
    };
}