
package com.interactivemesh.j3d.testspace.jfx.propellerpuzzle;

import java.awt.Dimension;

import java.awt.image.BufferedImage;

import java.lang.Math;
import java.lang.System;

import javax.swing.JPanel;

import javafx.ext.swing.SwingComponent;

import javafx.scene.layout.LayoutInfo;

// FXCanvas3DImage 2.0
import com.interactivemesh.j3d.community.gui.FXCanvas3DImage;
import com.interactivemesh.j3d.community.gui.FXCanvas3DImageRepainter;

/**
 * FXCancas3DComp.fx
 *
 * Version: 5.0
 * Date: 2010/09/19
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'FXCancas3DComp.fx'.
 *
 */

package class FXCanvas3DComp extends SwingComponent, 
                                     PuzzlePiecesManager,
                                     FXCanvas3DImageRepainter {

    // Container for FXCanvas3D's parent
    package var container: JPanel;

    // FXCanvas3D instance
    var fxCanvas3D: FXCanvas3DImage;

    // Puzzle image
    var puzzleImage: BufferedImage;

    //
    var puzzleCount: Integer = 0;
    var puzzleDrawnCount: Integer = 0;

    // Frames per second
    def updatesPerSecond = 2;
    var elapsedFrames: Integer = 50;
    var frameCounter: Integer;
    var startTimePaint: Number = System.nanoTime();
    var endTimePaint: Number;
    var frameDuration: Number;
    package var fpsPaint: Integer;

     // Create SwingComponent - called at construction time
    override protected function createJComponent(): JPanel {
        container = new JPanel();
    }

    // Called from Main
    package function initFXCanvas3D(universe: PropellerUniverse): Void {
        fxCanvas3D = universe.createFXCanvas3D(this, container);        
        fxCanvas3DImageResized();
    }

    package function createPuzzlePieces(puzzleRows: Integer, pieceLength: Integer): PuzzlePieceComponent[] {
        if (fxCanvas3D == null)
            return null;

        // Size of piece
        def pieceSize = new Dimension(pieceLength, pieceLength);
        def pieceLayoutInfo = LayoutInfo{width: pieceLength height: pieceLength};

        var puzzlePieces: PuzzlePieceComponent[];

        puzzleImage = fxCanvas3D.getCanvas3DImage(); 

        for (i in [0..(puzzleRows-1)]) {        // rows
           for (j in [0..(puzzleRows-1)]) {     // cols

                var pPiece = PuzzlePieceComponent{ layoutInfo: pieceLayoutInfo };
                pPiece.setPuzzlePiecesManager(this);
                
                insert pPiece into puzzlePieces;

                var x = j * pieceLength;
                var y = i * pieceLength;

                // Location of piece in puzzle
                pPiece.locationX = x;
                pPiece.locationY = y;
                // Move to location
                pPiece.translateX = x;
                pPiece.translateY = y;
                //
                pPiece.inCorrectPlace = true;

                // Init puzzle piece image
                var puzzlePanel = pPiece.puzzlePanel;

                puzzlePanel.setPreferredSize(pieceSize);
                puzzlePanel.setSize(pieceSize);

                puzzlePanel.puzzleImage = puzzleImage;
                puzzlePanel.puzzleWidth = pieceSize.width;
                puzzlePanel.puzzleHeight = pieceSize.height;

                puzzlePanel.imageX = j * pieceSize.width;
                puzzlePanel.imageY = ((puzzleRows-1) - i) * pieceSize.height; // rows upside down
            }
        }

        puzzleCount = sizeof puzzlePieces;

        return puzzlePieces;
    }

    //
    // Interface PuzzlePiecesManager
    //
    // Notify J3D-Renderer thread when all pieces are drawn for starting next loop
    override public function onPuzzlePieceDrawn(): Void {
        puzzleDrawnCount++;
        if (puzzleDrawnCount >= puzzleCount) {
            puzzleDrawnCount = 0;
            fxCanvas3D.imageDrawn();
        }
    }

    //
    // Interface FXCanvas3DImageRepainter
    //

    // Implemented in Main, called here from 'onResizedFXCanvas3DImage'
    package var fxCanvas3DImageResized: function(): Void;

    // Called from FXCanvas3DImage
    override public function onFXCanvas3DImageResized(): Void {
        fxCanvas3DImageResized();
    }

    // Called from FXCanvas3DImage
    override public function repaintFXCanvas3DImage() {
        /*
         JavaFX API :
         A deferAction represents an action that should be executed
         at a later time of the system's choosing.
         In systems based on event dispatch, such as Swing, execution of a
         deferAction generally means putting it on the event queue for later processing.
        */
        FX.deferAction(
            function(): Void {

                // Now we are in the JavaFX painting loop and on the EDT

                // Repaint puzzle pieces

                puzzleDrawnCount = 0;
                for (pieceComp in PropellerPuzzleMain.puzzlePieces) {
                    pieceComp.puzzlePanel.repaint();
                }

                //
                // Frames per second
                //

                frameCounter++;

                if (frameCounter >= elapsedFrames) {

                    endTimePaint = System.nanoTime();
                    frameDuration = (endTimePaint-startTimePaint)/frameCounter;
                    startTimePaint = endTimePaint;

                    fpsPaint = (1000000000 / frameDuration) as Integer;

                    // Reset
                    frameCounter = 0;
                    elapsedFrames = Math.max(1, ((fpsPaint + 0.5) / updatesPerSecond)) as Integer;
                }
            }
        );
    }
}
