/*
 * LICENSE
 *
 * PuzzlePieceComponent.fx is a derived work of JigsawPiece.fx
 *
 * Redistribution and use are permitted according to the following license notice.
 *
 * Version: 5.0
 * Date: 2010/09/19
 *
 * Author:
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
*/
/*
 * JigsawPiece.fx,
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * Copyright 2009 Sun Microsystems, Inc. All rights reserved. Use is subject to license terms.
 *
 * This file is available and licensed under the following license:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *   * Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *
 *   * Neither the name of Sun Microsystems nor the names of its contributors
 *     may be used to endorse or promote products derived from this software
 *     without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved. Use is subject to license terms.
 *
 * This file is available and licensed under the following license:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *   * Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *
 *   * Neither the name of Sun Microsystems nor the names of its contributors
 *     may be used to endorse or promote products derived from this software
 *     without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.interactivemesh.j3d.testspace.jfx.propellerpuzzle;

import javafx.ext.swing.SwingComponent;
import javafx.scene.input.MouseEvent;

import javax.swing.JPanel;

package class PuzzlePieceComponent extends SwingComponent {

    package var puzzlePanel: PuzzlePiecePanel;

    package var locationX: Number;
    package var locationY: Number;

    package var inCorrectPlace: Boolean = false on replace {
        if (inCorrectPlace) {
            puzzlePanel.setBorder(null);
        }
        else {
            puzzlePanel.setBorder(PuzzlePiecePanel.border);
        }
    };

    var startDragX: Number;
    var startDragY: Number;

    init {

        blocksMouse = true;        

        onMousePressed = function(e: MouseEvent): Void {
            if (not inCorrectPlace) {
                toFront(); 
                startDragX = translateX;
                startDragY = translateY;
            }
        }
        onMouseReleased = function(e: MouseEvent): Void {
            if (not inCorrectPlace) {
                // check if
                if (translateX < (locationX + 10) and translateX > (locationX - 10) and
                    translateY < (locationY + 10) and translateY > (locationY - 10)) {

                    translateX = locationX;
                    translateY = locationY;

                    inCorrectPlace = true;
                    toBack(); 
                    PropellerPuzzleMain.onPieceInPlace();
                }
            }
        }
        onMouseDragged = function(e: MouseEvent): Void {
            if (not inCorrectPlace) {
                translateX = startDragX + e.dragX;
                translateY = startDragY + e.dragY;
            }
        }
    }

    package function setPuzzlePiecesManager(manager: PuzzlePiecesManager) {
        puzzlePanel.manager = manager
    }

    // Create SwingComponent - called at construction time
    override protected function createJComponent(): JPanel {
        puzzlePanel = new PuzzlePiecePanel();
    }   
}
