
package com.interactivemesh.j3d.testspace.jfx.propellerpuzzle;

// JavaFX async operations
import javafx.async.JavaTaskBase;
import javafx.async.RunnableFuture;

/**
 * PropellerUniverseFX.fx
 *
 * Version: 5.0
 * Date: 2010/09/19
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'PropellerUniverseFX.fx'.
 *
 */

package class PropellerUniverseFX extends JavaTaskBase {

    var universe: PropellerUniverse;

    // Implemented in Main, called here from 'onDone'
    package var initUniverse: function(universe: PropellerUniverse): Void;
    
    //
    // Universe updates
    //

    package var rotationValue: Integer on replace {
        universe.setRotationSpeed(rotationValue);
    }

    package function setVantagePoint(name: String) {
        universe.setVantagePoint(name);
    }

    package function closeUniverse() {
        universe.closeUniverse();
    }

    //
    // Implementation of JavaTaskBase
    //
    // Create RunnableFuture: PropellerUniverse
    // Called in function 'start()'
    protected override function create(): RunnableFuture {
        universe = new PropellerUniverse();
        return universe;
    }
    // Called from PropellerPuzzleMain.fx
    // Initializes the 3D scene : calls run() on RunnableFuture 'universe'
    protected override function start(): Void {
        // Nothing to do
        super.start();
    }
    // Callback: Finish init
    override var onDone = function(): Void {
        initUniverse(universe);
    };

}