
package com.interactivemesh.j3d.testspace.jfx.propellerpuzzle;

import java.awt.Graphics;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;

/**
 * PuzzlePiecePanel.java
 *
 * Version: 5.0
 * Date: 2010/09/19
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'PuzzlePiecePanel.java'.
 *
 */

final class PuzzlePiecePanel extends JPanel {
    
    static final SoftBevelBorder border = new SoftBevelBorder(BevelBorder.RAISED);

    PuzzlePiecesManager manager = null;
    BufferedImage puzzleImage = null;
    
    int puzzleWidth = 0;
    int puzzleHeight = 0;
    
    int imageX = 0;
    int imageY = 0;

    PuzzlePiecePanel() {
    }

    @Override
    public void paintComponent(Graphics g) {

        super.paintComponent(g); // paint background

        if (puzzleImage != null) {
            // flip and draw puzzleImage
            g.drawImage(puzzleImage,
                    // destination: Graphics g, flip lowerY and upperY
                    // dx1      dy1           dx2                 dy2
                        0,      puzzleHeight, puzzleWidth,        0,
                     // source: BufferedImage paintImage
                     // sx1 sy1               sx2                 sy2
                        imageX, imageY,       imageX+puzzleWidth, imageY+puzzleHeight, null);
            // Callback
            manager.onPuzzlePieceDrawn();
        }
    }
}
