
package com.interactivemesh.j3d.testspace.jfx.tuxanaglyph;

import java.lang.System;

import javax.swing.JPanel;

import javafx.ext.swing.SwingComponent;
import javafx.util.Math;

// FXCanvas3DAnaglyph API 
import com.interactivemesh.j3d.community.gui.FXCanvas3DAnaglyph;
import com.interactivemesh.j3d.community.gui.FXCanvas3DRepainter;

/**
 * FXCancas3DAnaglyphComp.fx
 * 
 * Version: 3.0
 * Date: 2010/09/20
*
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'FXCancas3DAnaglyphComp.fx'.
 *
 */

package class FXCancas3DAnaglyphComp extends SwingComponent, FXCanvas3DRepainter {

    // Parent of FXCanvas3DAnaglyph
    var container: JPanel;

    // FXCanvas3DAnaglyph instance
    var fxCanvas3D: FXCanvas3DAnaglyph;

    // Frames per second
    def updatesPerSec: Integer = 2;
    var elapsedFrames: Integer = 50;
    var frameCounter: Integer;
    var startTimePaint: Number = System.nanoTime();
    var endTimePaint: Number;
    var frameDuration: Number;
    var framesPerSec: Integer;

     // Create SwingComponent - called at construction time
    override protected function createJComponent(): JPanel{
        container = new JPanel();
    }

    // Called from Main
    package function initFXCanvas3D(universe: TuxAnaglyphUniverse) {
        fxCanvas3D = universe.createFXCanvas3DAnaglyph(this, container);
    }

    // Implemented in Main, called here from 'repaintFXCanvas3D'
    package var updateFPS: function(fps: Integer, mpf: Integer): Void;

    // Interface FXCanvas3DRepainter

    // Called from FXCanvas3D
    override function repaintFXCanvas3D() {
        /*
         JavaFX API :
         A deferAction represents an action that should be executed
         at a later time of the system's choosing.
         In systems based on event dispatch, such as Swing, execution of a
         deferAction generally means putting it on the event queue for later processing.
        */
        FX.deferAction(
            function(): Void {

                // Now we are in the JavaFX painting loop and on the EDT

                // Merge left and right renderImages into paintImage and notify J3D-Renderer thread
                fxCanvas3D.copyOffScreenBuffer();

                // Repaint FXCanvas3D

                // Call doesn't wait, paintComponent() will be called in the next loop !?
                fxCanvas3D.repaint();

                //
                // Frames per second
                //

                frameCounter++;

                if (frameCounter >= elapsedFrames) {

                    endTimePaint = System.nanoTime();
                    frameDuration = (endTimePaint-startTimePaint)/frameCounter;
                    startTimePaint = endTimePaint;

                    framesPerSec = ((1000000000 / frameDuration) + 0.5) as Integer;

                    updateFPS(framesPerSec, ((frameDuration + 500000)/1000000) as Integer);

                    // Reset
                    frameCounter = 0;
                    elapsedFrames = Math.max(1, (framesPerSec / updatesPerSec)) as Integer;
                }
            }
        );
    }
}
