
package com.interactivemesh.j3d.testspace.jfx.tuxanaglyph;

import javafx.async.JavaTaskBase;
import javafx.async.RunnableFuture;

/**
 * TuxAnaglyphUniverseFX.fx
 *
 * Version: 3.0
 * Date: 2010/09/20
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'TuxAnaglyphUniverseFX.fx'.
 *
 */

package class TuxAnaglyphUniverseFX extends JavaTaskBase {

    var universe: TuxAnaglyphUniverse;

    // Implemented in Main, called here from 'onDone'
    package var initUniverse: function(universe: TuxAnaglyphUniverse): Void;

    //
    // Universe update
    //

    package var cubeDimension: Integer on replace {
        universe.setCubeDimension(cubeDimension);
    }

    package var rotationValue: Integer on replace {
        universe.setRotationSpeed(rotationValue);
    }

    package var eyesPosition: Integer on replace {
        universe.setEyesPosition(eyesPosition);
    }

    package var viewMode: String on replace {
        universe.setViewMode(viewMode);
    }

    package function setVantagePoint(name: String) {
        universe.setVantagePoint(name);
    }

    package function resetRotation() {
        universe.resetRotation();
    }

    package function closeUniverse() {
        universe.closeUniverse();
    }

    //
    // Implementation of JavaTaskBase
    //
    
    // Create RunnableFuture: TuxAnaglyphUniverse
    // Called in function 'start()'
    protected override function create(): RunnableFuture {
        universe = new TuxAnaglyphUniverse();
        return universe;
    }
    // Called from TuxAnaglyphMain.fx
    // Initializes the 3D scene : calls run() on RunnableFuture 'universe'
    protected override function start(): Void {
        // Nothing to do
        super.start();
    }
    // Callback: Finish init
    override var onDone = function(): Void {
        initUniverse(universe);
    };
}
