/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.gui;

import com.interactivemesh.j3d.community.gui.FXCanvas3DMVControl;
import com.sun.j3d.exp.swing.impl.AutoOffScreenCanvas3D;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class FXCanvas3DMV
extends JPanel
implements AncestorListener {
    private static double METERS_PER_PIXEL = 2.8222222222222223E-4;
    private GraphicsConfiguration graphicsConfig = null;
    private InternalCanvas3D canvas = null;
    private BufferedImage paintImage = null;
    private int[] paintIntBuffer = null;
    private int[] renderIntBuffer = null;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private FXCanvas3DMVControl mvControl = null;
    private int canvasIndex = -1;

    public FXCanvas3DMV() {
        this(null, null);
    }

    public FXCanvas3DMV(GraphicsDevice device) {
        this(null, device);
    }

    public FXCanvas3DMV(GraphicsConfigTemplate3D template) {
        this(template, null);
    }

    FXCanvas3DMV(GraphicsConfigTemplate3D template, GraphicsDevice device) {
        if (template == null) {
            template = new GraphicsConfigTemplate3D();
        }
        template.setStereo(3);
        template.setDoubleBuffer(3);
        this.graphicsConfig = device == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template) : device.getBestConfiguration((GraphicsConfigTemplate)template);
        this.addAncestorListener(this);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
    }

    void setFXCanvas3DMVControl(FXCanvas3DMVControl control, int index) {
        this.mvControl = control;
        this.canvasIndex = index;
    }

    int getFXCanvas3DMVIndex() {
        return this.canvasIndex;
    }

    boolean isCanvas3DCreated() {
        return this.canvas != null;
    }

    void startStopRenderer(boolean start) {
        if (this.canvas == null) {
            return;
        }
        if (start) {
            this.canvas.startRenderer();
        } else {
            this.canvas.stopRenderer();
        }
    }

    void copyOffScreenBuffer() {
        if (this.paintImage != null) {
            System.arraycopy(this.renderIntBuffer, 0, this.paintIntBuffer, 0, this.renderIntBuffer.length);
        }
    }

    public void ancestorAdded(AncestorEvent event) {
        Dimension sz = this.getSize();
        if (sz.width == 0) {
            sz.width = 100;
        }
        if (sz.height == 0) {
            sz.height = 100;
        }
        if (this.mvControl == null) {
            throw new IllegalStateException("No FXCanvas3DMVControl object is set !!");
        }
        this.mvControl.createOffScreenCanvas(this.canvasIndex, sz.width, sz.height);
        this.canvas.addNotifyFlag = true;
        this.canvas.addNotify();
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.canvas.removeNotify();
    }

    public Canvas3D getOffscreenCanvas3D() {
        if (this.canvas == null) {
            if (this.mvControl == null) {
                throw new IllegalStateException("No FXCanvas3DMVControl object is set !!");
            }
            this.mvControl.createOffScreenCanvas(this.canvasIndex, this.getWidth(), this.getHeight());
        }
        return this.canvas;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.mvControl == null) {
            throw new IllegalStateException("No FXCanvas3DMVControl object is set !!");
        }
        if (this.canvas != null && this.canvas.getWidth() == width && this.canvas.getHeight() == height) {
            return;
        }
        this.mvControl.createOffScreenCanvas(this.canvasIndex, width, height);
    }

    final void createOffScreenCanvas(int width, int height) {
        if (this.getParent() == null) {
            return;
        }
        if (this.canvas == null) {
            this.canvas = new InternalCanvas3D(this.graphicsConfig);
        } else if (this.canvas.getWidth() == width && this.canvas.getHeight() == height) {
            return;
        }
        if (width < 1) {
            width = 2;
        }
        if (height < 1) {
            height = 2;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.canvas.createOffScreenBuffer(this.graphicsConfig.getBounds(), width, height);
        } else {
            final int finWidth = width;
            final int finHeight = height;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FXCanvas3DMV.this.canvas.createOffScreenBuffer(FXCanvas3DMV.this.graphicsConfig.getBounds(), finWidth, finHeight);
                }
            });
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.paintImage == null || !this.canvas.isRendererRunning()) {
            return;
        }
        g.drawImage(this.paintImage, 0, this.imageHeight, this.imageWidth, 0, 0, 0, this.imageWidth, this.imageHeight, null);
    }

    protected void processComponentKeyEvent(KeyEvent e) {
        super.processComponentKeyEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processComponentEvent(e);
        e.setSource(src);
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processFocusEvent(e);
        e.setSource(src);
    }

    protected void processInputMethodEvent(InputMethodEvent e) {
        super.processInputMethodEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processInputMethodEvent(e);
        e.setSource(src);
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processKeyEvent(e);
        e.setSource(src);
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseEvent(e);
        e.setSource(src);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseMotionEvent(e);
        e.setSource(src);
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseWheelEvent(e);
        e.setSource(src);
    }

    private final class InternalCanvas3D
    extends Canvas3D
    implements AutoOffScreenCanvas3D {
        private BufferedImage renderImage;
        private boolean addNotifyFlag;

        private InternalCanvas3D(GraphicsConfiguration graphicsConfiguration) {
            super(graphicsConfiguration, true);
            this.renderImage = null;
            this.addNotifyFlag = false;
        }

        private void createOffScreenBuffer(Rectangle screenRect, int width, int height) {
            int screenWidth = (int)screenRect.getWidth();
            int screenHeight = (int)screenRect.getHeight();
            Screen3D screen3D = this.getScreen3D();
            screen3D.setSize(screenWidth, screenHeight);
            screen3D.setPhysicalScreenWidth((double)screenWidth * METERS_PER_PIXEL);
            screen3D.setPhysicalScreenHeight((double)screenHeight * METERS_PER_PIXEL);
            if (this.renderImage != null) {
                this.renderImage.flush();
            }
            if (FXCanvas3DMV.this.paintImage != null) {
                FXCanvas3DMV.this.paintImage.flush();
            }
            this.renderImage = new BufferedImage(width, height, 2);
            ImageComponent2D image = new ImageComponent2D(2, this.renderImage, true, true);
            image.setCapability(2);
            image.setCapability(3);
            FXCanvas3DMV.this.paintImage = new BufferedImage(width, height, 2);
            FXCanvas3DMV.this.paintIntBuffer = ((DataBufferInt)FXCanvas3DMV.this.paintImage.getRaster().getDataBuffer()).getData();
            FXCanvas3DMV.this.renderIntBuffer = ((DataBufferInt)this.renderImage.getRaster().getDataBuffer()).getData();
            FXCanvas3DMV.this.imageWidth = width;
            FXCanvas3DMV.this.imageHeight = height;
            this.waitForOffScreenRendering();
            try {
                this.setOffScreenBuffer(image);
            }
            catch (RestrictedAccessException e) {
                this.createOffScreenBuffer(screenRect, width, height);
                System.out.println("Repeat : createOffScreenBuffer(screenRect, width, height) !!");
            }
        }

        public void addNotify() {
            if (!this.addNotifyFlag) {
                throw new UnsupportedOperationException("CHANGE ME");
            }
            this.addNotifyFlag = false;
            super.addNotify();
        }

        public Container getParent() {
            return FXCanvas3DMV.this.getParent();
        }

        public void postSwap() {
            FXCanvas3DMV.this.mvControl.postSwapFXCanvas3DMV(FXCanvas3DMV.this.canvasIndex);
        }

        protected void processComponentEvent(ComponentEvent e) {
            super.processComponentEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
        }

        protected void processInputMethodEvent(InputMethodEvent e) {
            super.processInputMethodEvent(e);
        }

        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            super.processMouseWheelEvent(e);
        }
    }
}

