
package com.interactivemesh.j3d.testspace.jfx.canvascube;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.QuadArray;

/**
 * CubeFaces.java
 * 
 * Version: 4.0
 * Date: 2010/09/20
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'CubeFaces.java'.
 *
 */
final class CubeFaces {

    static GeometryArray[] create(int vertexFormat, float cubeSize) {

        float[] coordsFront = {
            0.0f, 0.0f,  cubeSize,          // back +Z
            cubeSize, 0.0f,  cubeSize,
            cubeSize,  cubeSize,  cubeSize,
            0.0f,  cubeSize,  cubeSize
        };
        float[] coordsBack = {
            cubeSize, 0.0f, 0.0f,           // front -Z
            0.0f, 0.0f, 0.0f,
            0.0f,  cubeSize, 0.0f,
            cubeSize,  cubeSize, 0.0f
        };
        float[] coordsRight = {
            cubeSize, 0.0f,  cubeSize,      // right +X
            cubeSize, 0.0f, 0.0f,
            cubeSize,  cubeSize, 0.0f,
            cubeSize,  cubeSize,  cubeSize
        };
        float[] coordsLeft = {
            0.0f, 0.0f, 0.0f,               // left -X
            0.0f, 0.0f,  cubeSize,
            0.0f,  cubeSize,  cubeSize,
            0.0f,  cubeSize, 0.0f
        };
        float[] coordsTop = {
            0.0f,  cubeSize,  cubeSize,     // top +Y
            cubeSize,  cubeSize,  cubeSize,
            cubeSize,  cubeSize, 0.0f,
            0.0f,  cubeSize, 0.0f
        };
        float[] coordsBottom = {
           0.0f, 0.0f,  cubeSize,           // bottom -Y
            0.0f, 0.0f, 0.0f,
            cubeSize, 0.0f, 0.0f,
            cubeSize, 0.0f,  cubeSize
        };

        float[] texCoords2Front = {
            0.0f, 0.0f,       // +Z
            1.0f, 0.0f,
            1.0f, 1.0f,
            0.0f, 1.0f
        };
        float[] texCoords2Back = {
            1.0f,  0.0f,     // -Z
            0.0f,  0.0f,
            0.0f,  1.0f,
            1.0f,  1.0f
        };
        float[] texCoords2Right = {
            0.0f, 0.0f,       // +X
            1.0f, 0.0f,
            1.0f, 1.0f,
            0.0f, 1.0f
        };
        float[] texCoords2Left = {
            0.0f,  0.0f,    // -X
            1.0f,  0.0f,
            1.0f,  1.0f,
            0.0f,  1.0f
        };
        float[] texCoords2Top = {
            1.0f, 1.0f,     // +Y
            0.0f, 1.0f,
            0.0f, 0.0f,
            1.0f, 0.0f      
       };
        float[] texCoords2Bottom = {
            1.0f, 0.0f,     // -Y
            1.0f, 1.0f,
            0.0f, 1.0f,     
            0.0f, 0.0f
        };

        float[] normalsFront = {
            0.0f, 0.0f, 1.0f,       // +Z
            0.0f, 0.0f, 1.0f,
            0.0f, 0.0f, 1.0f,
            0.0f, 0.0f, 1.0f
        };
        float[] normalsBack = {
            0.0f,  0.0f, -1.0f,     // -Z
            0.0f,  0.0f, -1.0f,
            0.0f,  0.0f, -1.0f,
            0.0f,  0.0f, -1.0f
        };
        float[] normalsRight = {
            1.0f, 0.0f, 0.0f,       // +X
            1.0f, 0.0f, 0.0f,
            1.0f, 0.0f, 0.0f,
            1.0f, 0.0f, 0.0f
        };
        float[] normalsLeft = {
           -1.0f,  0.0f,  0.0f,    // -X
            -1.0f,  0.0f,  0.0f,
            -1.0f,  0.0f,  0.0f,
            -1.0f,  0.0f,  0.0f
        };
        float[] normalsTop = {
            0.0f, 1.0f, 0.0f,       // +Y
            0.0f, 1.0f, 0.0f,
            0.0f, 1.0f, 0.0f,
            0.0f, 1.0f, 0.0f
        };
        float[] normalsBottom = {
            0.0f, -1.0f,  0.0f,     // -Y
            0.0f, -1.0f,  0.0f,
            0.0f, -1.0f,  0.0f,
            0.0f, -1.0f,  0.0f
        };

        float[] colorsFront = {
            0.0f, 0.0f,  1.0f,      // front +Z
            1.0f, 0.0f,  1.0f,
            1.0f,  1.0f,  1.0f,
            0.0f,  1.0f,  1.0f
        };
        float[] colorsBack = {
            1.0f, 0.0f, 0.0f,       // back -Z
            0.0f, 0.0f, 0.0f,
            0.0f,  1.0f, 0.0f,
            1.0f,  1.0f, 0.0f,
        };
        float[] colorsRight = {
            1.0f, 0.0f,  1.0f,      // right +X
            1.0f, 0.0f, 0.0f,
            1.0f,  1.0f, 0.0f,
            1.0f,  1.0f,  1.0f,
        };
        float[] colorsLeft = {
            0.0f, 0.0f, 0.0f,       // left -X
            0.0f, 0.0f,  1.0f,
            0.0f,  1.0f,  1.0f,
            0.0f,  1.0f, 0.0f,
        };
        float[] colorsTop = {
            0.0f,  1.0f,  1.0f,     // top +Y
            1.0f,  1.0f,  1.0f,
            1.0f,  1.0f, 0.0f,
            0.0f,  1.0f, 0.0f,
        };
        float[] colorsBottom = {
            0.0f, 0.0f,  1.0f,      // bottom -Y
            0.0f, 0.0f, 0.0f,
            1.0f, 0.0f, 0.0f,
            1.0f, 0.0f,  1.0f
        };

        GeometryArray[] geoms = new QuadArray[6];

        GeometryArray geometry = new QuadArray(4, vertexFormat);

        if ((vertexFormat & GeometryArray.BY_REFERENCE) != 0) {
            geometry.setCoordRefFloat(coordsFront);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormalRefFloat(normalsFront);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColorRefFloat(colorsFront);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTexCoordRefFloat(0, texCoords2Front);
        }
        else {
            geometry.setCoordinates(0, coordsFront);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormals(0, normalsFront);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColors(0, colorsFront);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTextureCoordinates(0, 0, texCoords2Front);
        }

        geoms[0] = geometry;

        geometry = new QuadArray(4, vertexFormat);

        if ((vertexFormat & GeometryArray.BY_REFERENCE) != 0) {
            geometry.setCoordRefFloat(coordsBack);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormalRefFloat(normalsBack);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColorRefFloat(colorsBack);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTexCoordRefFloat(0, texCoords2Back);
        }
        else {
            geometry.setCoordinates(0, coordsBack);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormals(0, normalsBack);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColors(0, colorsBack);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTextureCoordinates(0, 0, texCoords2Back);
        }

        geoms[1] = geometry;

        geometry = new QuadArray(4, vertexFormat);

        if ((vertexFormat & GeometryArray.BY_REFERENCE) != 0) {
            geometry.setCoordRefFloat(coordsRight);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormalRefFloat(normalsRight);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColorRefFloat(colorsRight);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTexCoordRefFloat(0, texCoords2Right);
        }
        else {
            geometry.setCoordinates(0, coordsRight);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormals(0, normalsRight);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColors(0, colorsRight);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTextureCoordinates(0, 0, texCoords2Right);
        }

        geoms[2] = geometry;

        geometry = new QuadArray(4, vertexFormat);

        if ((vertexFormat & GeometryArray.BY_REFERENCE) != 0) {
            geometry.setCoordRefFloat(coordsLeft);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormalRefFloat(normalsLeft);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColorRefFloat(colorsLeft);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTexCoordRefFloat(0, texCoords2Left);
        }
        else {
            geometry.setCoordinates(0, coordsLeft);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormals(0, normalsLeft);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColors(0, colorsLeft);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTextureCoordinates(0, 0, texCoords2Left);
        }

        geoms[3] = geometry;

        geometry = new QuadArray(4, vertexFormat);

        if ((vertexFormat & GeometryArray.BY_REFERENCE) != 0) {
            geometry.setCoordRefFloat(coordsTop);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormalRefFloat(normalsTop);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColorRefFloat(colorsTop);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTexCoordRefFloat(0, texCoords2Top);
        }
        else {
            geometry.setCoordinates(0, coordsTop);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormals(0, normalsTop);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColors(0, colorsTop);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTextureCoordinates(0, 0, texCoords2Top);
        }

        geoms[4] = geometry;

        geometry = new QuadArray(4, vertexFormat);

        if ((vertexFormat & GeometryArray.BY_REFERENCE) != 0) {
            geometry.setCoordRefFloat(coordsBottom);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormalRefFloat(normalsBottom);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColorRefFloat(colorsBottom);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTexCoordRefFloat(0, texCoords2Bottom);
        }
        else {
            geometry.setCoordinates(0, coordsBottom);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormals(0, normalsBottom);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColors(0, colorsBottom);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_2) != 0)
                geometry.setTextureCoordinates(0, 0, texCoords2Bottom);
        }

        geoms[5] = geometry;

        return geoms;
    }
}
