
package com.interactivemesh.j3d.testspace.jfx.canvascube;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.media.j3d.Canvas3D;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

import javafx.ext.swing.SwingComponent;

// FXCanvas3DMV API
import com.interactivemesh.j3d.community.gui.FXCanvas3DMV;

/**
 * FXCancas3DComp.fx
 *
 * Version: 4.0
 * Date: 2010/09/20
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'FXCancas3DComp.fx'.
 *
 */
 
package class FXCancas3DComp extends SwingComponent {

    // Container for FXCanvas3D's parent
    var container: JPanel;

    // FXCanvas3DMV instance
    var fxCanvas3DMV: FXCanvas3DMV;
    var offCanvas3D: Canvas3D;

    // SwingComponent
    override protected function createJComponent(): JComponent{
        def dim = new Dimension(300, 300);

        container = new JPanel(new BorderLayout());
        container.setPreferredSize(dim);
        container.setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));

        this.opacity = 0.0; 

        return container;
    }

    // Called from Main
    package function initFXCanvas3D(fxcanvas3d: FXCanvas3DMV) {

        fxCanvas3DMV = fxcanvas3d;
        fxCanvas3DMV.setSize(container.getSize());

        container.add(fxCanvas3DMV.getParent(), BorderLayout.CENTER);

        offCanvas3D = fxcanvas3d.getOffscreenCanvas3D();

        this.opacity = 1.0;
    }

    package function setRendererRunning(run: Boolean) {

        if (offCanvas3D == null) {
            return;
        }

        if (run and not offCanvas3D.isRendererRunning()) {
            fxCanvas3DMV.getOffscreenCanvas3D().startRenderer();
        }
        else if (not run and offCanvas3D.isRendererRunning()) {
            fxCanvas3DMV.getOffscreenCanvas3D().stopRenderer();
        }
    }
}
