
package com.interactivemesh.j3d.testspace.jfx.canvascube;

import java.lang.System;

import javafx.async.JavaTaskBase;
import javafx.async.RunnableFuture;

import javafx.ext.swing.SwingUtils;

import javafx.scene.image.Image;

import javafx.util.Math;

// FXCanvas3DMV API
import com.interactivemesh.j3d.community.gui.FXCanvas3DMV;
import com.interactivemesh.j3d.community.gui.FXCanvas3DMVControl;
import com.interactivemesh.j3d.community.gui.FXCanvas3DMVRepainter;

/**
 * TuxInTheBoxUniverseFX.fx
 *
 * Version: 4.0
 * Date: 2010/09/20
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'TuxInTheBoxUniverseFX.fx'.
 *
 */

package class TuxInTheBoxUniverseFX extends JavaTaskBase, FXCanvas3DMVRepainter {
    
    // Frames per second
    def updatesPerSecond = 2;
    var elapsedFrames: Integer = 50;
    var frameCounter: Integer;
    var startTimePaint: Number = System.nanoTime();
    var endTimePaint: Number;
    var frameDuration: Number;
    package var fpsPaint: Integer;

    package var fieldOfView: Integer on replace {
        universe.setViewing(fieldOfView);
    }

    package var universe: TuxInTheBoxUniverse;

    package var fxCanvas3DMVControl: FXCanvas3DMVControl;


    // Implemented in Main, called here from 'onDone'
    package var initUniverse: function(universe: TuxInTheBoxUniverse): Void;

    package function getFXCanvas3DMV(index: Integer): FXCanvas3DMV {
        universe.getFXCanvas3DMV(index);
    }

    package function getFaceImages(): Image[] {

        var images: Image[];
        def bImages = universe.getIconImages();

        for (bImage in bImages) {
            insert SwingUtils.toFXImage(bImage)
            into images;
        }

        return images;
    }

    package function setFaceTexture(index: Integer): Void {
        universe.setBoxFaceTexture(index);
    }
    //
    package function closeUniverse() {
        universe.closeUniverse();
    }
    
    //
    // Implementation of JavaTaskBase
    //
    // Create RunnableFuture: TuxInTheBoxUniverse
    // Called in function 'start()'
    protected override function create(): RunnableFuture {
        universe = new TuxInTheBoxUniverse();
        return universe;
    }
    // Called from TuxInTheBoxMain.fx
    // Initializes the 3D scene : calls run() on RunnableFuture 'universe'
    protected override function start(): Void {        
        // Nothing to do
        super.start();
    }
    // Callback: Finish init
    override var onDone = function(): Void {
        initUniverse(universe);
    };

    //
    // Interface FXCanvas3DRepainter
    //
    // Called from FXCanvas3DMVControl
    override function repaintFXCanvas3DMV() {
        /*
         JavaFX API :
         A deferAction represents an action that should be executed
         at a later time of the system's choosing.
         In systems based on event dispatch, such as Swing, execution of a
         deferAction generally means putting it on the event queue for later processing.
        */
        FX.deferAction(
            function(): Void {

                // Now we are in the JavaFX painting loop and on the EDT

                // Copy renderImages into paintImages and notify J3D-Renderer thread
                // Call repaint on all fxCanvas3DMVs
                fxCanvas3DMVControl.copyBuffersAndRepaint();

            }
        );

        //
        // Frames per second
        //

        frameCounter++;

        if (frameCounter >= elapsedFrames) {

            endTimePaint = System.nanoTime();
            frameDuration = (endTimePaint-startTimePaint)/frameCounter;
            startTimePaint = endTimePaint;

            fpsPaint = (1000000000 / frameDuration) as Integer;

            // Reset
            frameCounter = 0;
            elapsedFrames = Math.max(1, ((fpsPaint + 0.5) / updatesPerSecond)) as Integer;
        }
    }
}
