/*
 * Decompiled with CFR 0.152.
 */
package org.interactivemesh.pivot.wtk.j3d.nav;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.pivot.wtk.Component;
import org.interactivemesh.pivot.wtk.j3d.nav.OrbitEvent;
import org.interactivemesh.pivot.wtk.j3d.nav.ViewPlatformEventBehaviorPivot;

public class OrbitBehaviorPivot
extends ViewPlatformEventBehaviorPivot {
    private Transform3D longditudeTransform = new Transform3D();
    private Transform3D latitudeTransform = new Transform3D();
    private Transform3D rotateTransform = new Transform3D();
    private Transform3D temp1 = new Transform3D();
    private Transform3D temp2 = new Transform3D();
    private Transform3D translation = new Transform3D();
    private Vector3d transVector = new Vector3d();
    private Vector3d distanceVector = new Vector3d();
    private Vector3d centerVector = new Vector3d();
    private Vector3d invertCenterVector = new Vector3d();
    private double longditude = 0.0;
    private double latitude = 0.0;
    private double startDistanceFromCenter = 20.0;
    private double distanceFromCenter = 20.0;
    private Point3d rotationCenter = new Point3d();
    private Matrix3d rotMatrix = new Matrix3d();
    private int mouseX = 0;
    private int mouseY = 0;
    private double rotXFactor = 1.0;
    private double rotYFactor = 1.0;
    private double transXFactor = 1.0;
    private double transYFactor = 1.0;
    private double zoomFactor = 1.0;
    private double xtrans = 0.0;
    private double ytrans = 0.0;
    private double ztrans = 0.0;
    private boolean zoomEnabled = true;
    private boolean rotateEnabled = true;
    private boolean translateEnabled = true;
    private boolean reverseRotate = false;
    private boolean reverseTrans = false;
    private boolean reverseZoom = false;
    private boolean stopZoom = false;
    private boolean proportionalZoom = false;
    private double minRadius = 0.0;
    private int leftButton = 0;
    private int rightButton = 1;
    private int middleButton = 2;
    private OrbitEvent.Nav navigation = null;
    private float wheelZoomFactor = 50.0f;
    public static final int REVERSE_ROTATE = 16;
    public static final int REVERSE_TRANSLATE = 32;
    public static final int REVERSE_ZOOM = 64;
    public static final int REVERSE_ALL = 112;
    public static final int STOP_ZOOM = 256;
    public static final int DISABLE_ROTATE = 512;
    public static final int DISABLE_TRANSLATE = 1024;
    public static final int DISABLE_ZOOM = 2048;
    public static final int PROPORTIONAL_ZOOM = 4096;
    private static final int ROTATE = 0;
    private static final int TRANSLATE = 1;
    private static final int ZOOM = 2;
    private static final double NOMINAL_ZOOM_FACTOR = 0.01;
    private static final double NOMINAL_PZOOM_FACTOR = 1.0;
    private static final double NOMINAL_ROT_FACTOR = 0.01;
    private static final double NOMINAL_TRANS_FACTOR = 0.01;
    private double rotXMul = 0.01 * this.rotXFactor;
    private double rotYMul = 0.01 * this.rotYFactor;
    private double transXMul = 0.01 * this.transXFactor;
    private double transYMul = 0.01 * this.transYFactor;
    private double zoomMul = 0.01 * this.zoomFactor;
    private double parallelScale = 1.0;
    private double parallelScaleFactor = 1.0;
    private double parallelScalePure = 1.0;
    private boolean isPureParallelProjection = false;
    private boolean isClippingUpdate = false;
    protected View view = null;
    protected int projection = 1;
    protected BoundingSphere sceneSphere = null;
    protected Point3d sceneCenter = new Point3d();
    protected double sceneRadius = 0.0;
    protected double radiusFactor = 1.2;
    protected double maxClipRatio = 1000.0;
    protected double minBackClipDistance = 1.0E-5;

    public OrbitBehaviorPivot() {
        super(11);
    }

    public OrbitBehaviorPivot(int flags) {
        super(0xB | flags);
        this.updateFlags(flags);
    }

    public OrbitBehaviorPivot(Component c, TransformGroup tg) {
        this(c, tg, 0);
    }

    public OrbitBehaviorPivot(Component c, TransformGroup tg, View view) {
        this(c, tg, view, 0);
    }

    public OrbitBehaviorPivot(Component c, TransformGroup tg, int flags) {
        super(0xB | flags);
        if (c == null) {
            throw new NullPointerException("Component is null !");
        }
        if (tg == null) {
            throw new NullPointerException("TransformGroup is null !");
        }
        this.updateFlags(flags);
        this.setComponent(c);
        this.setViewingTransformGroup(tg);
    }

    public OrbitBehaviorPivot(Component c, TransformGroup tg, View view, int flags) {
        this(c, tg, flags);
        if (view == null) {
            throw new NullPointerException("View is null !");
        }
        this.view = view;
        view.setProjectionPolicy(1);
    }

    private void updateFlags(int flags) {
        if ((flags & 0x200) != 0) {
            this.rotateEnabled = false;
        }
        if ((flags & 0x800) != 0) {
            this.zoomEnabled = false;
        }
        if ((flags & 0x400) != 0) {
            this.translateEnabled = false;
        }
        if ((flags & 0x20) != 0) {
            this.reverseTrans = true;
        }
        if ((flags & 0x10) != 0) {
            this.reverseRotate = true;
        }
        if ((flags & 0x40) != 0) {
            this.reverseZoom = true;
        }
        if ((flags & 0x100) != 0) {
            this.stopZoom = true;
        }
        if ((flags & 0x1000) != 0) {
            this.proportionalZoom = true;
            this.zoomMul = 1.0 * this.zoomFactor;
        }
    }

    @Override
    public void setComponent(Component c) {
        super.setComponent(c);
        if (this.component != null && this.targetTG != null) {
            this.resetView();
            this.integrateTransforms();
        }
    }

    @Override
    public void setViewingTransformGroup(TransformGroup tg) {
        super.setViewingTransformGroup(tg);
        if (this.component != null && this.targetTG != null) {
            this.resetView();
            this.integrateTransforms();
        }
    }

    public View getVpView() {
        return this.view;
    }

    public void setVpView(View view) {
        this.view = view;
        if (view != null) {
            if (this.isClippingUpdate) {
                view.setBackClipPolicy(2);
                view.setFrontClipPolicy(2);
            }
            if (this.projection == 0) {
                view.setScreenScalePolicy(1);
            }
        }
        if (this.component != null && this.targetTG != null && view != null && (this.isClippingUpdate || this.projection == 0)) {
            this.resetView();
            this.integrateTransforms();
        }
    }

    public int getProjectionMode() {
        return this.projection;
    }

    public void setProjectionMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("");
        }
        if (this.view == null) {
            throw new IllegalStateException("No View object set !");
        }
        this.projection = mode;
        if (this.projection == 0) {
            this.setParScFacAccToFoV(this.view.getFieldOfView());
            this.view.setScreenScalePolicy(1);
        } else if (this.projection == 1) {
            this.view.setScreenScalePolicy(0);
        }
        this.view.setProjectionPolicy(this.projection);
        if (this.targetTG != null) {
            this.resetView();
            this.integrateTransforms();
        } else if (this.projection == 0) {
            this.parallelScale = this.distanceFromCenter * this.parallelScaleFactor;
            if (this.parallelScale > 0.0) {
                this.view.setScreenScale(1.0 / this.parallelScale);
            }
        }
    }

    public boolean isPureParallelEnabled() {
        return this.isPureParallelProjection;
    }

    public void setPureParallelEnabled(boolean enable) {
        this.isPureParallelProjection = enable;
        this.parallelScalePure = 1.0;
    }

    public double getFieldOfView() {
        if (this.view == null) {
            throw new IllegalStateException("No View object set !");
        }
        return this.view.getFieldOfView();
    }

    public void setFieldOfView(double angle) {
        if (this.view == null) {
            throw new IllegalStateException("No View object set !");
        }
        if (angle <= 0.0) {
            throw new IllegalStateException("FieldOfView <= 0 :" + angle + " !");
        }
        this.view.setFieldOfView(angle);
        if (this.projection == 0) {
            this.setParScFacAccToFoV(angle);
            if (this.targetTG != null) {
                this.resetView();
                this.integrateTransforms();
            } else {
                this.parallelScale = this.distanceFromCenter * this.parallelScaleFactor;
                if (this.parallelScale > 0.0) {
                    this.view.setScreenScale(1.0 / this.parallelScale);
                }
            }
        }
    }

    private void setParScFacAccToFoV(double fov) {
        int num = 0;
        num = this.view.numCanvas3Ds();
        if (num < 1) {
            throw new IllegalStateException("View holds no Canvas3D !");
        }
        double tanFoVHalf = Math.tan(fov / 2.0);
        double physicalScreenWidth = 1.0;
        Canvas3D canvas3D = null;
        int i = 0;
        while (i < num) {
            canvas3D = this.view.getCanvas3D(i);
            if (canvas3D != null) {
                physicalScreenWidth = canvas3D.getScreen3D().getPhysicalScreenWidth();
                break;
            }
            ++i;
        }
        if (canvas3D == null) {
            throw new IllegalStateException("View holds no Canvas3D !");
        }
        this.parallelScaleFactor = tanFoVHalf * 2.0 / physicalScreenWidth;
    }

    public boolean isClippingEnabled() {
        return this.isClippingUpdate;
    }

    public void setClippingEnabled(boolean enable) {
        this.isClippingUpdate = enable;
        if (this.view != null && this.isClippingUpdate) {
            this.view.setBackClipPolicy(2);
            this.view.setFrontClipPolicy(2);
            this.setClippingDistances();
        }
    }

    public Bounds getClippingBounds() {
        return (Bounds)this.sceneSphere.clone();
    }

    public void setClippingBounds(Bounds sceneBounds) {
        if (sceneBounds == null || sceneBounds.isEmpty()) {
            this.sceneCenter.set(0.0, 0.0, 0.0);
            this.sceneRadius = -1.0;
            this.sceneSphere = new BoundingSphere(this.sceneCenter, this.sceneRadius);
            return;
        }
        this.sceneSphere = sceneBounds instanceof BoundingSphere ? (BoundingSphere)sceneBounds.clone() : new BoundingSphere(sceneBounds);
        this.sceneSphere.getCenter(this.sceneCenter);
        this.sceneRadius = this.sceneSphere.getRadius() * this.radiusFactor;
        this.setClippingDistances();
    }

    protected void setClippingDistances() {
        if (this.sceneSphere == null || this.sceneSphere.isEmpty() || this.view == null) {
            return;
        }
        double radius = this.sceneRadius + this.rotationCenter.distance(this.sceneCenter);
        double backClipDistance = Math.max(this.minBackClipDistance, this.distanceFromCenter + radius);
        double frontClipDistance = Math.max(backClipDistance - 2.0 * radius, backClipDistance / this.maxClipRatio);
        this.view.setBackClipDistance(backClipDistance);
        this.view.setFrontClipDistance(frontClipDistance);
    }

    @Override
    protected synchronized void processEvents(OrbitEvent[] events) {
        this.motion = false;
        int i = 0;
        while (i < events.length) {
            if (events[i].type == OrbitEvent.Type.MOUSE) {
                this.processMouseEvent(events[i]);
            }
            ++i;
        }
    }

    void processMouseEvent(OrbitEvent evt) {
        if (evt.id == OrbitEvent.ID.MOUSE_PRESSED) {
            this.mouseX = evt.x;
            this.mouseY = evt.y;
            this.motion = true;
            this.navigation = evt.nav;
        } else if (evt.id == OrbitEvent.ID.MOUSE_DRAGGED) {
            int xchange = evt.x - this.mouseX;
            int ychange = evt.y - this.mouseY;
            if (this.navigation == OrbitEvent.Nav.ROTATE) {
                if (this.reverseRotate) {
                    this.longditude -= (double)xchange * this.rotXMul;
                    this.latitude -= (double)ychange * this.rotYMul;
                } else {
                    this.longditude += (double)xchange * this.rotXMul;
                    this.latitude += (double)ychange * this.rotYMul;
                }
            } else if (this.navigation == OrbitEvent.Nav.TRANSLATE) {
                if (this.reverseTrans) {
                    this.xtrans -= (double)xchange * this.transXMul;
                    this.ytrans += (double)ychange * this.transYMul;
                } else {
                    this.xtrans += (double)xchange * this.transXMul;
                    this.ytrans -= (double)ychange * this.transYMul;
                }
            } else if (this.navigation == OrbitEvent.Nav.ZOOM) {
                this.doZoomOperations(ychange);
            }
            this.mouseX = evt.x;
            this.mouseY = evt.y;
            this.motion = true;
        } else if (evt.id == OrbitEvent.ID.MOUSE_RELEASED) {
            this.navigation = null;
        } else if (evt.id == OrbitEvent.ID.MOUSE_WHEEL_ROTATED) {
            int zoom = (int)((float)evt.wheelRotation * this.wheelZoomFactor);
            this.doZoomOperations(zoom);
            this.motion = true;
        }
    }

    private void doZoomOperations(int ychange) {
        this.distanceFromCenter = this.proportionalZoom ? (this.reverseZoom ? (this.distanceFromCenter - this.zoomMul * (double)ychange * this.distanceFromCenter / 100.0 > this.minRadius ? (this.distanceFromCenter -= this.zoomMul * (double)ychange * this.distanceFromCenter / 100.0) : this.minRadius) : (this.distanceFromCenter + this.zoomMul * (double)ychange * this.distanceFromCenter / 100.0 > this.minRadius ? (this.distanceFromCenter += this.zoomMul * (double)ychange * this.distanceFromCenter / 100.0) : this.minRadius)) : (this.stopZoom ? (this.reverseZoom ? (this.distanceFromCenter - (double)ychange * this.zoomMul > this.minRadius ? (this.distanceFromCenter -= (double)ychange * this.zoomMul) : this.minRadius) : (this.distanceFromCenter + (double)ychange * this.zoomMul > this.minRadius ? (this.distanceFromCenter += (double)ychange * this.zoomMul) : this.minRadius)) : (this.reverseZoom ? (this.distanceFromCenter -= (double)ychange * this.zoomMul) : (this.distanceFromCenter += (double)ychange * this.zoomMul)));
    }

    protected void resetView() {
        Vector3d centerToView = new Vector3d();
        this.targetTransform.get(this.rotMatrix, this.transVector);
        centerToView.sub((Tuple3d)this.transVector, (Tuple3d)this.rotationCenter);
        this.startDistanceFromCenter = this.distanceFromCenter = centerToView.length();
        this.rotateTransform.set(this.rotMatrix);
        this.temp1.set(centerToView);
        this.rotateTransform.invert();
        this.rotateTransform.mul(this.temp1);
        this.rotateTransform.get(centerToView);
        this.xtrans = centerToView.x;
        this.ytrans = centerToView.y;
        this.ztrans = centerToView.z;
        this.rotateTransform.set(this.rotMatrix);
    }

    protected void resetViewParallelLookAtRotCenter() {
        Vector3d centerToView = new Vector3d();
        this.targetTransform.get(this.rotMatrix, this.transVector);
        if (this.isPureParallelProjection) {
            this.distanceFromCenter *= this.parallelScalePure;
            this.parallelScalePure = 1.0;
        }
        centerToView.sub((Tuple3d)this.transVector, (Tuple3d)this.rotationCenter);
        this.rotateTransform.set(this.rotMatrix);
        this.temp1.set(centerToView);
        this.rotateTransform.invert();
        this.rotateTransform.mul(this.temp1);
        this.rotateTransform.get(centerToView);
        this.xtrans = 0.0;
        this.ytrans = 0.0;
        this.ztrans = this.distanceFromCenter;
        this.startDistanceFromCenter = this.distanceFromCenter;
        this.rotateTransform.set(this.rotMatrix);
    }

    protected void resetViewPureParallelRotCenter() {
        Vector3d centerToView = new Vector3d();
        this.targetTransform.get(this.rotMatrix, this.transVector);
        double distanceOld = this.distanceFromCenter;
        centerToView.sub((Tuple3d)this.transVector, (Tuple3d)this.rotationCenter);
        this.startDistanceFromCenter = this.distanceFromCenter = centerToView.length();
        double distanceNew = this.distanceFromCenter;
        double distanceRatio = 1.0;
        if (distanceOld > 0.0) {
            distanceRatio = distanceOld / distanceNew;
        }
        this.parallelScalePure *= distanceRatio;
        this.rotateTransform.set(this.rotMatrix);
        this.temp1.set(centerToView);
        this.rotateTransform.invert();
        this.rotateTransform.mul(this.temp1);
        this.rotateTransform.get(centerToView);
        this.xtrans = centerToView.x;
        this.ytrans = centerToView.y;
        this.ztrans = centerToView.z;
        this.rotateTransform.set(this.rotMatrix);
    }

    @Override
    protected synchronized void integrateTransforms() {
        this.longditudeTransform.rotY(this.longditude);
        this.latitudeTransform.rotX(this.latitude);
        this.rotateTransform.mul(this.rotateTransform, this.latitudeTransform);
        this.rotateTransform.mul(this.rotateTransform, this.longditudeTransform);
        this.distanceVector.z = this.distanceFromCenter - this.startDistanceFromCenter;
        this.temp1.set(this.distanceVector);
        this.temp1.mul(this.rotateTransform, this.temp1);
        this.transVector.x = this.rotationCenter.x + this.xtrans;
        this.transVector.y = this.rotationCenter.y + this.ytrans;
        this.transVector.z = this.rotationCenter.z + this.ztrans;
        this.translation.set(this.transVector);
        this.targetTransform.mul(this.temp1, this.translation);
        this.temp1.set(this.centerVector);
        this.temp1.mul(this.targetTransform);
        this.invertCenterVector.x = -this.centerVector.x;
        this.invertCenterVector.y = -this.centerVector.y;
        this.invertCenterVector.z = -this.centerVector.z;
        this.temp2.set(this.invertCenterVector);
        this.targetTransform.mul(this.temp1, this.temp2);
        if (this.projection == 0) {
            this.parallelScale = this.isPureParallelProjection ? this.distanceFromCenter * this.parallelScaleFactor * this.parallelScalePure : this.distanceFromCenter * this.parallelScaleFactor;
            if (this.parallelScale > 0.0) {
                this.view.setScreenScale(1.0 / this.parallelScale);
            }
        }
        this.targetTG.setTransform(this.targetTransform);
        if (this.isClippingUpdate) {
            this.setClippingDistances();
        }
        this.longditude = 0.0;
        this.latitude = 0.0;
    }

    @Override
    public void goHome() {
        this.goHome(false);
    }

    @Override
    public void goHome(boolean aroundHomeCenter) {
        if (aroundHomeCenter) {
            this.setViewingTransform(this.homeTransform, this.homeRotCenter);
        } else {
            this.setViewingTransform(this.homeTransform);
        }
    }

    public void getViewingTransform(Transform3D transform) {
        if (transform == null) {
            throw new NullPointerException("Transform3D is null !");
        }
        transform.set(this.targetTransform);
    }

    public void setViewingTransform(Transform3D transform) {
        if (transform == null) {
            throw new NullPointerException("Transform3D is null !");
        }
        if (this.targetTG == null) {
            throw new IllegalStateException("No TransformGroup object set !");
        }
        this.parallelScalePure = 1.0;
        this.targetTransform.set(transform);
        this.resetView();
        this.integrateTransforms();
    }

    public void setViewingTransform(Transform3D transform, Point3d rotationCenter) {
        if (transform == null) {
            throw new NullPointerException("Transform3D is null !");
        }
        if (rotationCenter == null) {
            throw new NullPointerException("Point3d is null !");
        }
        if (this.targetTG == null) {
            throw new IllegalStateException("No TransformGroup object set !");
        }
        this.parallelScalePure = 1.0;
        this.targetTransform.set(transform);
        this.resetView();
        this.integrateTransforms();
        if (this.projection == 0 && this.isPureParallelProjection) {
            this.distanceFromCenter = 0.0;
        }
        this.setRotationCenter(rotationCenter, false);
    }

    public void setViewingTransform(Point3d eye, Point3d viewCenter, Vector3d up, boolean rotateAtViewCenter) {
        if (eye == null) {
            throw new NullPointerException("Point3d eye is null !");
        }
        if (viewCenter == null) {
            throw new NullPointerException("Point3d viewCenter is null !");
        }
        if (up == null) {
            throw new NullPointerException("Vector3d up is null !");
        }
        if (this.targetTG == null) {
            throw new IllegalStateException("No TransformGroup object set !");
        }
        Transform3D transform = new Transform3D();
        transform.lookAt(eye, viewCenter, up);
        transform.invert();
        if (rotateAtViewCenter) {
            this.setViewingTransform(transform, viewCenter);
        } else {
            this.setViewingTransform(transform);
        }
    }

    public void setViewingTransform(Point3d eye, Point3d viewCenter, Vector3d up, Point3d rotationCenter) {
        if (eye == null) {
            throw new NullPointerException("Point3d eye is null !");
        }
        if (viewCenter == null) {
            throw new NullPointerException("Point3d viewCenter is null !");
        }
        if (up == null) {
            throw new NullPointerException("Vector3d up is null !");
        }
        if (rotationCenter == null) {
            throw new NullPointerException("Point3d rotationCenter is null !");
        }
        if (this.targetTG == null) {
            throw new IllegalStateException("No TransformGroup object set !");
        }
        Transform3D transform = new Transform3D();
        transform.lookAt(eye, viewCenter, up);
        transform.invert();
        this.setViewingTransform(transform, rotationCenter);
    }

    public void setRotationCenter(Point3d center) {
        this.setRotationCenter(center, false);
    }

    public void setRotationCenter(Point3d center, boolean lookAtRotCenter) {
        this.rotationCenter.x = center.x;
        this.rotationCenter.y = center.y;
        this.rotationCenter.z = center.z;
        this.centerVector.set((Tuple3d)this.rotationCenter);
        if (this.targetTG == null) {
            return;
        }
        if (this.projection == 0) {
            if (lookAtRotCenter) {
                this.resetViewParallelLookAtRotCenter();
            } else if (this.isPureParallelProjection) {
                this.resetViewPureParallelRotCenter();
            } else {
                this.resetView();
            }
        } else {
            this.resetView();
            if (lookAtRotCenter) {
                this.xtrans = 0.0;
                this.ytrans = 0.0;
            }
        }
        this.integrateTransforms();
    }

    public void lookAtRotationCenter() {
        if (this.targetTG != null) {
            this.resetView();
            this.xtrans = 0.0;
            this.ytrans = 0.0;
            this.integrateTransforms();
        }
    }

    public void getRotationCenter(Point3d center) {
        center.x = this.rotationCenter.x;
        center.y = this.rotationCenter.y;
        center.z = this.rotationCenter.z;
    }

    public synchronized void setRotFactors(double xfactor, double yfactor) {
        this.rotXFactor = xfactor;
        this.rotYFactor = yfactor;
        this.rotXMul = 0.01 * xfactor;
        this.rotYMul = 0.01 * yfactor;
    }

    public synchronized void setRotXFactor(double xfactor) {
        this.rotXFactor = xfactor;
        this.rotXMul = 0.01 * xfactor;
    }

    public synchronized void setRotYFactor(double yfactor) {
        this.rotYFactor = yfactor;
        this.rotYMul = 0.01 * yfactor;
    }

    public synchronized void setTransFactors(double xfactor, double yfactor) {
        this.transXFactor = xfactor;
        this.transYFactor = yfactor;
        this.transXMul = 0.01 * xfactor;
        this.transYMul = 0.01 * yfactor;
    }

    public synchronized void setTransXFactor(double xfactor) {
        this.transXFactor = xfactor;
        this.transXMul = 0.01 * xfactor;
    }

    public synchronized void setTransYFactor(double yfactor) {
        this.transYFactor = yfactor;
        this.transYMul = 0.01 * yfactor;
    }

    public synchronized void setZoomFactor(double zfactor) {
        this.zoomFactor = zfactor;
        this.zoomMul = this.proportionalZoom ? 1.0 * zfactor : 0.01 * zfactor;
    }

    public double getRotXFactor() {
        return this.rotXFactor;
    }

    public double getRotYFactor() {
        return this.rotYFactor;
    }

    public double getTransXFactor() {
        return this.transXFactor;
    }

    public double getTransYFactor() {
        return this.transYFactor;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public synchronized void setRotateEnable(boolean enabled) {
        this.rotateEnabled = enabled;
    }

    public synchronized void setZoomEnable(boolean enabled) {
        this.zoomEnabled = enabled;
    }

    public synchronized void setTranslateEnable(boolean enabled) {
        this.translateEnabled = enabled;
    }

    public boolean getRotateEnable() {
        return this.rotateEnabled;
    }

    public boolean getZoomEnable() {
        return this.zoomEnabled;
    }

    public boolean getTranslateEnable() {
        return this.translateEnabled;
    }

    public synchronized void setMinRadius(double r) {
        if (r < 0.0) {
            throw new IllegalArgumentException("OrbitBehaviorPivot MinRadius < 0.0 !!");
        }
        this.minRadius = r;
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    public void setReverseTranslate(boolean state) {
        this.reverseTrans = state;
    }

    public void setReverseRotate(boolean state) {
        this.reverseRotate = state;
    }

    public void setReverseZoom(boolean state) {
        this.reverseZoom = state;
    }

    public synchronized void setProportionalZoom(boolean state) {
        this.proportionalZoom = state;
        this.zoomMul = state ? 1.0 * this.zoomFactor : 0.01 * this.zoomFactor;
    }
}

