
package org.interactivemesh.pivot.testspace.charcube;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.QuadArray;

/*
 * CubeGeometry.java
 *
 * Version: 2.0
 * Date: 2011/01/15
 *
 * Copyright (c) 2009-2011
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'CubeGeometry.java'.
 *
 */

class CubeGeometry {

    static GeometryArray create(int vertexFormat, float cubeSize) {

        float[] coords = {
            0.0f, 0.0f,  1.0f,  // back +Z
            1.0f, 0.0f,  1.0f,
            1.0f,  1.0f,  1.0f,
            0.0f,  1.0f,  1.0f,

            1.0f, 0.0f, 0.0f,       // front -Z    
            0.0f, 0.0f, 0.0f,
            0.0f,  1.0f, 0.0f,
            1.0f,  1.0f, 0.0f,

            1.0f, 0.0f,  1.0f,      // right +X
            1.0f, 0.0f, 0.0f,
            1.0f,  1.0f, 0.0f,
            1.0f,  1.0f,  1.0f,

            0.0f, 0.0f, 0.0f,   // left -X
            0.0f, 0.0f,  1.0f,
            0.0f,  1.0f,  1.0f,
            0.0f,  1.0f, 0.0f,

            0.0f,  1.0f,  1.0f, // top +Y
            1.0f,  1.0f,  1.0f,
            1.0f,  1.0f, 0.0f,
            0.0f,  1.0f, 0.0f,

            0.0f, 0.0f,  1.0f,  // bottom -Y
            0.0f, 0.0f, 0.0f,
            1.0f, 0.0f, 0.0f,
            1.0f, 0.0f,  1.0f
        };

        float[] texCoords3 = {
            0.0f, 0.0f, 1.0f,       // +Z
            1.0f, 0.0f, 1.0f,
            1.0f, 1.0f, 1.0f,
            0.0f, 1.0f, 1.0f,

            1.0f,  0.0f, -1.0f,     // -Z
            0.0f,  0.0f, -1.0f,
            0.0f,  1.0f, -1.0f,
            1.0f,  1.0f, -1.0f,

            1.0f, 0.0f, 1.0f,       // +X
            1.0f, 0.0f, 0.0f,
            1.0f, 1.0f, 0.0f,
            1.0f, 1.0f, 1.0f,

            -1.0f,  0.0f,  0.0f,    // -X
            -1.0f,  0.0f,  1.0f,
            -1.0f,  1.0f,  1.0f,
            -1.0f,  1.0f,  0.0f,

            0.0f, 1.0f, 1.0f,       // +Y
            1.0f, 1.0f, 1.0f,
            1.0f, 1.0f, 0.0f,
            0.0f, 1.0f, 0.0f,

            0.0f, -1.0f,  1.0f,     // -Y
            0.0f, -1.0f,  0.0f,
            1.0f, -1.0f,  0.0f,
            1.0f, -1.0f,  1.0f
        };

        float[] normals = {
            0.0f, 0.0f, 1.0f,       // +Z
            0.0f, 0.0f, 1.0f,
            0.0f, 0.0f, 1.0f,
            0.0f, 0.0f, 1.0f,

            0.0f,  0.0f, -1.0f,     // -Z
            0.0f,  0.0f, -1.0f,
            0.0f,  0.0f, -1.0f,
            0.0f,  0.0f, -1.0f,

            1.0f, 0.0f, 0.0f,       // +X
            1.0f, 0.0f, 0.0f,
            1.0f, 0.0f, 0.0f,
            1.0f, 0.0f, 0.0f,

            -1.0f,  0.0f,  0.0f,    // -X
            -1.0f,  0.0f,  0.0f,
            -1.0f,  0.0f,  0.0f,
            -1.0f,  0.0f,  0.0f,

            0.0f, 1.0f, 0.0f,       // +Y
            0.0f, 1.0f, 0.0f,
            0.0f, 1.0f, 0.0f,
            0.0f, 1.0f, 0.0f,

            0.0f, -1.0f,  0.0f,     // -Y
            0.0f, -1.0f,  0.0f,
            0.0f, -1.0f,  0.0f,
            0.0f, -1.0f,  0.0f
        };

        float[] colors = {
            0.0f, 0.0f,  1.0f,  // front +Z
            1.0f, 0.0f,  1.0f,
            1.0f,  1.0f,  1.0f,
            0.0f,  1.0f,  1.0f,

            1.0f, 0.0f, 0.0f,       // back -Z
            0.0f, 0.0f, 0.0f,
            0.0f,  1.0f, 0.0f,
            1.0f,  1.0f, 0.0f,

            1.0f, 0.0f,  1.0f,      // right +X
            1.0f, 0.0f, 0.0f,
            1.0f,  1.0f, 0.0f,
            1.0f,  1.0f,  1.0f,

            0.0f, 0.0f, 0.0f,   // left -X
            0.0f, 0.0f,  1.0f,
            0.0f,  1.0f,  1.0f,
            0.0f,  1.0f, 0.0f,

            0.0f,  1.0f,  1.0f, // top +Y
            1.0f,  1.0f,  1.0f,
            1.0f,  1.0f, 0.0f,
            0.0f,  1.0f, 0.0f,

            0.0f, 0.0f,  1.0f,  // bottom -Y
            0.0f, 0.0f, 0.0f,
            1.0f, 0.0f, 0.0f,
            1.0f, 0.0f,  1.0f
        };

        if (cubeSize != 1.0f) {
            for (int i=0,z=coords.length; i < z; i++) {
                if (coords[i] > 0) {
                    coords[i] = cubeSize;
                }
            }
        }

        GeometryArray geometry = new QuadArray(24, vertexFormat);

        if ((vertexFormat & GeometryArray.BY_REFERENCE) != 0) {
            geometry.setCoordRefFloat(coords);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormalRefFloat(normals);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColorRefFloat(colors);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_3) != 0)
                geometry.setTexCoordRefFloat(0, texCoords3);
        }
        else {
            geometry.setCoordinates(0, coords);
            if ((vertexFormat & GeometryArray.NORMALS) != 0)
                geometry.setNormals(0, normals);
            if ((vertexFormat & GeometryArray.COLOR_3) != 0)
                geometry.setColors(0, colors);
            if ((vertexFormat & GeometryArray.TEXTURE_COORDINATE_3) != 0)
                geometry.setTextureCoordinates(0, 0, texCoords3);
        }

        return geometry;
    }
}
