/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Color;
import java.util.Iterator;
import org.apache.pivot.json.JSON;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.ColorChooserBindingListener;
import org.apache.pivot.wtk.ColorChooserSelectionListener;
import org.apache.pivot.wtk.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorChooser
extends Container {
    private Color selectedColor = null;
    private String selectedColorKey = null;
    private BindType selectedColorBindType = BindType.BOTH;
    private SelectedColorBindMapping selectedColorBindMapping = null;
    private ColorChooserSelectionListenerList colorChooserSelectionListeners = new ColorChooserSelectionListenerList();
    private ColorChooserBindingListenerList colorChooserBindingListeners = new ColorChooserBindingListenerList();

    public ColorChooser() {
        this.installSkin(ColorChooser.class);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        Color previousSelectedColor = this.selectedColor;
        if (!(previousSelectedColor == selectedColor || previousSelectedColor != null && previousSelectedColor.equals(selectedColor))) {
            this.selectedColor = selectedColor;
            this.colorChooserSelectionListeners.selectedColorChanged(this, previousSelectedColor);
        }
    }

    public void setSelectedColor(String selectedColor) {
        if (selectedColor == null) {
            throw new IllegalArgumentException("selectedColor is null.");
        }
        this.setSelectedColor(Color.decode(selectedColor));
    }

    public String getSelectedColorKey() {
        return this.selectedColorKey;
    }

    public void setSelectedColorKey(String selectedColorKey) {
        String previousSelectedColorKey = this.selectedColorKey;
        if (selectedColorKey != previousSelectedColorKey) {
            this.selectedColorKey = selectedColorKey;
            this.colorChooserBindingListeners.selectedColorKeyChanged(this, previousSelectedColorKey);
        }
    }

    public BindType getSelectedColorBindType() {
        return this.selectedColorBindType;
    }

    public void setSelectedColorBindType(BindType selectedColorBindType) {
        if (selectedColorBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedColorBindType = this.selectedColorBindType;
        if (previousSelectedColorBindType != selectedColorBindType) {
            this.selectedColorBindType = selectedColorBindType;
            this.colorChooserBindingListeners.selectedColorBindTypeChanged(this, previousSelectedColorBindType);
        }
    }

    public SelectedColorBindMapping getSelectedColorBindMapping() {
        return this.selectedColorBindMapping;
    }

    public void setSelectedColorBindMapping(SelectedColorBindMapping selectedColorBindMapping) {
        SelectedColorBindMapping previousSelectedColorBindMapping = this.selectedColorBindMapping;
        if (previousSelectedColorBindMapping != selectedColorBindMapping) {
            this.selectedColorBindMapping = selectedColorBindMapping;
            this.colorChooserBindingListeners.selectedColorBindMappingChanged(this, previousSelectedColorBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.selectedColorKey != null && JSON.containsKey((Object)context, (String)this.selectedColorKey) && this.selectedColorBindType != BindType.STORE) {
            Object value = JSON.get((Object)context, (String)this.selectedColorKey);
            Color selectedColor = null;
            if (value instanceof Color) {
                selectedColor = (Color)value;
            } else if (this.selectedColorBindMapping == null) {
                if (value != null) {
                    selectedColor = Color.decode(value.toString());
                }
            } else {
                selectedColor = this.selectedColorBindMapping.toColor(value);
            }
            this.setSelectedColor(selectedColor);
        }
    }

    @Override
    public void store(Object context) {
        if (this.selectedColorKey != null && this.selectedColorBindType != BindType.LOAD) {
            JSON.put((Object)context, (String)this.selectedColorKey, (Object)(this.selectedColorBindMapping == null ? this.selectedColor : this.selectedColorBindMapping.valueOf(this.selectedColor)));
        }
    }

    @Override
    public void clear() {
        if (this.selectedColorKey != null) {
            this.setSelectedColor((Color)null);
        }
    }

    public ListenerList<ColorChooserSelectionListener> getColorChooserSelectionListeners() {
        return this.colorChooserSelectionListeners;
    }

    public ListenerList<ColorChooserBindingListener> getColorChooserBindingListeners() {
        return this.colorChooserBindingListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColorChooserBindingListenerList
    extends ListenerList<ColorChooserBindingListener>
    implements ColorChooserBindingListener {
        private ColorChooserBindingListenerList() {
        }

        @Override
        public void selectedColorKeyChanged(ColorChooser colorChooser, String previousSelectedColorKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ColorChooserBindingListener listener = (ColorChooserBindingListener)i$.next();
                listener.selectedColorKeyChanged(colorChooser, previousSelectedColorKey);
            }
        }

        @Override
        public void selectedColorBindTypeChanged(ColorChooser colorChooser, BindType previousSelectedColorBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ColorChooserBindingListener listener = (ColorChooserBindingListener)i$.next();
                listener.selectedColorBindTypeChanged(colorChooser, previousSelectedColorBindType);
            }
        }

        @Override
        public void selectedColorBindMappingChanged(ColorChooser colorChooser, SelectedColorBindMapping previousSelectedColorBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ColorChooserBindingListener listener = (ColorChooserBindingListener)i$.next();
                listener.selectedColorBindMappingChanged(colorChooser, previousSelectedColorBindMapping);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColorChooserSelectionListenerList
    extends ListenerList<ColorChooserSelectionListener>
    implements ColorChooserSelectionListener {
        private ColorChooserSelectionListenerList() {
        }

        @Override
        public void selectedColorChanged(ColorChooser colorChooser, Color previousSelectedColor) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ColorChooserSelectionListener listener = (ColorChooserSelectionListener)i$.next();
                listener.selectedColorChanged(colorChooser, previousSelectedColor);
            }
        }
    }

    public static interface SelectedColorBindMapping {
        public Color toColor(Object var1);

        public Object valueOf(Color var1);
    }
}

