/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.GridPaneListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="rows")
public class GridPane
extends Container {
    private int columnCount;
    private ArrayList<Row> rows = new ArrayList();
    private RowSequence rowSequence = new RowSequence();
    private GridPaneListenerList gridPaneListeners = new GridPaneListenerList();

    public GridPane() {
        this(0);
    }

    public GridPane(int columnCount) {
        if (columnCount < 0) {
            throw new IllegalArgumentException("columnCount is negative.");
        }
        this.setColumnCount(columnCount);
        this.installSkin(GridPane.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        int previousColumnCount = this.columnCount;
        if (previousColumnCount != columnCount) {
            this.columnCount = columnCount;
            this.gridPaneListeners.columnCountChanged(this, previousColumnCount);
        }
    }

    public RowSequence getRows() {
        return this.rowSequence;
    }

    public int getRowAt(int y) {
        Skin gridPaneSkin = (Skin)((Object)this.getSkin());
        return gridPaneSkin.getRowAt(y);
    }

    public Bounds getRowBounds(int row) {
        Skin gridPaneSkin = (Skin)((Object)this.getSkin());
        return gridPaneSkin.getRowBounds(row);
    }

    public int getColumnAt(int x) {
        Skin gridPaneSkin = (Skin)((Object)this.getSkin());
        return gridPaneSkin.getColumnAt(x);
    }

    public Bounds getColumnBounds(int column) {
        Skin gridPaneSkin = (Skin)((Object)this.getSkin());
        return gridPaneSkin.getColumnBounds(column);
    }

    public Component getCellComponent(int rowIndex, int columnIndex) {
        Row row = (Row)this.rows.get(rowIndex);
        Component component = null;
        if (row.getLength() > columnIndex) {
            component = row.get(columnIndex);
        }
        return component;
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            for (Row row : this.rows) {
                if (row.indexOf(component) < 0) continue;
                throw new UnsupportedOperationException();
            }
        }
        return super.remove(index, count);
    }

    public ListenerList<GridPaneListener> getGridPaneListeners() {
        return this.gridPaneListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GridPaneListenerList
    extends ListenerList<GridPaneListener>
    implements GridPaneListener {
        private GridPaneListenerList() {
        }

        @Override
        public void columnCountChanged(GridPane gridPane, int previousColumnCount) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                GridPaneListener listener = (GridPaneListener)i$.next();
                listener.columnCountChanged(gridPane, previousColumnCount);
            }
        }

        @Override
        public void rowInserted(GridPane gridPane, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                GridPaneListener listener = (GridPaneListener)i$.next();
                listener.rowInserted(gridPane, index);
            }
        }

        @Override
        public void rowsRemoved(GridPane gridPane, int index, Sequence<Row> rows) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                GridPaneListener listener = (GridPaneListener)i$.next();
                listener.rowsRemoved(gridPane, index, rows);
            }
        }

        @Override
        public void cellInserted(Row row, int column) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                GridPaneListener listener = (GridPaneListener)i$.next();
                listener.cellInserted(row, column);
            }
        }

        @Override
        public void cellsRemoved(Row row, int column, Sequence<Component> removed) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                GridPaneListener listener = (GridPaneListener)i$.next();
                listener.cellsRemoved(row, column, removed);
            }
        }

        @Override
        public void cellUpdated(Row row, int column, Component previousComponent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                GridPaneListener listener = (GridPaneListener)i$.next();
                listener.cellUpdated(row, column, previousComponent);
            }
        }
    }

    public static class Filler
    extends Component {
        public Filler() {
            this.installSkin(Filler.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class RowSequence
    implements Sequence<Row>,
    Iterable<Row> {
        private RowSequence() {
        }

        public int add(Row row) {
            int index = this.getLength();
            this.insert(row, index);
            return index;
        }

        public void insert(Row row, int index) {
            if (row == null) {
                throw new IllegalArgumentException("row is null.");
            }
            if (row.getGridPane() != null) {
                throw new IllegalArgumentException("row is already in use by another grid pane.");
            }
            GridPane.this.rows.insert((Object)row, index);
            row.gridPane = GridPane.this;
            int n = row.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = row.get(i);
                GridPane.this.add(component);
            }
            GridPane.this.gridPaneListeners.rowInserted(GridPane.this, index);
        }

        public Row update(int index, Row row) {
            throw new UnsupportedOperationException();
        }

        public int remove(Row row) {
            int index = this.indexOf(row);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Row> remove(int index, int count) {
            Sequence removed = GridPane.this.rows.remove(index, count);
            if (count > 0) {
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    Row row = (Row)removed.get(i);
                    row.gridPane = null;
                    int m = row.getLength();
                    for (int j = 0; j < m; ++j) {
                        Component component = row.get(j);
                        GridPane.this.remove(component);
                    }
                }
                GridPane.this.gridPaneListeners.rowsRemoved(GridPane.this, index, (Sequence<Row>)removed);
            }
            return removed;
        }

        public Row get(int index) {
            return (Row)GridPane.this.rows.get(index);
        }

        public int indexOf(Row row) {
            return GridPane.this.rows.indexOf((Object)row);
        }

        public int getLength() {
            return GridPane.this.rows.getLength();
        }

        @Override
        public Iterator<Row> iterator() {
            return new ImmutableIterator((Iterator)GridPane.this.rows.iterator());
        }
    }

    public static interface Skin {
        public int getRowAt(int var1);

        public Bounds getRowBounds(int var1);

        public int getColumnAt(int var1);

        public Bounds getColumnBounds(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Row
    implements Sequence<Component>,
    Iterable<Component> {
        private ArrayList<Component> cells = new ArrayList();
        private GridPane gridPane = null;

        public GridPane getGridPane() {
            return this.gridPane;
        }

        public int add(Component component) {
            int index = this.getLength();
            this.insert(component, index);
            return index;
        }

        public void insert(Component component, int index) {
            if (component == null) {
                throw new IllegalArgumentException("Component is null.");
            }
            if (component.getParent() != null) {
                throw new IllegalArgumentException("Component already has a parent.");
            }
            this.cells.insert((Object)component, index);
            if (this.gridPane != null) {
                this.gridPane.add(component);
                this.gridPane.gridPaneListeners.cellInserted(this, index);
            }
        }

        public Component update(int index, Component component) {
            Component previousComponent = (Component)this.cells.get(index);
            if (component != previousComponent) {
                if (component == null) {
                    throw new IllegalArgumentException("Component is null.");
                }
                if (component.getParent() != null) {
                    throw new IllegalArgumentException("Component already has a parent.");
                }
                this.cells.update(index, (Object)component);
                if (this.gridPane != null) {
                    this.gridPane.add(component);
                    this.gridPane.gridPaneListeners.cellUpdated(this, index, previousComponent);
                    this.gridPane.remove(previousComponent);
                }
            }
            return previousComponent;
        }

        public int remove(Component component) {
            int index = this.indexOf(component);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Component> remove(int index, int count) {
            Sequence removed = this.cells.remove(index, count);
            if (this.gridPane != null) {
                this.gridPane.gridPaneListeners.cellsRemoved(this, index, (Sequence<Component>)removed);
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    Component component = (Component)removed.get(i);
                    this.gridPane.remove(component);
                }
            }
            return removed;
        }

        public Component get(int index) {
            return (Component)this.cells.get(index);
        }

        public int indexOf(Component component) {
            return this.cells.indexOf((Object)component);
        }

        public int getLength() {
            return this.cells.getLength();
        }

        @Override
        public Iterator<Component> iterator() {
            return new ImmutableIterator((Iterator)this.cells.iterator());
        }
    }
}

