/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Insets
implements Serializable {
    private static final long serialVersionUID = -8528862892185591370L;
    public final int top;
    public final int left;
    public final int bottom;
    public final int right;
    public static final String TOP_KEY = "top";
    public static final String LEFT_KEY = "left";
    public static final String BOTTOM_KEY = "bottom";
    public static final String RIGHT_KEY = "right";
    public static final Insets NONE = new Insets(0);

    public Insets(int inset) {
        this.top = inset;
        this.left = inset;
        this.bottom = inset;
        this.right = inset;
    }

    public Insets(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public Insets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("insets is null.");
        }
        this.top = insets.top;
        this.left = insets.left;
        this.bottom = insets.bottom;
        this.right = insets.right;
    }

    public Insets(Dictionary<String, ?> insets) {
        if (insets == null) {
            throw new IllegalArgumentException("insets is null.");
        }
        this.top = insets.containsKey((Object)TOP_KEY) ? ((Number)insets.get((Object)TOP_KEY)).intValue() : 0;
        this.left = insets.containsKey((Object)LEFT_KEY) ? ((Number)insets.get((Object)LEFT_KEY)).intValue() : 0;
        this.bottom = insets.containsKey((Object)BOTTOM_KEY) ? ((Number)insets.get((Object)BOTTOM_KEY)).intValue() : 0;
        this.right = insets.containsKey((Object)RIGHT_KEY) ? ((Number)insets.get((Object)RIGHT_KEY)).intValue() : 0;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof Insets) {
            Insets insets = (Insets)object;
            equals = this.top == insets.top && this.left == insets.left && this.bottom == insets.bottom && this.right == insets.right;
        }
        return equals;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.top;
        result = 31 * result + this.left;
        result = 31 * result + this.bottom;
        result = 31 * result + this.right;
        return result;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.top + ", " + this.left + ", " + this.bottom + ", " + this.right + "]";
    }

    public static Insets decode(String value) {
        Insets insets;
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.startsWith("{")) {
            try {
                insets = new Insets((Dictionary<String, ?>)JSONSerializer.parseMap((String)value));
            }
            catch (SerializationException exception) {
                throw new IllegalArgumentException(exception);
            }
        } else {
            insets = new Insets(Integer.parseInt(value));
        }
        return insets;
    }
}

