/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.MenuItemSelectionListener;
import org.apache.pivot.wtk.MenuListener;
import org.apache.pivot.wtk.content.MenuItemDataRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="sections")
public class Menu
extends Container {
    private Item item = null;
    private ArrayList<Section> sections = new ArrayList();
    private SectionSequence sectionSequence = new SectionSequence();
    private Item activeItem = null;
    private MenuListenerList menuListeners = new MenuListenerList();
    private MenuItemSelectionListenerList menuItemSelectionListeners = new MenuItemSelectionListenerList();

    public Menu() {
        this.installSkin(Menu.class);
    }

    public Item getItem() {
        return this.item;
    }

    public SectionSequence getSections() {
        return this.sectionSequence;
    }

    public Item getActiveItem() {
        return this.activeItem;
    }

    private void setActiveItem(Item activeItem) {
        Item previousActiveItem = this.activeItem;
        if (previousActiveItem != activeItem) {
            this.activeItem = activeItem;
            this.menuListeners.activeItemChanged(this, previousActiveItem);
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            for (Section section : this.sections) {
                if (section.indexOf((Item)component) < 0) continue;
                throw new UnsupportedOperationException();
            }
        }
        return super.remove(index, count);
    }

    public ListenerList<MenuListener> getMenuListeners() {
        return this.menuListeners;
    }

    public ListenerList<MenuItemSelectionListener> getMenuItemSelectionListeners() {
        return this.menuItemSelectionListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MenuItemSelectionListenerList
    extends ListenerList<MenuItemSelectionListener>
    implements MenuItemSelectionListener {
        private MenuItemSelectionListenerList() {
        }

        @Override
        public void itemSelected(Item menuItem) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuItemSelectionListener listener = (MenuItemSelectionListener)i$.next();
                listener.itemSelected(menuItem);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MenuListenerList
    extends ListenerList<MenuListener>
    implements MenuListener {
        private MenuListenerList() {
        }

        @Override
        public void sectionInserted(Menu menu, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuListener listener = (MenuListener)i$.next();
                listener.sectionInserted(menu, index);
            }
        }

        @Override
        public void sectionsRemoved(Menu menu, int index, Sequence<Section> removed) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuListener listener = (MenuListener)i$.next();
                listener.sectionsRemoved(menu, index, removed);
            }
        }

        @Override
        public void activeItemChanged(Menu menu, Item previousActiveItem) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuListener listener = (MenuListener)i$.next();
                listener.activeItemChanged(menu, previousActiveItem);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SectionSequence
    implements Sequence<Section>,
    Iterable<Section> {
        private SectionSequence() {
        }

        public int add(Section section) {
            int index = this.getLength();
            this.insert(section, index);
            return index;
        }

        public void insert(Section section, int index) {
            if (section.menu != null) {
                throw new IllegalArgumentException("section already has a menu.");
            }
            Menu.this.sections.insert((Object)section, index);
            section.menu = Menu.this;
            int n = section.getLength();
            for (int i = 0; i < n; ++i) {
                Menu.this.add(section.get(i));
            }
            Menu.this.menuListeners.sectionInserted(Menu.this, index);
        }

        public Section update(int index, Section section) {
            throw new UnsupportedOperationException();
        }

        public int remove(Section section) {
            int index = Menu.this.sections.indexOf((Object)section);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Section> remove(int index, int count) {
            Sequence removed = Menu.this.sections.remove(index, count);
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                Section section = (Section)removed.get(i);
                section.menu = null;
                for (Item item : section) {
                    Menu.this.remove(item);
                }
            }
            Menu.this.menuListeners.sectionsRemoved(Menu.this, index, (Sequence<Section>)removed);
            return removed;
        }

        public void clear() {
            this.remove(0, Menu.this.sections.getLength());
        }

        public Section get(int index) {
            return (Section)Menu.this.sections.get(index);
        }

        public int indexOf(Section item) {
            return Menu.this.sections.indexOf((Object)item);
        }

        public int getLength() {
            return Menu.this.sections.getLength();
        }

        @Override
        public Iterator<Section> iterator() {
            return new ImmutableIterator((Iterator)Menu.this.sections.iterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SectionListener {
        public void itemInserted(Section var1, int var2);

        public void itemsRemoved(Section var1, int var2, Sequence<Item> var3);

        public void nameChanged(Section var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Section
    implements Sequence<Item>,
    Iterable<Item> {
        private Menu menu = null;
        private String name = null;
        private ArrayList<Item> items = new ArrayList();
        private SectionListenerList sectionListeners = new SectionListenerList();

        public Menu getMenu() {
            return this.menu;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String previousName = this.name;
            if (name != previousName) {
                this.name = name;
                this.sectionListeners.nameChanged(this, previousName);
            }
        }

        public int add(Item item) {
            int index = this.getLength();
            this.insert(item, index);
            return index;
        }

        public void insert(Item item, int index) {
            if (item.getSection() != null) {
                throw new IllegalArgumentException("item already has a section.");
            }
            this.items.insert((Object)item, index);
            item.section = this;
            if (this.menu != null) {
                this.menu.add(item);
                this.sectionListeners.itemInserted(this, index);
            }
        }

        public Item update(int index, Item item) {
            throw new UnsupportedOperationException();
        }

        public int remove(Item item) {
            int index = this.items.indexOf((Object)item);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Item> remove(int index, int count) {
            Sequence removed = this.items.remove(index, count);
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                Item item = (Item)removed.get(i);
                item.section = null;
                if (this.menu == null) continue;
                this.menu.remove(item);
            }
            this.sectionListeners.itemsRemoved(this, index, (Sequence<Item>)removed);
            return removed;
        }

        public Item get(int index) {
            return (Item)this.items.get(index);
        }

        public int indexOf(Item item) {
            return this.items.indexOf((Object)item);
        }

        public int getLength() {
            return this.items.getLength();
        }

        @Override
        public Iterator<Item> iterator() {
            return new ImmutableIterator((Iterator)this.items.iterator());
        }

        public ListenerList<SectionListener> getSectionListeners() {
            return this.sectionListeners;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class SectionListenerList
        extends ListenerList<SectionListener>
        implements SectionListener {
            private SectionListenerList() {
            }

            @Override
            public void itemInserted(Section section, int index) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    SectionListener listener = (SectionListener)i$.next();
                    listener.itemInserted(section, index);
                }
            }

            @Override
            public void itemsRemoved(Section section, int index, Sequence<Item> removed) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    SectionListener listener = (SectionListener)i$.next();
                    listener.itemsRemoved(section, index, removed);
                }
            }

            @Override
            public void nameChanged(Section section, String previousName) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    SectionListener listener = (SectionListener)i$.next();
                    listener.nameChanged(section, previousName);
                }
            }
        }
    }

    public static interface ItemListener {
        public void menuChanged(Item var1, Menu var2);

        public void activeChanged(Item var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @DefaultProperty(value="menu")
    public static class Item
    extends Button {
        private Section section = null;
        private Menu menu = null;
        private boolean active = false;
        private ItemListenerList itemListeners = new ItemListenerList();
        private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new MenuItemDataRenderer();

        public Item() {
            this(null);
        }

        public Item(Object buttonData) {
            super(buttonData);
            this.setDataRenderer(DEFAULT_DATA_RENDERER);
            this.installSkin(Item.class);
        }

        @Override
        protected void setParent(Container parent) {
            if (parent != null && !(parent instanceof Menu)) {
                throw new IllegalArgumentException("Parent must be an instance of " + Menu.class.getName());
            }
            this.setActive(false);
            super.setParent(parent);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (!enabled) {
                this.setActive(false);
            }
        }

        public Section getSection() {
            return this.section;
        }

        public Menu getMenu() {
            return this.menu;
        }

        public void setMenu(Menu menu) {
            if (menu != null && menu.getItem() != null) {
                throw new IllegalArgumentException("menu already belongs to an item.");
            }
            Menu previousMenu = this.menu;
            if (previousMenu != menu) {
                if (previousMenu != null) {
                    previousMenu.item = null;
                }
                if (menu != null) {
                    menu.item = this;
                }
                this.menu = menu;
                this.itemListeners.menuChanged(this, previousMenu);
            }
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            if (active && (this.getParent() == null || !this.isEnabled())) {
                throw new IllegalStateException();
            }
            if (this.active != active) {
                this.active = active;
                Menu menu = (Menu)this.getParent();
                Item activeItem = menu.getActiveItem();
                if (active) {
                    menu.setActiveItem(this);
                    if (activeItem != null) {
                        activeItem.setActive(false);
                    }
                } else if (activeItem == this) {
                    menu.setActiveItem(null);
                }
                this.itemListeners.activeChanged(this);
            }
        }

        @Override
        public void setTriState(boolean triState) {
            throw new UnsupportedOperationException("Menu items can't be tri-state.");
        }

        @Override
        public void press() {
            if (this.isToggleButton()) {
                this.setSelected(this.getButtonGroup() == null ? !this.isSelected() : true);
            }
            super.press();
            if (this.menu == null) {
                Item item = this;
                while (item != null) {
                    Menu menu = (Menu)item.getParent();
                    if (menu == null) {
                        item = null;
                        continue;
                    }
                    menu.menuItemSelectionListeners.itemSelected(this);
                    item = menu.item;
                }
            }
        }

        public ListenerList<ItemListener> getItemListeners() {
            return this.itemListeners;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ItemListenerList
        extends ListenerList<ItemListener>
        implements ItemListener {
            private ItemListenerList() {
            }

            @Override
            public void menuChanged(Item item, Menu previousMenu) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    ItemListener listener = (ItemListener)i$.next();
                    listener.menuChanged(item, previousMenu);
                }
            }

            @Override
            public void activeChanged(Item item) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    ItemListener listener = (ItemListener)i$.next();
                    listener.activeChanged(item);
                }
            }
        }
    }
}

