/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.MouseInfo;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Point;

public final class Mouse {
    private static int buttons = 0;
    private static Component capturer = null;

    public static int getButtons() {
        return buttons;
    }

    protected static void setButtons(int buttons) {
        Mouse.buttons = buttons;
    }

    public static boolean isPressed(Button button) {
        return (buttons & button.getMask()) > 0;
    }

    public static int getButtonCount() {
        return MouseInfo.getNumberOfButtons();
    }

    public static void capture(Component capturer) {
        if (capturer == null) {
            throw new IllegalArgumentException("capturer is null.");
        }
        if (!capturer.isMouseOver()) {
            throw new IllegalArgumentException("Mouse pointer is not currently over capturer.");
        }
        if (Mouse.capturer != null) {
            throw new IllegalStateException("Mouse is already captured.");
        }
        Mouse.capturer = capturer;
    }

    public static void release() {
        if (capturer == null) {
            throw new IllegalStateException("Mouse is not currently captured.");
        }
        Display display = capturer.getDisplay();
        Point location = display.getMouseLocation();
        Component descendant = null;
        if (location != null) {
            descendant = display.getDescendantAt(location.x, location.y);
        }
        while (descendant != null && descendant != capturer) {
            descendant = descendant.getParent();
        }
        if (descendant == null) {
            capturer.mouseOut();
            Mouse.setCursor(display);
            if (location != null) {
                display.mouseMove(location.x, location.y);
            }
        }
        capturer = null;
    }

    public static Component getCapturer() {
        return capturer;
    }

    public static Cursor getCursor() {
        if (capturer == null) {
            throw new IllegalStateException("Mouse is not currently captured.");
        }
        Cursor cursor = null;
        Display display = capturer.getDisplay();
        ApplicationContext.DisplayHost displayHost = display.getDisplayHost();
        int cursorID = displayHost.getCursor().getType();
        switch (cursorID) {
            case 0: {
                cursor = Cursor.DEFAULT;
                break;
            }
            case 12: {
                cursor = Cursor.HAND;
                break;
            }
            case 2: {
                cursor = Cursor.TEXT;
                break;
            }
            case 3: {
                cursor = Cursor.WAIT;
                break;
            }
            case 1: {
                cursor = Cursor.CROSSHAIR;
                break;
            }
            case 13: {
                cursor = Cursor.MOVE;
                break;
            }
            case 8: {
                cursor = Cursor.RESIZE_NORTH;
                break;
            }
            case 9: {
                cursor = Cursor.RESIZE_SOUTH;
                break;
            }
            case 11: {
                cursor = Cursor.RESIZE_EAST;
                break;
            }
            case 10: {
                cursor = Cursor.RESIZE_WEST;
                break;
            }
            case 7: {
                cursor = Cursor.RESIZE_NORTH_EAST;
                break;
            }
            case 4: {
                cursor = Cursor.RESIZE_SOUTH_WEST;
                break;
            }
            case 6: {
                cursor = Cursor.RESIZE_NORTH_WEST;
                break;
            }
            case 5: {
                cursor = Cursor.RESIZE_SOUTH_EAST;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return cursor;
    }

    public static void setCursor(Cursor cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("cursor is null.");
        }
        if (capturer == null) {
            throw new IllegalStateException("Mouse is not currently captured.");
        }
        Display display = capturer.getDisplay();
        ApplicationContext.DisplayHost displayHost = display.getDisplayHost();
        displayHost.setCursor(Mouse.getCursor(cursor));
    }

    public static void setCursor(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component is null.");
        }
        if (!component.isVisible()) {
            throw new IllegalArgumentException("component is not visible.");
        }
        Cursor cursor = null;
        if (component.isEnabled()) {
            cursor = component.getCursor();
            while (cursor == null && component != null && !(component instanceof Display)) {
                if ((component = component.getParent()) == null) continue;
                cursor = component.getCursor();
            }
        }
        if (component != null) {
            Display display = component.getDisplay();
            ApplicationContext.DisplayHost displayHost = display.getDisplayHost();
            displayHost.setCursor(cursor == null ? java.awt.Cursor.getDefaultCursor() : Mouse.getCursor(cursor));
        }
    }

    private static java.awt.Cursor getCursor(Cursor cursor) {
        int cursorID = -1;
        switch (cursor) {
            case DEFAULT: {
                cursorID = 0;
                break;
            }
            case HAND: {
                cursorID = 12;
                break;
            }
            case TEXT: {
                cursorID = 2;
                break;
            }
            case WAIT: {
                cursorID = 3;
                break;
            }
            case CROSSHAIR: {
                cursorID = 1;
                break;
            }
            case MOVE: {
                cursorID = 13;
                break;
            }
            case RESIZE_NORTH: {
                cursorID = 8;
                break;
            }
            case RESIZE_SOUTH: {
                cursorID = 9;
                break;
            }
            case RESIZE_EAST: {
                cursorID = 11;
                break;
            }
            case RESIZE_WEST: {
                cursorID = 10;
                break;
            }
            case RESIZE_NORTH_EAST: {
                cursorID = 7;
                break;
            }
            case RESIZE_SOUTH_WEST: {
                cursorID = 4;
                break;
            }
            case RESIZE_NORTH_WEST: {
                cursorID = 6;
                break;
            }
            case RESIZE_SOUTH_EAST: {
                cursorID = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new java.awt.Cursor(cursorID);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScrollType {
        UNIT,
        BLOCK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Button {
        LEFT,
        RIGHT,
        MIDDLE;


        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

