/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.font.FontRenderContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Keyboard;

public class Platform {
    private static FontRenderContext fontRenderContext;
    private static final int DEFAULT_MULTI_CLICK_INTERVAL = 400;
    private static final int DEFAULT_CURSOR_BLINK_RATE = 600;
    private static final Keyboard.Modifier COMMAND_MODIFIER;
    private static final Keyboard.Modifier WORD_NAVIGATION_MODIFIER;
    private static final String KEYSTROKE_MODIFIER_SEPARATOR;

    public static FontRenderContext getFontRenderContext() {
        return fontRenderContext;
    }

    private static void initializeFontRenderContext() {
        Object aaHint = null;
        Object fmHint = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Map fontDesktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
        if (fontDesktopHints != null) {
            aaHint = fontDesktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            fmHint = fontDesktopHints.get(RenderingHints.KEY_FRACTIONALMETRICS);
        }
        if (aaHint == null) {
            aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
        }
        if (fmHint == null) {
            fmHint = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
        }
        fontRenderContext = new FontRenderContext(null, aaHint, fmHint);
    }

    public static int getMultiClickInterval() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Integer multiClickInterval = (Integer)toolkit.getDesktopProperty("awt.multiClickInterval");
        if (multiClickInterval == null) {
            multiClickInterval = 400;
        }
        return multiClickInterval;
    }

    public static int getCursorBlinkRate() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Integer cursorBlinkRate = (Integer)toolkit.getDesktopProperty("awt.cursorBlinkRate");
        if (cursorBlinkRate == null) {
            cursorBlinkRate = 600;
        }
        return cursorBlinkRate;
    }

    public static int getDragThreshold() {
        return DragSource.getDragThreshold();
    }

    public static Keyboard.Modifier getCommandModifier() {
        return COMMAND_MODIFIER;
    }

    public static Keyboard.Modifier getWordNavigationModifier() {
        return WORD_NAVIGATION_MODIFIER;
    }

    public static String getKeyStrokeModifierSeparator() {
        return KEYSTROKE_MODIFIER_SEPARATOR;
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (osName.startsWith("mac os x")) {
            COMMAND_MODIFIER = Keyboard.Modifier.META;
            WORD_NAVIGATION_MODIFIER = Keyboard.Modifier.ALT;
            KEYSTROKE_MODIFIER_SEPARATOR = "";
        } else {
            COMMAND_MODIFIER = Keyboard.Modifier.CTRL;
            WORD_NAVIGATION_MODIFIER = Keyboard.Modifier.CTRL;
            KEYSTROKE_MODIFIER_SEPARATOR = "-";
        }
        Platform.initializeFontRenderContext();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Platform.initializeFontRenderContext();
                ApplicationContext.invalidateDisplays();
            }
        });
    }
}

