/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.pivot.io.FileList;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.media.Picture;

public class RemoteManifest
implements Manifest {
    private Transferable transferable;
    private DataFlavor textDataFlavor = null;
    private DataFlavor imageDataFlavor = null;
    private DataFlavor fileListDataFlavor = null;
    private DataFlavor uriListDataFlavor = null;
    private static final String URI_LIST_MIME_TYPE = "text/uri-list";
    private static final String FILE_URI_SCHEME = "file";

    RemoteManifest(Transferable transferable) {
        assert (transferable != null);
        this.transferable = transferable;
        DataFlavor[] transferDataFlavors = transferable.getTransferDataFlavors();
        if (transferDataFlavors != null) {
            for (DataFlavor dataFlavor : transferDataFlavors) {
                if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                    this.textDataFlavor = dataFlavor;
                    continue;
                }
                if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                    this.imageDataFlavor = dataFlavor;
                    continue;
                }
                if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                    this.fileListDataFlavor = dataFlavor;
                    continue;
                }
                if (!dataFlavor.getMimeType().startsWith(URI_LIST_MIME_TYPE) || dataFlavor.getRepresentationClass() != String.class) continue;
                this.uriListDataFlavor = dataFlavor;
            }
        }
    }

    public String getText() throws IOException {
        String text = null;
        try {
            text = (String)this.transferable.getTransferData(this.textDataFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        return text;
    }

    public boolean containsText() {
        return this.textDataFlavor != null;
    }

    public Image getImage() throws IOException {
        Picture image = null;
        try {
            image = new Picture((BufferedImage)this.transferable.getTransferData(this.imageDataFlavor));
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        return image;
    }

    public boolean containsImage() {
        return this.imageDataFlavor != null;
    }

    public FileList getFileList() throws IOException {
        FileList fileList;
        block7: {
            fileList = null;
            try {
                if (this.fileListDataFlavor != null) {
                    fileList = new FileList((List)this.transferable.getTransferData(this.fileListDataFlavor));
                    break block7;
                }
                if (this.uriListDataFlavor == null) break block7;
                fileList = new FileList();
                String uriList = (String)this.transferable.getTransferData(this.uriListDataFlavor);
                LineNumberReader reader = new LineNumberReader(new StringReader(uriList));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        URI uri = new URI(line);
                        String scheme = uri.getScheme();
                        if (scheme != null && scheme.equalsIgnoreCase(FILE_URI_SCHEME)) {
                            File file = new File(uri);
                            fileList.add(file);
                        }
                        line = reader.readLine();
                    }
                }
                catch (URISyntaxException exception) {
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        return fileList;
    }

    public boolean containsFileList() {
        return this.fileListDataFlavor != null || this.uriListDataFlavor != null;
    }

    public Object getValue(String key) {
        return null;
    }

    public boolean containsValue(String key) {
        return false;
    }
}

