/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.SheetCloseListener;
import org.apache.pivot.wtk.SheetStateListener;
import org.apache.pivot.wtk.Window;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sheet
extends Window {
    private SheetCloseListener sheetCloseListener = null;
    private boolean result = false;
    private boolean closing = false;
    private SheetStateListenerList sheetStateListeners = new SheetStateListenerList();

    public Sheet() {
        this(null);
    }

    public Sheet(Component content) {
        super(content);
        this.installSkin(Sheet.class);
    }

    public final void open(Window owner, SheetCloseListener sheetCloseListener) {
        if (owner == null) {
            throw new IllegalArgumentException("owner is null");
        }
        this.open(owner.getDisplay(), owner, sheetCloseListener);
    }

    @Override
    public final void open(Display display, Window owner) {
        this.open(display, owner, null);
    }

    public void open(Display display, Window owner, SheetCloseListener sheetCloseListener) {
        if (owner == null) {
            throw new IllegalArgumentException("Sheets must have an owner.");
        }
        this.sheetCloseListener = sheetCloseListener;
        super.open(display, owner);
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public final void close() {
        this.close(false);
    }

    public void close(boolean result) {
        if (!this.isClosed()) {
            this.closing = true;
            Vote vote = this.sheetStateListeners.previewSheetClose(this, result);
            if (vote == Vote.APPROVE) {
                Window owner = this.getOwner();
                super.close();
                this.closing = super.isClosing();
                if (this.isClosed()) {
                    this.result = result;
                    if (owner.isOpen()) {
                        owner.moveToFront();
                    }
                    this.sheetStateListeners.sheetClosed(this);
                    if (this.sheetCloseListener != null) {
                        this.sheetCloseListener.sheetClosed(this);
                        this.sheetCloseListener = null;
                    }
                }
            } else {
                if (vote == Vote.DENY) {
                    this.closing = false;
                }
                this.sheetStateListeners.sheetCloseVetoed(this, vote);
            }
        }
    }

    public SheetCloseListener getSheetCloseListener() {
        return this.sheetCloseListener;
    }

    public boolean getResult() {
        return this.result;
    }

    public ListenerList<SheetStateListener> getSheetStateListeners() {
        return this.sheetStateListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SheetStateListenerList
    extends ListenerList<SheetStateListener>
    implements SheetStateListener {
        private SheetStateListenerList() {
        }

        @Override
        public Vote previewSheetClose(Sheet sheet, boolean result) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SheetStateListener listener = (SheetStateListener)i$.next();
                vote = vote.tally(listener.previewSheetClose(sheet, result));
            }
            return vote;
        }

        @Override
        public void sheetCloseVetoed(Sheet sheet, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SheetStateListener listener = (SheetStateListener)i$.next();
                listener.sheetCloseVetoed(sheet, reason);
            }
        }

        @Override
        public void sheetClosed(Sheet sheet) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SheetStateListener listener = (SheetStateListener)i$.next();
                listener.sheetClosed(sheet);
            }
        }
    }
}

