/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.json.JSON;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Limits;
import org.apache.pivot.wtk.RangeSelection;
import org.apache.pivot.wtk.Renderer;
import org.apache.pivot.wtk.SortDirection;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TableViewBindingListener;
import org.apache.pivot.wtk.TableViewColumnListener;
import org.apache.pivot.wtk.TableViewHeader;
import org.apache.pivot.wtk.TableViewListener;
import org.apache.pivot.wtk.TableViewRowListener;
import org.apache.pivot.wtk.TableViewSelectionListener;
import org.apache.pivot.wtk.TableViewSortListener;
import org.apache.pivot.wtk.content.TableViewCellRenderer;
import org.apache.pivot.wtk.content.TableViewHeaderDataRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="tableData")
public class TableView
extends Component {
    private ArrayList<Column> columns = new ArrayList();
    private ColumnSequence columnSequence = new ColumnSequence();
    private List<?> tableData = null;
    private TableView columnSource = null;
    private RowEditor rowEditor = null;
    private RangeSelection rangeSelection = new RangeSelection();
    private SelectMode selectMode = SelectMode.SINGLE;
    private HashMap<String, SortDirection> sortMap = new HashMap();
    private ArrayList<String> sortList = new ArrayList();
    private SortDictionary sortDictionary = new SortDictionary();
    private Filter<?> disabledRowFilter = null;
    private String tableDataKey = null;
    private BindType tableDataBindType = BindType.BOTH;
    private TableDataBindMapping tableDataBindMapping = null;
    private String selectedRowKey = null;
    private BindType selectedRowBindType = BindType.BOTH;
    private SelectedRowBindMapping selectedRowBindMapping = null;
    private String selectedRowsKey = null;
    private BindType selectedRowsBindType = BindType.BOTH;
    private SelectedRowBindMapping selectedRowsBindMapping = null;
    private ListListener<Object> tableDataListener = new ListListener<Object>(){

        public void itemInserted(List<Object> list, int index) {
            int updated = TableView.this.rangeSelection.insertIndex(index);
            TableView.this.tableViewRowListeners.rowInserted(TableView.this, index);
            if (updated > 0) {
                TableView.this.tableViewSelectionListeners.selectedRangesChanged(TableView.this, (Sequence<Span>)TableView.this.getSelectedRanges());
            }
        }

        public void itemsRemoved(List<Object> list, int index, Sequence<Object> items) {
            int count = items.getLength();
            int previousSelectedIndex = TableView.this.selectMode == SelectMode.SINGLE && TableView.this.rangeSelection.getLength() > 0 ? ((TableView)TableView.this).rangeSelection.get((int)0).start : -1;
            int updated = TableView.this.rangeSelection.removeIndexes(index, count);
            TableView.this.tableViewRowListeners.rowsRemoved(TableView.this, index, count);
            if (updated > 0) {
                TableView.this.tableViewSelectionListeners.selectedRangesChanged(TableView.this, (Sequence<Span>)TableView.this.getSelectedRanges());
                if (TableView.this.selectMode == SelectMode.SINGLE && TableView.this.getSelectedIndex() != previousSelectedIndex) {
                    TableView.this.tableViewSelectionListeners.selectedRowChanged(TableView.this, null);
                }
            }
        }

        public void itemUpdated(List<Object> list, int index, Object previousItem) {
            TableView.this.tableViewRowListeners.rowUpdated(TableView.this, index);
        }

        public void listCleared(List<Object> list) {
            int cleared = TableView.this.rangeSelection.getLength();
            TableView.this.rangeSelection.clear();
            TableView.this.tableViewRowListeners.rowsCleared(TableView.this);
            if (cleared > 0) {
                TableView.this.tableViewSelectionListeners.selectedRangesChanged(TableView.this, (Sequence<Span>)TableView.this.getSelectedRanges());
                if (TableView.this.selectMode == SelectMode.SINGLE) {
                    TableView.this.tableViewSelectionListeners.selectedRowChanged(TableView.this, null);
                }
            }
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> previousComparator) {
            if (list.getComparator() != null) {
                int cleared = TableView.this.rangeSelection.getLength();
                TableView.this.rangeSelection.clear();
                TableView.this.tableViewRowListeners.rowsSorted(TableView.this);
                if (cleared > 0) {
                    TableView.this.tableViewSelectionListeners.selectedRangesChanged(TableView.this, (Sequence<Span>)TableView.this.getSelectedRanges());
                    if (TableView.this.selectMode == SelectMode.SINGLE) {
                        TableView.this.tableViewSelectionListeners.selectedRowChanged(TableView.this, null);
                    }
                }
            }
        }
    };
    private TableViewListenerList tableViewListeners = new TableViewListenerList();
    private TableViewColumnListenerList tableViewColumnListeners = new TableViewColumnListenerList();
    private TableViewRowListenerList tableViewRowListeners = new TableViewRowListenerList();
    private TableViewSelectionListenerList tableViewSelectionListeners = new TableViewSelectionListenerList();
    private TableViewSortListenerList tableViewSortListeners = new TableViewSortListenerList();
    private TableViewBindingListenerList tableViewBindingListeners = new TableViewBindingListenerList();
    public static final String COLUMN_NAME_KEY = "columnName";
    public static final String SORT_DIRECTION_KEY = "sortDirection";

    public TableView() {
        this((List<?>)new ArrayList());
    }

    public TableView(List<?> tableData) {
        this.setTableData(tableData);
        this.installSkin(TableView.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public ColumnSequence getColumns() {
        ColumnSequence columnSequence = this.columnSequence;
        if (this.columnSource != null) {
            columnSequence = this.columnSource.getColumns();
        }
        return columnSequence;
    }

    public List<?> getTableData() {
        return this.tableData;
    }

    public void setTableData(List<?> tableData) {
        if (tableData == null) {
            throw new IllegalArgumentException("tableData is null.");
        }
        List<?> previousTableData = this.tableData;
        if (previousTableData != tableData) {
            int cleared;
            if (previousTableData != null) {
                cleared = this.rangeSelection.getLength();
                this.rangeSelection.clear();
                previousTableData.getListListeners().remove(this.tableDataListener);
            } else {
                cleared = 0;
            }
            tableData.getListListeners().add(this.tableDataListener);
            this.tableData = tableData;
            this.tableViewListeners.tableDataChanged(this, previousTableData);
            if (cleared > 0) {
                this.tableViewSelectionListeners.selectedRangesChanged(this, (Sequence<Span>)this.getSelectedRanges());
                if (this.selectMode == SelectMode.SINGLE) {
                    this.tableViewSelectionListeners.selectedRowChanged(this, null);
                }
            }
        }
    }

    public final void setTableData(String tableData) {
        if (tableData == null) {
            throw new IllegalArgumentException("tableData is null.");
        }
        try {
            this.setTableData(JSONSerializer.parseList((String)tableData));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public void setTableData(URL tableData) {
        if (tableData == null) {
            throw new IllegalArgumentException("tableData is null.");
        }
        JSONSerializer jsonSerializer = new JSONSerializer();
        try {
            this.setTableData((List)jsonSerializer.readObject(tableData.openStream()));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public TableView getColumnSource() {
        return this.columnSource;
    }

    public void setColumnSource(TableView columnSource) {
        TableView previousColumnSource = this.columnSource;
        if (previousColumnSource != columnSource) {
            this.columnSource = columnSource;
            this.tableViewListeners.columnSourceChanged(this, previousColumnSource);
        }
    }

    public RowEditor getRowEditor() {
        return this.rowEditor;
    }

    public void setRowEditor(RowEditor rowEditor) {
        RowEditor previousRowEditor = this.rowEditor;
        if (previousRowEditor != rowEditor) {
            this.rowEditor = rowEditor;
            this.tableViewListeners.rowEditorChanged(this, previousRowEditor);
        }
    }

    public int getSelectedIndex() {
        if (this.selectMode != SelectMode.SINGLE) {
            throw new IllegalStateException("Table view is not in single-select mode.");
        }
        return this.rangeSelection.getLength() == 0 ? -1 : this.rangeSelection.get((int)0).start;
    }

    public void setSelectedIndex(int index) {
        if (index == -1) {
            this.clearSelection();
        } else {
            this.setSelectedRange(index, index);
        }
    }

    public void setSelectedRange(int start, int end) {
        ArrayList selectedRanges = new ArrayList();
        selectedRanges.add((Object)new Span(start, end));
        this.setSelectedRanges((Sequence<Span>)selectedRanges);
    }

    public ImmutableList<Span> getSelectedRanges() {
        return this.rangeSelection.getSelectedRanges();
    }

    public Sequence<Span> setSelectedRanges(Sequence<Span> selectedRanges) {
        if (selectedRanges == null) {
            throw new IllegalArgumentException("selectedRanges is null.");
        }
        if (this.selectMode == SelectMode.NONE && selectedRanges.getLength() > 0) {
            throw new IllegalArgumentException("Selection is not enabled.");
        }
        ImmutableList<Span> previousSelectedRanges = this.rangeSelection.getSelectedRanges();
        Object previousSelectedRow = this.selectMode == SelectMode.SINGLE ? this.getSelectedRow() : null;
        RangeSelection listSelection = new RangeSelection();
        int n = selectedRanges.getLength();
        for (int i = 0; i < n; ++i) {
            Span range = (Span)selectedRanges.get(i);
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            if (range.start < 0 || range.end >= this.tableData.getLength()) {
                throw new IndexOutOfBoundsException();
            }
            listSelection.addRange(range.start, range.end);
        }
        this.rangeSelection = listSelection;
        this.tableViewSelectionListeners.selectedRangesChanged(this, (Sequence<Span>)previousSelectedRanges);
        if (this.selectMode == SelectMode.SINGLE) {
            this.tableViewSelectionListeners.selectedRowChanged(this, previousSelectedRow);
        }
        return this.getSelectedRanges();
    }

    public final Sequence<Span> setSelectedRanges(String selectedRanges) {
        if (selectedRanges == null) {
            throw new IllegalArgumentException("selectedRanges is null.");
        }
        try {
            this.setSelectedRanges(this.parseSelectedRanges(selectedRanges));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
        return this.getSelectedRanges();
    }

    private Sequence<Span> parseSelectedRanges(String json) throws SerializationException {
        ArrayList selectedRanges = new ArrayList();
        List list = JSONSerializer.parseList((String)json);
        for (Object item : list) {
            Map map = (Map)item;
            selectedRanges.add((Object)new Span((Dictionary<String, ?>)map));
        }
        return selectedRanges;
    }

    public int getFirstSelectedIndex() {
        return this.rangeSelection.getLength() > 0 ? this.rangeSelection.get((int)0).start : -1;
    }

    public int getLastSelectedIndex() {
        return this.rangeSelection.getLength() > 0 ? this.rangeSelection.get((int)(this.rangeSelection.getLength() - 1)).end : -1;
    }

    public boolean addSelectedIndex(int index) {
        Sequence<Span> addedRanges = this.addSelectedRange(index, index);
        return addedRanges.getLength() > 0;
    }

    public Sequence<Span> addSelectedRange(int start, int end) {
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("Table view is not in multi-select mode.");
        }
        if (start < 0 || end >= this.tableData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Sequence<Span> addedRanges = this.rangeSelection.addRange(start, end);
        int n = addedRanges.getLength();
        for (int i = 0; i < n; ++i) {
            Span addedRange = (Span)addedRanges.get(i);
            this.tableViewSelectionListeners.selectedRangeAdded(this, addedRange.start, addedRange.end);
        }
        if (n > 0) {
            this.tableViewSelectionListeners.selectedRangesChanged(this, null);
        }
        return addedRanges;
    }

    public Sequence<Span> addSelectedRange(Span range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null.");
        }
        return this.addSelectedRange(range.start, range.end);
    }

    public boolean removeSelectedIndex(int index) {
        Sequence<Span> removedRanges = this.removeSelectedRange(index, index);
        return removedRanges.getLength() > 0;
    }

    public Sequence<Span> removeSelectedRange(int start, int end) {
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("Table view is not in multi-select mode.");
        }
        if (start < 0 || end >= this.tableData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Sequence<Span> removedRanges = this.rangeSelection.removeRange(start, end);
        int n = removedRanges.getLength();
        for (int i = 0; i < n; ++i) {
            Span removedRange = (Span)removedRanges.get(i);
            this.tableViewSelectionListeners.selectedRangeRemoved(this, removedRange.start, removedRange.end);
        }
        if (n > 0) {
            this.tableViewSelectionListeners.selectedRangesChanged(this, null);
        }
        return removedRanges;
    }

    public Sequence<Span> removeSelectedRange(Span range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null.");
        }
        return this.removeSelectedRange(range.start, range.end);
    }

    public void selectAll() {
        this.setSelectedRange(0, this.tableData.getLength() - 1);
    }

    public void clearSelection() {
        if (this.rangeSelection.getLength() > 0) {
            this.setSelectedRanges((Sequence<Span>)new ArrayList(0));
        }
    }

    public boolean isRowSelected(int index) {
        if (index < 0 || index >= this.tableData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return this.rangeSelection.containsIndex(index);
    }

    public Object getSelectedRow() {
        int index = this.getSelectedIndex();
        Object row = null;
        if (index >= 0) {
            row = this.tableData.get(index);
        }
        return row;
    }

    public void setSelectedRow(Object row) {
        this.setSelectedIndex(row == null ? -1 : this.tableData.indexOf(row));
    }

    public Sequence<?> getSelectedRows() {
        ArrayList rows = new ArrayList();
        int n = this.rangeSelection.getLength();
        for (int i = 0; i < n; ++i) {
            Span range = this.rangeSelection.get(i);
            for (int index = range.start; index <= range.end; ++index) {
                Object row = this.tableData.get(index);
                rows.add(row);
            }
        }
        return rows;
    }

    public void setSelectedRows(Sequence<Object> rows) {
        if (rows == null) {
            throw new IllegalArgumentException();
        }
        ArrayList selectedRanges = new ArrayList();
        int n = rows.getLength();
        for (int i = 0; i < n; ++i) {
            Object row = rows.get(i);
            if (row == null) {
                throw new IllegalArgumentException("item is null");
            }
            int index = this.tableData.indexOf(row);
            if (index == -1) {
                throw new IllegalArgumentException("\"" + row + "\" is not a valid selection.");
            }
            selectedRanges.add((Object)new Span(index));
        }
        this.setSelectedRanges((Sequence<Span>)selectedRanges);
    }

    public SelectMode getSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(SelectMode selectMode) {
        if (selectMode == null) {
            throw new IllegalArgumentException("selectMode is null.");
        }
        SelectMode previousSelectMode = this.selectMode;
        if (previousSelectMode != selectMode) {
            this.clearSelection();
            this.selectMode = selectMode;
            this.tableViewListeners.selectModeChanged(this, previousSelectMode);
        }
    }

    public SortDictionary getSort() {
        return this.sortDictionary;
    }

    public Dictionary<String, SortDirection> setSort(String columnName, SortDirection sortDirection) {
        Dictionary.Pair sort = new Dictionary.Pair((Object)columnName, (Object)sortDirection);
        this.setSort((Sequence<Dictionary.Pair<String, SortDirection>>)new ArrayList((Object[])new Dictionary.Pair[]{sort}));
        return this.getSort();
    }

    public Dictionary<String, SortDirection> setSort(Sequence<Dictionary.Pair<String, SortDirection>> sort) {
        if (sort == null) {
            throw new IllegalArgumentException();
        }
        this.sortMap.clear();
        this.sortList.clear();
        int n = sort.getLength();
        for (int i = 0; i < n; ++i) {
            Dictionary.Pair pair = (Dictionary.Pair)sort.get(i);
            if (this.sortMap.containsKey(pair.key)) continue;
            this.sortMap.put(pair.key, pair.value);
            this.sortList.add(pair.key);
        }
        this.tableViewSortListeners.sortChanged(this);
        return this.getSort();
    }

    public final Dictionary<String, SortDirection> setSort(String sort) {
        if (sort == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.setSort(this.parseSort(sort));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
        return this.getSort();
    }

    private Sequence<Dictionary.Pair<String, SortDirection>> parseSort(String json) throws SerializationException {
        ArrayList sort = new ArrayList();
        List list = JSONSerializer.parseList((String)json);
        for (Object item : list) {
            Map map = (Map)item;
            Dictionary.Pair pair = new Dictionary.Pair((Object)((String)map.get((Object)COLUMN_NAME_KEY)), (Object)SortDirection.valueOf(((String)map.get((Object)SORT_DIRECTION_KEY)).toUpperCase(Locale.ENGLISH)));
            sort.add((Object)pair);
        }
        return sort;
    }

    public void clearSort() {
        if (!this.sortMap.isEmpty()) {
            this.sortMap.clear();
            this.sortList.clear();
            this.tableViewSortListeners.sortChanged(this);
        }
    }

    public boolean isRowDisabled(int index) {
        boolean disabled = false;
        if (this.disabledRowFilter != null) {
            Object row = this.tableData.get(index);
            disabled = this.disabledRowFilter.include(row);
        }
        return disabled;
    }

    public Filter<?> getDisabledRowFilter() {
        return this.disabledRowFilter;
    }

    public void setDisabledRowFilter(Filter<?> disabledRowFilter) {
        Filter<?> previousDisabledRowFilter = this.disabledRowFilter;
        if (previousDisabledRowFilter != disabledRowFilter) {
            this.disabledRowFilter = disabledRowFilter;
            this.tableViewListeners.disabledRowFilterChanged(this, previousDisabledRowFilter);
        }
    }

    public String getTableDataKey() {
        return this.tableDataKey;
    }

    public void setTableDataKey(String tableDataKey) {
        String previousTableDataKey = this.tableDataKey;
        if (previousTableDataKey != tableDataKey) {
            this.tableDataKey = tableDataKey;
            this.tableViewBindingListeners.tableDataKeyChanged(this, previousTableDataKey);
        }
    }

    public BindType getTableDataBindType() {
        return this.tableDataBindType;
    }

    public void setTableDataBindType(BindType tableDataBindType) {
        if (tableDataBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousTableDataBindType = this.tableDataBindType;
        if (previousTableDataBindType != tableDataBindType) {
            this.tableDataBindType = tableDataBindType;
            this.tableViewBindingListeners.tableDataBindTypeChanged(this, previousTableDataBindType);
        }
    }

    public TableDataBindMapping getTableDataBindMapping() {
        return this.tableDataBindMapping;
    }

    public void setTableDataBindMapping(TableDataBindMapping tableDataBindMapping) {
        TableDataBindMapping previousTableDataBindMapping = this.tableDataBindMapping;
        if (previousTableDataBindMapping != tableDataBindMapping) {
            this.tableDataBindMapping = tableDataBindMapping;
            this.tableViewBindingListeners.tableDataBindMappingChanged(this, previousTableDataBindMapping);
        }
    }

    public String getSelectedRowKey() {
        return this.selectedRowKey;
    }

    public void setSelectedRowKey(String selectedRowKey) {
        String previousSelectedRowKey = this.selectedRowKey;
        if (previousSelectedRowKey != selectedRowKey) {
            this.selectedRowKey = selectedRowKey;
            this.tableViewBindingListeners.selectedRowKeyChanged(this, previousSelectedRowKey);
        }
    }

    public BindType getSelectedRowBindType() {
        return this.selectedRowBindType;
    }

    public void setSelectedRowBindType(BindType selectedRowBindType) {
        if (selectedRowBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedRowBindType = this.selectedRowBindType;
        if (previousSelectedRowBindType != selectedRowBindType) {
            this.selectedRowBindType = selectedRowBindType;
            this.tableViewBindingListeners.selectedRowBindTypeChanged(this, previousSelectedRowBindType);
        }
    }

    public SelectedRowBindMapping getSelectedRowBindMapping() {
        return this.selectedRowBindMapping;
    }

    public void setSelectedRowBindMapping(SelectedRowBindMapping selectedRowBindMapping) {
        SelectedRowBindMapping previousSelectedRowBindMapping = this.selectedRowBindMapping;
        if (previousSelectedRowBindMapping != selectedRowBindMapping) {
            this.selectedRowBindMapping = selectedRowBindMapping;
            this.tableViewBindingListeners.selectedRowBindMappingChanged(this, previousSelectedRowBindMapping);
        }
    }

    public String getSelectedRowsKey() {
        return this.selectedRowsKey;
    }

    public void setSelectedRowsKey(String selectedRowsKey) {
        String previousSelectedRowsKey = this.selectedRowsKey;
        if (previousSelectedRowsKey != selectedRowsKey) {
            this.selectedRowsKey = selectedRowsKey;
            this.tableViewBindingListeners.selectedRowsKeyChanged(this, previousSelectedRowsKey);
        }
    }

    public BindType getSelectedRowsBindType() {
        return this.selectedRowsBindType;
    }

    public void setSelectedRowsBindType(BindType selectedRowsBindType) {
        if (selectedRowsBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedRowsBindType = this.selectedRowsBindType;
        if (previousSelectedRowsBindType != selectedRowsBindType) {
            this.selectedRowsBindType = selectedRowsBindType;
            this.tableViewBindingListeners.selectedRowsBindTypeChanged(this, previousSelectedRowsBindType);
        }
    }

    public SelectedRowBindMapping getSelectedRowsBindMapping() {
        return this.selectedRowsBindMapping;
    }

    public void setSelectedRowsBindMapping(SelectedRowBindMapping selectedRowsBindMapping) {
        SelectedRowBindMapping previousSelectedRowsBindMapping = this.selectedRowsBindMapping;
        if (previousSelectedRowsBindMapping != selectedRowsBindMapping) {
            this.selectedRowsBindMapping = selectedRowsBindMapping;
            this.tableViewBindingListeners.selectedRowsBindMappingChanged(this, previousSelectedRowsBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.tableDataKey != null && this.tableDataBindType != BindType.STORE && JSON.containsKey((Object)context, (String)this.tableDataKey)) {
            Object value = JSON.get((Object)context, (String)this.tableDataKey);
            List<?> tableData = this.tableDataBindMapping == null ? (List<?>)value : this.tableDataBindMapping.toTableData(value);
            this.setTableData(tableData);
        }
        switch (this.selectMode) {
            case SINGLE: {
                if (this.selectedRowKey == null || this.selectedRowBindType == BindType.STORE || !JSON.containsKey((Object)context, (String)this.selectedRowKey)) break;
                Object row = JSON.get((Object)context, (String)this.selectedRowKey);
                int index = this.selectedRowBindMapping == null ? this.tableData.indexOf(row) : this.selectedRowBindMapping.indexOf(this.tableData, row);
                this.setSelectedIndex(index);
                break;
            }
            case MULTI: {
                if (this.selectedRowsKey == null || this.selectedRowsBindType == BindType.STORE || !JSON.containsKey((Object)context, (String)this.selectedRowsKey)) break;
                Sequence rows = (Sequence)JSON.get((Object)context, (String)this.selectedRowsKey);
                this.clearSelection();
                int n = rows.getLength();
                for (int i = 0; i < n; ++i) {
                    Object row = rows.get(i);
                    int index = this.selectedRowsBindMapping == null ? this.tableData.indexOf(row) : this.selectedRowsBindMapping.indexOf(this.tableData, row);
                    if (index == -1) continue;
                    this.addSelectedIndex(index);
                }
                break;
            }
        }
    }

    @Override
    public void store(Object context) {
        if (this.tableDataKey != null && this.tableDataBindType != BindType.LOAD) {
            Object value = this.tableDataBindMapping == null ? this.tableData : this.tableDataBindMapping.valueOf(this.tableData);
            JSON.put((Object)context, (String)this.tableDataKey, value);
        }
        switch (this.selectMode) {
            case SINGLE: {
                if (this.selectedRowKey == null || this.selectedRowBindType == BindType.LOAD) break;
                int selectedIndex = this.getSelectedIndex();
                Object row = selectedIndex == -1 ? null : (this.selectedRowBindMapping == null ? this.tableData.get(selectedIndex) : this.selectedRowBindMapping.get(this.tableData, selectedIndex));
                JSON.put((Object)context, (String)this.selectedRowKey, row);
                break;
            }
            case MULTI: {
                if (this.selectedRowsKey == null || this.selectedRowsBindType == BindType.LOAD) break;
                ArrayList rows = new ArrayList();
                ImmutableList<Span> selectedRanges = this.getSelectedRanges();
                int n = selectedRanges.getLength();
                for (int i = 0; i < n; ++i) {
                    Span range = (Span)selectedRanges.get(i);
                    for (int index = range.start; index <= range.end; ++index) {
                        Object row = this.selectedRowsBindMapping == null ? this.tableData.get(index) : this.selectedRowsBindMapping.get(this.tableData, index);
                        rows.add(row);
                    }
                }
                JSON.put((Object)context, (String)this.selectedRowsKey, (Object)rows);
            }
        }
    }

    @Override
    public void clear() {
        if (this.tableDataKey != null) {
            this.setTableData((List<?>)new ArrayList());
        }
        if (this.selectedRowKey != null || this.selectedRowsKey != null) {
            this.setSelectedRow(null);
        }
    }

    public int getRowAt(int y) {
        Skin tableViewSkin = (Skin)((Object)this.getSkin());
        return tableViewSkin.getRowAt(y);
    }

    public int getColumnAt(int x) {
        Skin tableViewSkin = (Skin)((Object)this.getSkin());
        return tableViewSkin.getColumnAt(x);
    }

    public Bounds getRowBounds(int rowIndex) {
        Skin tableViewSkin = (Skin)((Object)this.getSkin());
        return tableViewSkin.getRowBounds(rowIndex);
    }

    public Bounds getColumnBounds(int columnIndex) {
        Skin tableViewSkin = (Skin)((Object)this.getSkin());
        return tableViewSkin.getColumnBounds(columnIndex);
    }

    public Bounds getCellBounds(int rowIndex, int columnIndex) {
        Skin tableViewSkin = (Skin)((Object)this.getSkin());
        return tableViewSkin.getCellBounds(rowIndex, columnIndex);
    }

    public ListenerList<TableViewListener> getTableViewListeners() {
        return this.tableViewListeners;
    }

    public ListenerList<TableViewColumnListener> getTableViewColumnListeners() {
        return this.tableViewColumnListeners;
    }

    public ListenerList<TableViewRowListener> getTableViewRowListeners() {
        return this.tableViewRowListeners;
    }

    public ListenerList<TableViewSelectionListener> getTableViewSelectionListeners() {
        return this.tableViewSelectionListeners;
    }

    public ListenerList<TableViewSortListener> getTableViewSortListeners() {
        return this.tableViewSortListeners;
    }

    public ListenerList<TableViewBindingListener> getTableViewBindingListeners() {
        return this.tableViewBindingListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableViewBindingListenerList
    extends ListenerList<TableViewBindingListener>
    implements TableViewBindingListener {
        private TableViewBindingListenerList() {
        }

        @Override
        public void tableDataKeyChanged(TableView tableView, String previousTableDataKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewBindingListener listener = (TableViewBindingListener)i$.next();
                listener.tableDataKeyChanged(tableView, previousTableDataKey);
            }
        }

        @Override
        public void tableDataBindTypeChanged(TableView tableView, BindType previousTableDataBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewBindingListener listener = (TableViewBindingListener)i$.next();
                listener.tableDataBindTypeChanged(tableView, previousTableDataBindType);
            }
        }

        @Override
        public void tableDataBindMappingChanged(TableView tableView, TableDataBindMapping previousTableDataBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewBindingListener listener = (TableViewBindingListener)i$.next();
                listener.tableDataBindMappingChanged(tableView, previousTableDataBindMapping);
            }
        }

        @Override
        public void selectedRowKeyChanged(TableView tableView, String previousSelectedRowKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewBindingListener listener = (TableViewBindingListener)i$.next();
                listener.selectedRowKeyChanged(tableView, previousSelectedRowKey);
            }
        }

        @Override
        public void selectedRowBindTypeChanged(TableView tableView, BindType previousSelectedRowBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewBindingListener listener = (TableViewBindingListener)i$.next();
                listener.selectedRowBindTypeChanged(tableView, previousSelectedRowBindType);
            }
        }

        @Override
        public void selectedRowBindMappingChanged(TableView tableView, SelectedRowBindMapping previousSelectedRowBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewBindingListener listener = (TableViewBindingListener)i$.next();
                listener.selectedRowBindMappingChanged(tableView, previousSelectedRowBindMapping);
            }
        }

        @Override
        public void selectedRowsKeyChanged(TableView tableView, String previousSelectedRowsKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewBindingListener listener = (TableViewBindingListener)i$.next();
                listener.selectedRowsKeyChanged(tableView, previousSelectedRowsKey);
            }
        }

        @Override
        public void selectedRowsBindTypeChanged(TableView tableView, BindType previousSelectedRowsBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewBindingListener listener = (TableViewBindingListener)i$.next();
                listener.selectedRowsBindTypeChanged(tableView, previousSelectedRowsBindType);
            }
        }

        @Override
        public void selectedRowsBindMappingChanged(TableView tableView, SelectedRowBindMapping previousSelectedRowsBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewBindingListener listener = (TableViewBindingListener)i$.next();
                listener.selectedRowsBindMappingChanged(tableView, previousSelectedRowsBindMapping);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableViewSortListenerList
    extends ListenerList<TableViewSortListener>
    implements TableViewSortListener {
        private TableViewSortListenerList() {
        }

        @Override
        public void sortAdded(TableView tableView, String columnName) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewSortListener listener = (TableViewSortListener)i$.next();
                listener.sortAdded(tableView, columnName);
            }
        }

        @Override
        public void sortUpdated(TableView tableView, String columnName, SortDirection previousSortDirection) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewSortListener listener = (TableViewSortListener)i$.next();
                listener.sortUpdated(tableView, columnName, previousSortDirection);
            }
        }

        @Override
        public void sortRemoved(TableView tableView, String columnName, SortDirection sortDirection) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewSortListener listener = (TableViewSortListener)i$.next();
                listener.sortRemoved(tableView, columnName, sortDirection);
            }
        }

        @Override
        public void sortChanged(TableView tableView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewSortListener listener = (TableViewSortListener)i$.next();
                listener.sortChanged(tableView);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableViewSelectionListenerList
    extends ListenerList<TableViewSelectionListener>
    implements TableViewSelectionListener {
        private TableViewSelectionListenerList() {
        }

        @Override
        public void selectedRangeAdded(TableView tableView, int rangeStart, int rangeEnd) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewSelectionListener listener = (TableViewSelectionListener)i$.next();
                listener.selectedRangeAdded(tableView, rangeStart, rangeEnd);
            }
        }

        @Override
        public void selectedRangeRemoved(TableView tableView, int rangeStart, int rangeEnd) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewSelectionListener listener = (TableViewSelectionListener)i$.next();
                listener.selectedRangeRemoved(tableView, rangeStart, rangeEnd);
            }
        }

        @Override
        public void selectedRangesChanged(TableView tableView, Sequence<Span> previousSelection) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewSelectionListener listener = (TableViewSelectionListener)i$.next();
                listener.selectedRangesChanged(tableView, previousSelection);
            }
        }

        @Override
        public void selectedRowChanged(TableView tableView, Object previousSelectedRow) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewSelectionListener listener = (TableViewSelectionListener)i$.next();
                listener.selectedRowChanged(tableView, previousSelectedRow);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableViewRowListenerList
    extends ListenerList<TableViewRowListener>
    implements TableViewRowListener {
        private TableViewRowListenerList() {
        }

        @Override
        public void rowInserted(TableView tableView, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewRowListener listener = (TableViewRowListener)i$.next();
                listener.rowInserted(tableView, index);
            }
        }

        @Override
        public void rowsRemoved(TableView tableView, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewRowListener listener = (TableViewRowListener)i$.next();
                listener.rowsRemoved(tableView, index, count);
            }
        }

        @Override
        public void rowUpdated(TableView tableView, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewRowListener listener = (TableViewRowListener)i$.next();
                listener.rowUpdated(tableView, index);
            }
        }

        @Override
        public void rowsCleared(TableView tableView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewRowListener listener = (TableViewRowListener)i$.next();
                listener.rowsCleared(tableView);
            }
        }

        @Override
        public void rowsSorted(TableView tableView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewRowListener listener = (TableViewRowListener)i$.next();
                listener.rowsSorted(tableView);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableViewColumnListenerList
    extends ListenerList<TableViewColumnListener>
    implements TableViewColumnListener {
        private TableViewColumnListenerList() {
        }

        @Override
        public void columnInserted(TableView tableView, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewColumnListener listener = (TableViewColumnListener)i$.next();
                listener.columnInserted(tableView, index);
            }
        }

        @Override
        public void columnsRemoved(TableView tableView, int index, Sequence<Column> columns) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewColumnListener listener = (TableViewColumnListener)i$.next();
                listener.columnsRemoved(tableView, index, columns);
            }
        }

        @Override
        public void columnNameChanged(Column column, String previousName) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewColumnListener listener = (TableViewColumnListener)i$.next();
                listener.columnNameChanged(column, previousName);
            }
        }

        @Override
        public void columnHeaderDataChanged(Column column, Object previousHeaderData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewColumnListener listener = (TableViewColumnListener)i$.next();
                listener.columnHeaderDataChanged(column, previousHeaderData);
            }
        }

        @Override
        public void columnHeaderDataRendererChanged(Column column, HeaderDataRenderer previousHeaderDataRenderer) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewColumnListener listener = (TableViewColumnListener)i$.next();
                listener.columnHeaderDataRendererChanged(column, previousHeaderDataRenderer);
            }
        }

        @Override
        public void columnWidthChanged(Column column, int previousWidth, boolean previousRelative) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewColumnListener listener = (TableViewColumnListener)i$.next();
                listener.columnWidthChanged(column, previousWidth, previousRelative);
            }
        }

        @Override
        public void columnWidthLimitsChanged(Column column, int previousMinimumWidth, int previousMaximumWidth) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewColumnListener listener = (TableViewColumnListener)i$.next();
                listener.columnWidthLimitsChanged(column, previousMinimumWidth, previousMaximumWidth);
            }
        }

        @Override
        public void columnFilterChanged(Column column, Object previousFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewColumnListener listener = (TableViewColumnListener)i$.next();
                listener.columnFilterChanged(column, previousFilter);
            }
        }

        @Override
        public void columnCellRendererChanged(Column column, CellRenderer previousCellRenderer) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewColumnListener listener = (TableViewColumnListener)i$.next();
                listener.columnCellRendererChanged(column, previousCellRenderer);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableViewListenerList
    extends ListenerList<TableViewListener>
    implements TableViewListener {
        private TableViewListenerList() {
        }

        @Override
        public void tableDataChanged(TableView tableView, List<?> previousTableData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewListener listener = (TableViewListener)i$.next();
                listener.tableDataChanged(tableView, previousTableData);
            }
        }

        @Override
        public void columnSourceChanged(TableView tableView, TableView previousColumnSource) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewListener listener = (TableViewListener)i$.next();
                listener.columnSourceChanged(tableView, previousColumnSource);
            }
        }

        @Override
        public void rowEditorChanged(TableView tableView, RowEditor previousRowEditor) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewListener listener = (TableViewListener)i$.next();
                listener.rowEditorChanged(tableView, previousRowEditor);
            }
        }

        @Override
        public void selectModeChanged(TableView tableView, SelectMode previousSelectMode) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewListener listener = (TableViewListener)i$.next();
                listener.selectModeChanged(tableView, previousSelectMode);
            }
        }

        @Override
        public void disabledRowFilterChanged(TableView tableView, Filter<?> previousDisabledRowFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewListener listener = (TableViewListener)i$.next();
                listener.disabledRowFilterChanged(tableView, previousDisabledRowFilter);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SortDictionary
    implements Dictionary<String, SortDirection>,
    Iterable<String> {
        public SortDirection get(String columnName) {
            return (SortDirection)((Object)TableView.this.sortMap.get((Object)columnName));
        }

        public SortDirection put(String columnName, SortDirection sortDirection) {
            SortDirection previousSortDirection;
            if (sortDirection == null) {
                previousSortDirection = this.remove(columnName);
            } else {
                boolean update = this.containsKey(columnName);
                previousSortDirection = (SortDirection)((Object)TableView.this.sortMap.put((Object)columnName, (Object)sortDirection));
                if (update) {
                    TableView.this.tableViewSortListeners.sortUpdated(TableView.this, columnName, previousSortDirection);
                } else {
                    TableView.this.sortList.add((Object)columnName);
                    TableView.this.tableViewSortListeners.sortAdded(TableView.this, columnName);
                }
            }
            return previousSortDirection;
        }

        public SortDirection remove(String columnName) {
            SortDirection sortDirection = null;
            if (this.containsKey(columnName)) {
                sortDirection = (SortDirection)((Object)TableView.this.sortMap.remove((Object)columnName));
                TableView.this.sortList.remove((Object)columnName);
                TableView.this.tableViewSortListeners.sortRemoved(TableView.this, columnName, sortDirection);
            }
            return sortDirection;
        }

        public boolean containsKey(String columnName) {
            return TableView.this.sortMap.containsKey((Object)columnName);
        }

        public boolean isEmpty() {
            return TableView.this.sortMap.isEmpty();
        }

        public Dictionary.Pair<String, SortDirection> get(int index) {
            String columnName = (String)TableView.this.sortList.get(index);
            SortDirection sortDirection = (SortDirection)((Object)TableView.this.sortMap.get((Object)columnName));
            return new Dictionary.Pair((Object)columnName, (Object)sortDirection);
        }

        public int getLength() {
            return TableView.this.sortList.getLength();
        }

        @Override
        public Iterator<String> iterator() {
            return TableView.this.sortList.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ColumnSequence
    implements Sequence<Column>,
    Iterable<Column> {
        public int add(Column column) {
            int index = this.getLength();
            this.insert(column, index);
            return index;
        }

        public void insert(Column column, int index) {
            if (column == null) {
                throw new IllegalArgumentException("column is null.");
            }
            if (column.tableView != null) {
                throw new IllegalArgumentException("column is already in use by another table view.");
            }
            TableView.this.columns.insert((Object)column, index);
            column.tableView = TableView.this;
            TableView.this.tableViewColumnListeners.columnInserted(TableView.this, index);
        }

        public Column update(int index, Column column) {
            throw new UnsupportedOperationException();
        }

        public int remove(Column column) {
            int index = this.indexOf(column);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Column> remove(int index, int count) {
            Sequence removed = TableView.this.columns.remove(index, count);
            if (count > 0) {
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    ((Column)removed.get(i)).tableView = null;
                }
                TableView.this.tableViewColumnListeners.columnsRemoved(TableView.this, index, (Sequence<Column>)removed);
            }
            return removed;
        }

        public Column get(int index) {
            return (Column)TableView.this.columns.get(index);
        }

        public int indexOf(Column column) {
            return TableView.this.columns.indexOf((Object)column);
        }

        public int getLength() {
            return TableView.this.columns.getLength();
        }

        @Override
        public Iterator<Column> iterator() {
            return new ImmutableIterator((Iterator)TableView.this.columns.iterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SelectedRowBindMapping {
        public int indexOf(List<?> var1, Object var2);

        public Object get(List<?> var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TableDataBindMapping {
        public List<?> toTableData(Object var1);

        public Object valueOf(List<?> var1);
    }

    public static interface Skin {
        public int getRowAt(int var1);

        public int getColumnAt(int var1);

        public Bounds getRowBounds(int var1);

        public Bounds getColumnBounds(int var1);

        public Bounds getCellBounds(int var1, int var2);
    }

    public static interface RowEditor {
        public void beginEdit(TableView var1, int var2, int var3);

        public void endEdit(boolean var1);

        public boolean isEditing();
    }

    public static interface HeaderDataRenderer
    extends Renderer {
        public void render(Object var1, int var2, TableViewHeader var3, String var4, boolean var5);

        public String toString(Object var1);
    }

    public static interface CellRenderer
    extends Renderer {
        public void render(Object var1, int var2, int var3, TableView var4, String var5, boolean var6, boolean var7, boolean var8);

        public String toString(Object var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectMode {
        NONE,
        SINGLE,
        MULTI;

    }

    public static final class Column {
        private TableView tableView = null;
        private String name = null;
        private Object headerData = null;
        private HeaderDataRenderer headerDataRenderer = DEFAULT_HEADER_DATA_RENDERER;
        private int width = 0;
        private int minimumWidth = 0;
        private int maximumWidth = Integer.MAX_VALUE;
        private boolean relative = false;
        private Object filter = null;
        private CellRenderer cellRenderer = DEFAULT_CELL_RENDERER;
        private static final CellRenderer DEFAULT_CELL_RENDERER = new TableViewCellRenderer();
        private static final HeaderDataRenderer DEFAULT_HEADER_DATA_RENDERER = new TableViewHeaderDataRenderer();
        public static final int DEFAULT_WIDTH = 100;

        public Column() {
            this(null, null, 100, false);
        }

        public Column(String name) {
            this(name, null, 100, false);
        }

        public Column(String name, Object headerData) {
            this(name, headerData, 100, false);
        }

        public Column(String name, Object headerData, int width) {
            this(name, headerData, width, false);
        }

        public Column(String name, Object headerData, int width, boolean relative) {
            this.setName(name);
            this.setHeaderData(headerData);
            this.setWidth(width, relative);
        }

        public TableView getTableView() {
            return this.tableView;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String previousName = this.name;
            if (previousName != name) {
                this.name = name;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnNameChanged(this, previousName);
                }
            }
        }

        public Object getHeaderData() {
            return this.headerData;
        }

        public void setHeaderData(Object headerData) {
            Object previousHeaderData = this.headerData;
            if (previousHeaderData != headerData) {
                this.headerData = headerData;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnHeaderDataChanged(this, previousHeaderData);
                }
            }
        }

        public HeaderDataRenderer getHeaderDataRenderer() {
            return this.headerDataRenderer;
        }

        public void setHeaderDataRenderer(HeaderDataRenderer headerDataRenderer) {
            if (headerDataRenderer == null) {
                throw new IllegalArgumentException("headerDataRenderer is null.");
            }
            HeaderDataRenderer previousHeaderDataRenderer = this.headerDataRenderer;
            if (previousHeaderDataRenderer != headerDataRenderer) {
                this.headerDataRenderer = headerDataRenderer;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnHeaderDataRendererChanged(this, previousHeaderDataRenderer);
                }
            }
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public void setWidth(int width) {
            this.setWidth(width, false);
        }

        public void setWidth(String width) {
            boolean relative = false;
            if (width.endsWith("*")) {
                relative = true;
                width = width.substring(0, width.length() - 1);
            }
            this.setWidth(Integer.parseInt(width), relative);
        }

        public void setWidth(int width, boolean relative) {
            if (width < (relative ? 0 : -1)) {
                throw new IllegalArgumentException();
            }
            int previousWidth = this.width;
            boolean previousRelative = this.relative;
            if (previousWidth != width || previousRelative != relative) {
                this.width = width;
                this.relative = relative;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnWidthChanged(this, previousWidth, previousRelative);
                }
            }
        }

        public Limits getWidthLimits() {
            return new Limits(this.minimumWidth, this.maximumWidth);
        }

        public void setWidthLimits(int minimumWidth, int maximumWidth) {
            if (minimumWidth < 0) {
                throw new IllegalArgumentException("Minimum width is negative.");
            }
            if (maximumWidth < minimumWidth) {
                throw new IllegalArgumentException("Maximum width is smaller than minimum width.");
            }
            int previousMinimumWidth = this.minimumWidth;
            int previousMaximumWidth = this.maximumWidth;
            if (minimumWidth != previousMinimumWidth || maximumWidth != previousMaximumWidth) {
                this.minimumWidth = minimumWidth;
                this.maximumWidth = maximumWidth;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnWidthLimitsChanged(this, previousMinimumWidth, previousMaximumWidth);
                }
            }
        }

        public void setWidthLimits(Limits widthLimits) {
            this.setWidthLimits(widthLimits.minimum, widthLimits.maximum);
        }

        public int getMinimumWidth() {
            return this.minimumWidth;
        }

        public void setMinimumWidth(int minimumWidth) {
            this.setWidthLimits(minimumWidth, this.maximumWidth);
        }

        public int getMaximumWidth() {
            return this.maximumWidth;
        }

        public void setMaximumWidth(int maximumWidth) {
            this.setWidthLimits(this.minimumWidth, maximumWidth);
        }

        public Object getFilter() {
            return this.filter;
        }

        public void setFilter(Object filter) {
            Object previousFilter = this.filter;
            if (previousFilter != filter) {
                this.filter = filter;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnFilterChanged(this, previousFilter);
                }
            }
        }

        public CellRenderer getCellRenderer() {
            return this.cellRenderer;
        }

        public void setCellRenderer(CellRenderer cellRenderer) {
            if (cellRenderer == null) {
                throw new IllegalArgumentException("cellRenderer is null.");
            }
            CellRenderer previousCellRenderer = this.cellRenderer;
            if (previousCellRenderer != cellRenderer) {
                this.cellRenderer = cellRenderer;
                if (this.tableView != null) {
                    this.tableView.tableViewColumnListeners.columnCellRendererChanged(this, previousCellRenderer);
                }
            }
        }
    }
}

