/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.wtk.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskAdapter<T>
implements TaskListener<T> {
    private TaskListener<T> taskListener;

    public TaskAdapter(TaskListener<T> taskListener) {
        if (taskListener == null) {
            throw new IllegalArgumentException("taskListener cannot be null");
        }
        this.taskListener = taskListener;
    }

    public void taskExecuted(Task<T> task) {
        ApplicationContext.queueCallback(new TaskExecutedCallback(task));
    }

    public void executeFailed(Task<T> task) {
        ApplicationContext.queueCallback(new ExecuteFailedCallback(task));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecuteFailedCallback
    implements Runnable {
        private Task<T> task;

        public ExecuteFailedCallback(Task<T> task) {
            this.task = task;
        }

        @Override
        public void run() {
            TaskAdapter.this.taskListener.executeFailed(this.task);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskExecutedCallback
    implements Runnable {
        private Task<T> task;

        public TaskExecutedCallback(Task<T> task) {
            this.task = task;
        }

        @Override
        public void run() {
            TaskAdapter.this.taskListener.taskExecuted(this.task);
        }
    }
}

