/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.content.TreeNode;
import org.apache.pivot.wtk.media.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBranch
extends TreeNode
implements List<TreeNode> {
    private Image expandedIcon = null;
    private ArrayList<TreeNode> treeNodes = new ArrayList();
    private List.ListListenerList<TreeNode> listListeners = new List.ListListenerList();

    public TreeBranch() {
        this(null, null, null);
    }

    public TreeBranch(Image icon) {
        this(icon, null, null);
    }

    public TreeBranch(String text) {
        this(null, null, text);
    }

    public TreeBranch(Image icon, String text) {
        this(icon, null, text);
    }

    public TreeBranch(Image icon, Image expandedIcon, String text) {
        super(icon, text);
        this.expandedIcon = expandedIcon;
    }

    public Image getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setExpandedIcon(Image expandedIcon) {
        this.expandedIcon = expandedIcon;
    }

    public void setExpandedIcon(URL expandedIconURL) {
        if (expandedIconURL == null) {
            throw new IllegalArgumentException("expandedIconURL is null.");
        }
        Image icon = (Image)ApplicationContext.getResourceCache().get(expandedIconURL);
        if (icon == null) {
            try {
                icon = Image.load(expandedIconURL);
            }
            catch (TaskExecutionException exception) {
                throw new IllegalArgumentException(exception);
            }
            ApplicationContext.getResourceCache().put(expandedIconURL, (Object)icon);
        }
        this.setExpandedIcon(icon);
    }

    public void setExpandedIcon(String expandedIconName) {
        if (expandedIconName == null) {
            throw new IllegalArgumentException("expandedIconName is null.");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.setExpandedIcon(classLoader.getResource(expandedIconName.substring(1)));
    }

    public int add(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("treeNode is null.");
        }
        if (treeNode.getParent() != null) {
            throw new IllegalArgumentException("treeNode already has a parent.");
        }
        int index = this.treeNodes.add((Object)treeNode);
        treeNode.setParent(this);
        this.listListeners.itemInserted((List)this, index);
        return index;
    }

    public void insert(TreeNode treeNode, int index) {
        if (treeNode == null) {
            throw new IllegalArgumentException("treeNode is null.");
        }
        if (treeNode.getParent() != null) {
            throw new IllegalArgumentException("treeNode already has a parent.");
        }
        this.treeNodes.insert((Object)treeNode, index);
        treeNode.setParent(this);
        this.listListeners.itemInserted((List)this, index);
    }

    public TreeNode update(int index, TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("treeNode is null.");
        }
        if (treeNode.getParent() != null) {
            throw new IllegalArgumentException("treeNode already has a parent.");
        }
        TreeNode previousTreeNode = (TreeNode)this.treeNodes.update(index, (Object)treeNode);
        previousTreeNode.setParent(null);
        treeNode.setParent(this);
        this.listListeners.itemUpdated((List)this, index, (Object)previousTreeNode);
        return previousTreeNode;
    }

    public int remove(TreeNode treeNode) {
        int index = this.indexOf(treeNode);
        if (index != -1) {
            this.remove(index, 1);
        }
        return index;
    }

    public Sequence<TreeNode> remove(int index, int count) {
        Sequence removed = this.treeNodes.remove(index, count);
        if (count > 0) {
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                TreeNode treeNode = (TreeNode)removed.get(i);
                treeNode.setParent(null);
            }
            this.listListeners.itemsRemoved((List)this, index, removed);
        }
        return removed;
    }

    public void clear() {
        if (this.getLength() > 0) {
            int n = this.treeNodes.getLength();
            for (int i = 0; i < n; ++i) {
                TreeNode treeNode = (TreeNode)this.treeNodes.get(i);
                treeNode.setParent(null);
            }
            this.treeNodes.clear();
            this.listListeners.listCleared((List)this);
        }
    }

    public TreeNode get(int index) {
        return (TreeNode)this.treeNodes.get(index);
    }

    public int indexOf(TreeNode treeNode) {
        return this.treeNodes.indexOf((Object)treeNode);
    }

    public boolean isEmpty() {
        return this.treeNodes.isEmpty();
    }

    public int getLength() {
        return this.treeNodes.getLength();
    }

    public Comparator<TreeNode> getComparator() {
        return this.treeNodes.getComparator();
    }

    public void setComparator(Comparator<TreeNode> comparator) {
        Comparator previousComparator = this.treeNodes.getComparator();
        if (previousComparator != comparator) {
            this.treeNodes.setComparator(comparator);
            int n = this.treeNodes.getLength();
            for (int i = 0; i < n; ++i) {
                TreeNode treeNode = (TreeNode)this.treeNodes.get(i);
                if (!(treeNode instanceof TreeBranch)) continue;
                TreeBranch treeBranch = (TreeBranch)treeNode;
                treeBranch.setComparator(comparator);
            }
            this.listListeners.comparatorChanged((List)this, previousComparator);
        }
    }

    public Iterator<TreeNode> iterator() {
        return new ImmutableIterator((Iterator)this.treeNodes.iterator());
    }

    public ListenerList<ListListener<TreeNode>> getListListeners() {
        return this.listListeners;
    }
}

