/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.content.TreeNode;
import org.apache.pivot.wtk.content.TreeViewNodeRenderer;

public class TreeViewNodeEditor
extends Window
implements TreeView.NodeEditor {
    private TreeView treeView = null;
    private Sequence.Tree.Path path = null;
    private TextInput textInput = new TextInput();
    private ContainerMouseListener displayMouseHandler = new ContainerMouseListener.Adapter(){

        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            if (window != TreeViewNodeEditor.this) {
                TreeViewNodeEditor.this.endEdit(true);
            }
            return false;
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            return window != TreeViewNodeEditor.this;
        }
    };

    public TreeViewNodeEditor() {
        this.setContent(this.textInput);
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    public Sequence.Tree.Path getPath() {
        return this.path;
    }

    public TextInput getTextInput() {
        return this.textInput;
    }

    public void beginEdit(TreeView treeView, Sequence.Tree.Path path) {
        this.treeView = treeView;
        this.path = path;
        List<?> treeData = treeView.getTreeData();
        TreeNode treeNode = (TreeNode)Sequence.Tree.get(treeData, (Sequence.Tree.Path)path);
        this.textInput.setText(treeNode.getText());
        this.textInput.selectAll();
        Bounds nodeBounds = treeView.getNodeBounds(path);
        int nodeIndent = treeView.getNodeIndent(path.getLength());
        nodeBounds = new Bounds(nodeBounds.x + nodeIndent, nodeBounds.y, nodeBounds.width - nodeIndent, nodeBounds.height);
        TreeViewNodeRenderer nodeRenderer = (TreeViewNodeRenderer)treeView.getNodeRenderer();
        nodeRenderer.render(treeNode, path, treeView.getRowIndex(path), treeView, false, false, TreeView.NodeCheckState.UNCHECKED, false, false);
        nodeRenderer.setSize(nodeBounds.width, nodeBounds.height);
        Bounds textBounds = nodeRenderer.getTextBounds();
        Insets padding = (Insets)this.textInput.getStyles().get("padding");
        Bounds editBounds = new Bounds(nodeBounds.x + textBounds.x - (padding.left + 1), nodeBounds.y, nodeBounds.width - textBounds.x + (padding.left + 1), nodeBounds.height);
        treeView.scrollAreaToVisible(editBounds.x, editBounds.y, textBounds.width + padding.left + 1, editBounds.height);
        editBounds = treeView.getVisibleArea(editBounds);
        Point location = treeView.mapPointToAncestor(treeView.getDisplay(), editBounds.x, editBounds.y);
        this.textInput.setPreferredWidth(editBounds.width);
        this.setLocation(location.x, location.y + (editBounds.height - this.getPreferredHeight(-1)) / 2);
        this.open(treeView.getWindow());
    }

    public void endEdit(boolean result) {
        if (result) {
            List parentData;
            String text = this.textInput.getText();
            List treeData = this.treeView.getTreeData();
            TreeNode treeNode = (TreeNode)Sequence.Tree.get(treeData, (Sequence.Tree.Path)this.path);
            treeNode.setText(text);
            int n = this.path.getLength();
            if (n == 1) {
                parentData = treeData;
            } else {
                Sequence.Tree.Path parentPath = new Sequence.Tree.Path(this.path, n - 1);
                parentData = (List)Sequence.Tree.get(treeData, (Sequence.Tree.Path)parentPath);
            }
            if (parentData.getComparator() == null) {
                parentData.update(this.path.get(n - 1).intValue(), (Object)treeNode);
            } else {
                parentData.remove(this.path.get(n - 1).intValue(), 1);
                parentData.add((Object)treeNode);
                this.path = new Sequence.Tree.Path(this.path, n - 1);
                this.path.add(Integer.valueOf(parentData.indexOf((Object)treeNode)));
                this.treeView.setSelectedPath(this.path);
                this.treeView.scrollAreaToVisible(this.treeView.getNodeBounds(this.path));
            }
        }
        this.getOwner().moveToFront();
        this.treeView.requestFocus();
        this.treeView = null;
        this.path = null;
        this.close();
    }

    public boolean isEditing() {
        return this.treeView != null;
    }

    public void open(Display display, Window owner) {
        if (this.treeView == null) {
            throw new IllegalStateException();
        }
        super.open(display, owner);
        display.getContainerMouseListeners().add((Object)this.displayMouseHandler);
        this.requestFocus();
    }

    public void close() {
        Display display = this.getDisplay();
        display.getContainerMouseListeners().remove((Object)this.displayMouseHandler);
        super.close();
    }

    public boolean keyPressed(int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed;
        if (keyCode == 10) {
            this.endEdit(true);
            consumed = true;
        } else if (keyCode == 27) {
            this.endEdit(false);
            consumed = true;
        } else {
            consumed = false;
        }
        return consumed;
    }
}

