/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.effects.Decorator;

public class BaselineDecorator
implements Decorator {
    private Component component = null;
    private Graphics2D graphics = null;

    public Graphics2D prepare(Component component, Graphics2D graphics) {
        this.component = component;
        this.graphics = graphics;
        return graphics;
    }

    public void update() {
        Color color;
        int y;
        int height;
        int width = this.component.getWidth();
        int baseline = this.component.getBaseline(width, height = this.component.getHeight());
        if (baseline == -1) {
            y = height / 2;
            color = Color.BLUE;
        } else {
            y = baseline;
            color = Color.RED;
        }
        this.graphics.setPaint(color);
        GraphicsUtilities.drawLine(this.graphics, 0, y, width, Orientation.HORIZONTAL);
        this.component = null;
        this.graphics = null;
    }

    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

