/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGRoot;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.wtk.media.Image;

public class Drawing
extends Image {
    private SVGDiagram diagram;

    public Drawing(SVGDiagram diagram) {
        if (diagram == null) {
            throw new IllegalArgumentException();
        }
        this.diagram = diagram;
    }

    public SVGDiagram getDiagram() {
        return this.diagram;
    }

    public int getWidth() {
        return (int)Math.ceil(this.diagram.getWidth());
    }

    public int getHeight() {
        return (int)Math.ceil(this.diagram.getHeight());
    }

    public void setSize(int width, int height) {
        int previousWidth = this.getWidth();
        int previousHeight = this.getHeight();
        SVGRoot root = this.diagram.getRoot();
        try {
            root.setAttribute("width", 1, Integer.toString(width));
            root.setAttribute("height", 1, Integer.toString(height));
        }
        catch (SVGElementException exception) {
            throw new RuntimeException(exception);
        }
        try {
            this.diagram.updateTime(0.0);
        }
        catch (SVGException exception) {
            throw new RuntimeException(exception);
        }
        this.imageListeners.sizeChanged(this, previousWidth, previousHeight);
    }

    public void paint(Graphics2D graphics) {
        try {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.diagram.render(graphics);
        }
        catch (SVGException exception) {
            throw new RuntimeException(exception);
        }
    }
}

