/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Visual;
import org.apache.pivot.wtk.media.MovieListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Movie
implements Visual {
    private int currentFrame = -1;
    private int frameRate = 26;
    private boolean looping = false;
    private ApplicationContext.ScheduledCallback scheduledCallback = null;
    protected MovieListenerList movieListeners = new MovieListenerList();
    private final Runnable nextFrameCallback = new Runnable(){

        public void run() {
            if (Movie.this.currentFrame == Movie.this.getTotalFrames() - 1) {
                if (Movie.this.looping) {
                    Movie.this.setCurrentFrame(0);
                } else {
                    Movie.this.stop();
                }
            } else {
                Movie.this.setCurrentFrame(Movie.this.currentFrame + 1);
            }
        }
    };

    @Override
    public int getBaseline() {
        return -1;
    }

    public Dimensions getSize() {
        return new Dimensions(this.getWidth(), this.getHeight());
    }

    public abstract int getTotalFrames();

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(int currentFrame) {
        int previousFrame = this.currentFrame;
        if (previousFrame != currentFrame) {
            this.currentFrame = currentFrame;
            this.movieListeners.currentFrameChanged(this, previousFrame);
        }
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setLooping(boolean looping) {
        if (this.looping != looping) {
            this.looping = looping;
            this.movieListeners.loopingChanged(this);
        }
    }

    public void play() {
        if (this.scheduledCallback != null) {
            throw new IllegalStateException("Movie is already playing.");
        }
        this.scheduledCallback = ApplicationContext.scheduleRecurringCallback(this.nextFrameCallback, (int)(1.0 / (double)this.frameRate * 1000.0));
        this.movieListeners.movieStarted(this);
    }

    public void stop() {
        if (this.scheduledCallback != null) {
            this.scheduledCallback.cancel();
        }
        this.scheduledCallback = null;
        this.movieListeners.movieStopped(this);
    }

    public boolean isPlaying() {
        return this.scheduledCallback != null;
    }

    public ListenerList<MovieListener> getMovieListeners() {
        return this.movieListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MovieListenerList
    extends ListenerList<MovieListener>
    implements MovieListener {
        protected MovieListenerList() {
        }

        @Override
        public void sizeChanged(Movie movie, int previousWidth, int previousHeight) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MovieListener listener = (MovieListener)i$.next();
                listener.sizeChanged(movie, previousWidth, previousHeight);
            }
        }

        @Override
        public void baselineChanged(Movie movie, int previousBaseline) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MovieListener listener = (MovieListener)i$.next();
                listener.baselineChanged(movie, previousBaseline);
            }
        }

        @Override
        public void currentFrameChanged(Movie movie, int previousFrame) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MovieListener listener = (MovieListener)i$.next();
                listener.currentFrameChanged(movie, previousFrame);
            }
        }

        @Override
        public void loopingChanged(Movie movie) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MovieListener listener = (MovieListener)i$.next();
                listener.loopingChanged(movie);
            }
        }

        @Override
        public void movieStarted(Movie movie) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MovieListener listener = (MovieListener)i$.next();
                listener.movieStarted(movie);
            }
        }

        @Override
        public void movieStopped(Movie movie) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MovieListener listener = (MovieListener)i$.next();
                listener.movieStopped(movie);
            }
        }

        @Override
        public void regionUpdated(Movie movie, int x, int y, int width, int height) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MovieListener listener = (MovieListener)i$.next();
                listener.regionUpdated(movie, x, y, width, height);
            }
        }
    }
}

