/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.BoxPaneListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.skin.ContainerSkin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxPaneSkin
extends ContainerSkin
implements BoxPaneListener {
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    private VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    private Insets padding = Insets.NONE;
    private int spacing = 4;
    private boolean fill = false;

    @Override
    public void install(Component component) {
        super.install(component);
        BoxPane boxPane = (BoxPane)component;
        boxPane.getBoxPaneListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int height) {
        BoxPane boxPane = (BoxPane)this.getComponent();
        int preferredWidth = 0;
        Orientation orientation = boxPane.getOrientation();
        if (orientation == Orientation.HORIZONTAL) {
            if (height != -1) {
                height = Math.max(height - (this.padding.top + this.padding.bottom), 0);
            }
            int j = 0;
            int n = boxPane.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                preferredWidth += component.getPreferredWidth(this.fill ? height : -1);
                ++j;
            }
            if (j > 1) {
                preferredWidth += this.spacing * (j - 1);
            }
        } else {
            int n = boxPane.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                preferredWidth = Math.max(preferredWidth, component.getPreferredWidth());
            }
        }
        return preferredWidth += this.padding.left + this.padding.right;
    }

    @Override
    public int getPreferredHeight(int width) {
        BoxPane boxPane = (BoxPane)this.getComponent();
        int preferredHeight = 0;
        Orientation orientation = boxPane.getOrientation();
        if (orientation == Orientation.HORIZONTAL) {
            int n = boxPane.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                preferredHeight = Math.max(preferredHeight, component.getPreferredHeight());
            }
        } else {
            if (width != -1) {
                width = Math.max(width - (this.padding.left + this.padding.right), 0);
            }
            int j = 0;
            int n = boxPane.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                preferredHeight += component.getPreferredHeight(this.fill ? width : -1);
                ++j;
            }
            if (j > 1) {
                preferredHeight += this.spacing * (j - 1);
            }
        }
        return preferredHeight += this.padding.top + this.padding.bottom;
    }

    @Override
    public Dimensions getPreferredSize() {
        BoxPane boxPane = (BoxPane)this.getComponent();
        int preferredWidth = 0;
        int preferredHeight = 0;
        switch (boxPane.getOrientation()) {
            case HORIZONTAL: {
                int j = 0;
                int n = boxPane.getLength();
                for (int i = 0; i < n; ++i) {
                    Component component = boxPane.get(i);
                    if (!component.isVisible()) continue;
                    Dimensions preferredSize = component.getPreferredSize();
                    preferredWidth += preferredSize.width;
                    preferredHeight = Math.max(preferredSize.height, preferredHeight);
                    ++j;
                }
                if (j <= true) break;
                preferredWidth += this.spacing * (j - 1);
                break;
            }
            case VERTICAL: {
                int j = 0;
                int n = boxPane.getLength();
                for (int i = 0; i < n; ++i) {
                    Component component = boxPane.get(i);
                    if (!component.isVisible()) continue;
                    Dimensions preferredSize = component.getPreferredSize();
                    preferredWidth = Math.max(preferredSize.width, preferredWidth);
                    preferredHeight += preferredSize.height;
                    ++j;
                }
                if (j <= true) break;
                preferredHeight += this.spacing * (j - 1);
                break;
            }
        }
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right, preferredHeight += this.padding.top + this.padding.bottom);
    }

    @Override
    public int getBaseline(int width, int height) {
        BoxPane boxPane = (BoxPane)this.getComponent();
        int baseline = -1;
        int contentHeight = 0;
        switch (boxPane.getOrientation()) {
            case HORIZONTAL: {
                if (this.fill) {
                    int clientHeight = Math.max(height - (this.padding.top + this.padding.bottom), 0);
                    for (Component component : boxPane) {
                        if (!component.isVisible()) continue;
                        int componentWidth = component.getPreferredWidth(clientHeight);
                        baseline = Math.max(baseline, component.getBaseline(componentWidth, clientHeight));
                    }
                } else {
                    contentHeight = 0;
                    for (Component component : boxPane) {
                        if (!component.isVisible()) continue;
                        contentHeight = Math.max(contentHeight, component.getPreferredHeight());
                    }
                    for (Component component : boxPane) {
                        if (!component.isVisible()) continue;
                        Dimensions size = component.getPreferredSize();
                        int componentBaseline = component.getBaseline(size.width, size.height);
                        if (componentBaseline != -1) {
                            switch (this.verticalAlignment) {
                                case CENTER: {
                                    componentBaseline += (contentHeight - size.height) / 2;
                                    break;
                                }
                                case BOTTOM: {
                                    componentBaseline += contentHeight - size.height;
                                }
                            }
                        }
                        baseline = Math.max(baseline, componentBaseline);
                    }
                }
                break;
            }
            case VERTICAL: {
                int clientWidth = Math.max(width - (this.padding.left + this.padding.right), 0);
                for (Component component : boxPane) {
                    if (!component.isVisible()) continue;
                    Dimensions size = this.fill ? new Dimensions(clientWidth, component.getPreferredHeight(clientWidth)) : component.getPreferredSize();
                    if (baseline == -1 && (baseline = component.getBaseline(size.width, size.height)) != -1) {
                        baseline += contentHeight;
                    }
                    contentHeight += size.height + this.spacing;
                }
                contentHeight -= this.spacing;
                break;
            }
        }
        if (baseline != -1) {
            if (this.fill) {
                baseline += this.padding.top;
            } else {
                switch (this.verticalAlignment) {
                    case TOP: {
                        baseline += this.padding.top;
                        break;
                    }
                    case CENTER: {
                        baseline += (height - contentHeight) / 2;
                        break;
                    }
                    case BOTTOM: {
                        baseline += height - (contentHeight + this.padding.bottom);
                    }
                }
            }
        }
        return baseline;
    }

    @Override
    public void layout() {
        BoxPane boxPane = (BoxPane)this.getComponent();
        int n = boxPane.getLength();
        int width = this.getWidth();
        int height = this.getHeight();
        Orientation orientation = boxPane.getOrientation();
        if (orientation == Orientation.HORIZONTAL) {
            int preferredWidth = this.getPreferredWidth(this.fill ? height : -1);
            int x = 0;
            switch (this.horizontalAlignment) {
                case CENTER: {
                    x = (width - preferredWidth) / 2;
                    break;
                }
                case RIGHT: {
                    x = width - preferredWidth;
                }
            }
            x += this.padding.left;
            for (int i = 0; i < n; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                int componentWidth = 0;
                int componentHeight = 0;
                int y = 0;
                if (this.fill) {
                    componentHeight = Math.max(height - (this.padding.top + this.padding.bottom), 0);
                    componentWidth = component.getPreferredWidth(componentHeight);
                } else {
                    Dimensions preferredComponentSize = component.getPreferredSize();
                    componentWidth = preferredComponentSize.width;
                    componentHeight = preferredComponentSize.height;
                }
                switch (this.verticalAlignment) {
                    case TOP: {
                        y = this.padding.top;
                        break;
                    }
                    case CENTER: {
                        y = (height - componentHeight) / 2;
                        break;
                    }
                    case BOTTOM: {
                        y = height - this.padding.bottom - componentHeight;
                    }
                }
                component.setSize(componentWidth, componentHeight);
                component.setLocation(x, y);
                x += componentWidth + this.spacing;
            }
        } else {
            int preferredHeight = this.getPreferredHeight(this.fill ? width : -1);
            int y = 0;
            switch (this.verticalAlignment) {
                case CENTER: {
                    y = (height - preferredHeight) / 2;
                    break;
                }
                case BOTTOM: {
                    y = height - preferredHeight;
                }
            }
            y += this.padding.top;
            for (int i = 0; i < n; ++i) {
                Component component = boxPane.get(i);
                if (!component.isVisible()) continue;
                int componentWidth = 0;
                int componentHeight = 0;
                int x = 0;
                if (this.fill) {
                    componentWidth = Math.max(width - (this.padding.left + this.padding.right), 0);
                    componentHeight = component.getPreferredHeight(componentWidth);
                } else {
                    Dimensions preferredComponentSize = component.getPreferredSize();
                    componentWidth = preferredComponentSize.width;
                    componentHeight = preferredComponentSize.height;
                }
                switch (this.horizontalAlignment) {
                    case LEFT: {
                        x = this.padding.left;
                        break;
                    }
                    case CENTER: {
                        x = (width - componentWidth) / 2;
                        break;
                    }
                    case RIGHT: {
                        x = width - this.padding.right - componentWidth;
                    }
                }
                component.setSize(componentWidth, componentHeight);
                component.setLocation(x, y);
                y += componentHeight + this.spacing;
            }
        }
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = horizontalAlignment;
        this.invalidateComponent();
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.verticalAlignment = verticalAlignment;
        this.invalidateComponent();
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(padding));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = spacing;
        this.invalidateComponent();
    }

    public final void setSpacing(Number spacing) {
        if (spacing == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(spacing.intValue());
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        this.invalidateComponent();
    }

    @Override
    public void orientationChanged(BoxPane boxPane) {
        this.invalidateComponent();
    }
}

